<?php
/**
 * This file is part of the French language pack for the
 * phpBB forum software.
 *
 * @copyright (c) phpBB Limited <https://www.phpbb.com>
 * @copyright (c) Qiaeru <https://www.qiaeru.com>
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 * For more information about the language pack, please visit
 * https://www.phpbb.com/customise/db/translation/french/
 */

/**
 * DO NOT CHANGE
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, [
	'TRANSLATION_INFO' => '<a href="https://www.phpbb.com/customise/db/translation/french/">Traduction française officielle</a> &copy; <a href="https://www.qiaeru.com">Qiaeru</a>',
	'DIRECTION'        => 'ltr',
	'DATE_FORMAT'      => '|d F Y|', // 01 January 2007 (with Relative days enabled)
	'DATETIME_FORMAT'  => '|d F Y, H:i|', // 01 January 2007, 13:37 (with Relative days enabled)
	'USER_LANG'        => 'fr',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE' => 2,

	'1_DAY'    => '1 jour',
	'1_MONTH'  => '1 mois',
	'1_YEAR'   => '1 an',
	'2_WEEKS'  => '2 semaines',
	'3_MONTHS' => '3 mois',
	'6_MONTHS' => '6 mois',
	'7_DAYS'   => '7 jours',

	'ACCOUNT_ALREADY_ACTIVATED'                          => 'Votre compte a déjà été activé.',
	'ACCOUNT_DEACTIVATED'                                => 'Votre compte a été désactivé manuellement et ne peut être réactivé que par un administrateur.',
	'ACP'                                                => 'Panneau de contrôle d’administration',
	'ACP_SHORT'                                          => 'PCA',
	'ACTIVE'                                             => 'actif',
	'ACTIVE_ERROR'                                       => 'Le nom d’utilisateur que vous avez spécifié est actuellement inactif. Si vous rencontrez des difficultés lors de l’activation de votre compte, veuillez contacter un administrateur du forum.',
	'ADMINISTRATOR'                                      => 'Administrateur',
	'ADMINISTRATORS'                                     => 'Administrateurs',
	'AGE'                                                => 'Âge',
	'AIM'                                                => 'AIM',
	'AJAX_ERROR_TITLE'                                   => 'Erreur AJAX',
	'AJAX_ERROR_TEXT'                                    => 'Une erreur est survenue lors du traitement de votre requête.',
	'AJAX_ERROR_TEXT_ABORT'                              => 'La requête a été interrompue par l’utilisateur.',
	'AJAX_ERROR_TEXT_TIMEOUT'                            => 'Votre requête a expiré prématurément. Veuillez réessayer.',
	'AJAX_ERROR_TEXT_PARSERERROR'                        => 'Une erreur est survenue lors du traitement de votre requête et le serveur a renvoyé une réponse invalide.',
	'ALLOWED'                                            => 'Autorisé',
	'ALL_FILES'                                          => 'Tous les fichiers',
	'ALL_FORUMS'                                         => 'Tous les forums',
	'ALL_MESSAGES'                                       => 'Tous les messages privés',
	'ALL_POSTS'                                          => 'Tous les messages',
	'ALL_TIMES'                                          => 'Fuseau horaire sur <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'                                         => 'Tous les sujets',
	'ALT_TEXT'                                           => 'Texte alternatif',
	'AND'                                                => 'et',
	'ARE_WATCHING_FORUM'                                 => 'Vous êtes à présent abonné à ce forum. Vous recevrez une notification lorsqu’un nouveau sujet sera publié.',
	'ARE_WATCHING_TOPIC'                                 => 'Vous êtes à présent abonné à ce sujet. Vous recevrez une notification lorsqu’un nouveau message sera publié.',
	'ASCENDING'                                          => 'Croissant',
	'ATTACHMENTS'                                        => 'Pièces jointes',
	'ATTACHED_IMAGE_NOT_IMAGE'                           => 'L’image que vous avez souhaité transférer est invalide.',
	'AUTHOR'                                             => 'Auteur',
	'AUTH_NO_PROFILE_CREATED'                            => 'Une erreur est survenue lors de la création du profil de l’utilisateur.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'           => 'Ce service externe est déjà associé à un autre compte de ce forum.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'            => 'L’entrée de la base de données est invalide.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'     => 'Le type de service spécifié dans le gestionnaire de service OAuth est invalide.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'                  => 'Une erreur est survenue lors du traitement de votre requête OAuth.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'                   => 'Le service externe a renvoyé une valeur erronée. Votre demande ne peut donc pas être traitée.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'      => 'Le service OAuth n’a pas été créé',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'                  => 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'               => 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'                 => 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'                => 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'         => 'Le jeton OAuth n’a pas été stocké.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED' => 'Le jeton OAuth n’a pas été stocké correctement.',
	'AVATAR_DISALLOWED_CONTENT'                          => 'Le transfert a été interrompu. Le fichier que vous avez souhaité transférer a été identifié comme une vulnérabilité potentielle.',
	'AVATAR_DISALLOWED_EXTENSION'                        => 'Ce fichier ne peut pas être affiché car l’extension « %s » n’est pas autorisée.',
	'AVATAR_EMPTY_REMOTE_DATA'                           => 'L’avatar que vous avez spécifié n’a pas pu être transféré car les données distantes semblent corrompues ou invalides.',
	'AVATAR_EMPTY_FILEUPLOAD'                            => 'L’avatar que vous avez transféré est vide.',
	'AVATAR_INVALID_FILENAME'                            => 'Le nom de fichier « %s » est invalide.',
	'AVATAR_NOT_UPLOADED'                                => 'Une erreur est survenue lors du transfert de l’avatar.',
	'AVATAR_NO_TEMP_DIR'                                 => 'Le répertoire temporaire est introuvable ou est en lecture seule.',
	'AVATAR_NO_SIZE'                                     => 'La taille de l’avatar lié n’a pas pu être détectée automatiquement. Veuillez la saisir manuellement.',
	'AVATAR_NO_UPLOAD_DIR'                               => 'Le chemin de stockage de l’avatar n’existe pas ou est en lecture seule.',
	'AVATAR_NO_UPLOAD_PATH'                              => 'Le transfert d’avatars est bien activé mais le chemin de stockage de l’avatar n’a pas été spécifié.',
	'AVATAR_PARTIAL_UPLOAD'                              => 'Le fichier que vous avez spécifié n’a pas été totalement transféré.',
	'AVATAR_PHP_SIZE_NA'                                 => 'La taille de l’avatar est trop importante.<br>La taille maximale autorisée, située dans le fichier « php.ini », n’a pas pu être détectée.',
	'AVATAR_PHP_SIZE_OVERRUN'                            => 'La taille de l’avatar est trop importante. La taille maximale autorisée est de %1$d %2$s.<br>Veuillez noter que cette valeur est située dans le fichier « php.ini » et qu’elle ne peut pas être remplacée.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'                       => 'L’avatar que vous avez spécifié n’a pu être transféré car la requête a expiré prématurément.',
	'AVATAR_PHP_UPLOAD_STOPPED'                          => 'Une extension PHP a interrompu le transfert du fichier.',
	'AVATAR_URL_INVALID'                                 => 'Le lien que vous avez spécifié est invalide.',
	'AVATAR_URL_NOT_FOUND'                               => 'Le fichier que vous avez spécifié est introuvable.',
	'AVATAR_WRONG_FILESIZE'                              => 'La taille de l’avatar doit être comprise entre 0 et %1$d %2$s.',
	'AVATAR_WRONG_SIZE'                                  => 'La taille de l’avatar que vous avez transféré est %5$s de large et %6$s de haut. Les avatars doivent mesurer au minimum %1$s de large et %2$s de haut et ne doivent pas dépasser %3$s de large et %4$s de haut.',

	'BACK_TO_TOP'            => 'Haut',
	'BACK_TO_PREV'           => 'Revenir à la page précédente',
	'BAN_TRIGGERED_BY_EMAIL' => 'Votre adresse de courriel a été bannie.',
	'BAN_TRIGGERED_BY_IP'    => 'Votre adresse IP a été bannie.',
	'BAN_TRIGGERED_BY_USER'  => 'Votre nom d’utilisateur a été banni.',
	'BBCODE_GUIDE'           => 'Guide du BBCode',
	'BCC'                    => 'Cci',
	'BIRTHDAYS'              => 'Anniversaires',
	'BOARD_BAN_PERM'         => 'Vous avez été définitivement banni de ce forum.<br><br>Pour plus d’informations, veuillez contacter un %2$sadministrateur du forum%3$s.',
	'BOARD_BAN_REASON'       => 'Raison du bannissement : %s',
	'BOARD_BAN_TIME'         => 'Vous avez été banni de ce forum jusqu’au %1$s.<br><br>Pour plus d’informations, veuillez contacter un %2$sadministrateur du forum%3$s.',
	'BOARD_DISABLE'          => 'Le forum est actuellement indisponible.',
	'BOARD_DISABLED'         => 'Le forum est actuellement désactivé.',
	'BOARD_UNAVAILABLE'      => 'Le forum est temporairement indisponible. Veuillez revenir ultérieurement.',
	'BROWSING_FORUM'         => 'Utilisateurs parcourant ce forum : %1$s',
	'BROWSING_FORUM_GUESTS'  => [
		1 => 'Utilisateurs parcourant ce forum : %2$s et %1$d invité',
		2 => 'Utilisateurs parcourant ce forum : %2$s et %1$d invités',
	],
	'BUTTON_DELETE'       => 'Supprimer',
	'BUTTON_EDIT'         => 'Modifier',
	'BUTTON_FORUM_LOCKED' => 'Verrouillé',
	'BUTTON_INFORMATION'  => 'Information',
	'BUTTON_NEW_TOPIC'    => 'Nouveau sujet',
	'BUTTON_PM'           => 'MP',
	'BUTTON_PM_FORWARD'   => 'Transférer',
	'BUTTON_PM_NEW'       => 'Nouveau message privé',
	'BUTTON_PM_REPLY'     => 'Répondre',
	'BUTTON_PM_REPLY_ALL' => 'Répondre à tous',
	'BUTTON_POST_REPLY'   => 'Répondre',
	'BUTTON_QUOTE'        => 'Citer',
	'BUTTON_REPORT'       => 'Rapporter',
	'BUTTON_TOPIC_LOCKED' => 'Verrouillé',
	'BUTTON_WARN'         => 'Avertir',
	'BYTES'               => 'octets',
	'BYTES_SHORT'         => 'o',

	'CANCEL'               => 'Annuler',
	'CHANGE'               => 'Modifier',
	'CHANGE_FONT_SIZE'     => 'Modifier la taille de la police de caractères',
	'CHANGING_PREFERENCES' => 'Modifie les préférences du forum',
	'CHANGING_PROFILE'     => 'Modifie les paramètres du profil',
	'CHARACTERS'           => [
		1 => '%d caractère',
		2 => '%d caractères',
	],
	'COLLAPSE_VIEW'         => 'Réduire',
	'CLOSE_WINDOW'          => 'Fermer la fenêtre',
	'CODE'                  => 'Code',
	'COLOUR_SWATCH'         => 'Palette de couleurs',
	'COLON'                 => ' :',
	'COMMA_SEPARATOR'       => ', ', // Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'               => 'Confirmer',
	'CONFIRM_CODE'          => 'Code de confirmation',
	'CONFIRM_CODE_EXPLAIN'  => 'Veuillez saisir le code tel qu’il apparaît dans l’image. Les lettres ne sont pas sensibles à la casse.',
	'CONFIRM_CODE_WRONG'    => 'Le code de confirmation que vous avez spécifié est incorrect.',
	'CONFIRM_OPERATION'     => 'Êtes-vous sûr de vouloir effectuer cette opération ?',
	'CONFIRM_AVATAR_DELETE' => 'Êtes-vous sûr de vouloir supprimer cet avatar ?',
	'CONGRATULATIONS'       => 'Félicitations à',
	'CONNECTION_FAILED'     => 'La connexion a échoué.',
	'CONNECTION_SUCCESS'    => 'Vous êtes à présent connecté !',
	'CONTACT'               => 'Contact',
	'CONTACT_USER'          => 'Contacter %s',
	'CONTACT_US'            => 'Nous contacter',
	'COOKIE_CONSENT_INFO'   => 'En savoir plus…',
	'COOKIE_CONSENT_MSG'    => 'En poursuivant votre navigation sur ce site, vous acceptez l’utilisation de cookies vous permettant de bénéficier d’une expérience de navigation optimale.',
	'COOKIE_CONSENT_OK'     => 'J’accepte',
	'COOKIE_CONSENT_HREF'   => 'https://www.cnil.fr/fr/site-web-cookies-et-autres-traceurs',
	'COOKIES_DELETED'       => 'Les cookies du forum ont été supprimés.',
	'CURRENT_TIME'          => 'Nous sommes le %s',

	'DAY'                       => 'jour',
	'DAYS'                      => 'jours',
	'DELETE'                    => 'Supprimer',
	'DELETE_ALL'                => 'Tout supprimer',
	'DELETE_COOKIES'            => 'Supprimer les cookies',
	'DELETE_MARKED'             => 'Supprimer la sélection',
	'DELETE_POST'               => 'Supprimer le message',
	'DELIMITER'                 => 'Séparateur',
	'DESCENDING'                => 'Décroissant',
	'DISABLED'                  => 'Désactivé',
	'DISPLAY'                   => 'Afficher',
	'DISPLAY_GUESTS'            => 'Afficher les invités',
	'DISPLAY_MESSAGES'          => 'Afficher les messages privés publiés depuis',
	'DISPLAY_POSTS'             => 'Afficher les messages publiés depuis',
	'DISPLAY_TOPICS'            => 'Afficher les sujets publiés depuis',
	'DOMAIN_NO_MX_RECORD_EMAIL' => 'Le domaine de cette adresse de courriel ne contient pas d’enregistrement MX valide.',
	'DOWNLOADED'                => 'Téléchargé',
	'DOWNLOADING_FILE'          => 'Téléchargement du fichier',
	'DOWNLOAD_COUNTS'           => [
		0 => 'Téléchargé 0 fois',
		1 => 'Téléchargé %d fois',
		2 => 'Téléchargé %d fois',
	],

	'EDIT_POST'                        => 'Modifier le message',
	'ELLIPSIS'                         => '…',
	'EMAIL'                            => 'Courriel', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'                    => 'Adresse de courriel',
	'EMAIL_INVALID_EMAIL'              => 'L’adresse de courriel que vous avez spécifiée est invalide.',
	'EMAIL_SMTP_ERROR_RESPONSE'        => 'Une erreur est survenue lors de l’envoi du courriel à la ligne %1$s. Réponse : %2$s.',
	'EMPTY_SUBJECT'                    => 'Veuillez saisir le titre du nouveau sujet.',
	'EMPTY_MESSAGE_SUBJECT'            => 'Veuillez saisir le titre du nouveau message privé.',
	'ENABLED'                          => 'Activé',
	'ENCLOSURE'                        => 'Pièce jointe',
	'ENTER_USERNAME'                   => 'Veuillez saisir un nom d’utilisateur',
	'ERR_CHANGING_DIRECTORY'           => 'Une erreur est survenue lors de la modification du répertoire.',
	'ERR_CONNECTING_SERVER'            => 'Une erreur est survenue lors de la connexion au serveur.',
	'ERR_JAB_AUTH'                     => 'Une erreur est survenue lors de l’authentification au serveur Jabber.',
	'ERR_JAB_CONNECT'                  => 'Une erreur est survenue lors de la connexion au serveur Jabber.',
	'ERR_UNABLE_TO_LOGIN'              => 'Le nom d’utilisateur ou le mot de passe que vous avez spécifié est invalide.',
	'ERR_UNWATCHING'                   => 'Une erreur est survenue lors du désabonnement.',
	'ERR_WATCHING'                     => 'Une erreur est survenue lors de l’abonnement.',
	'ERR_WRONG_PATH_TO_PHPBB'          => 'Le chemin que vous avez spécifié est invalide.',
	'ERROR'                            => 'Erreur',
	'EXPAND_VIEW'                      => 'Agrandir',
	'EXTENSION'                        => 'Extension',
	'EXTENSION_DISABLED'               => 'L’extension « %s » est désactivée.',
	'EXTENSION_DISABLED_AFTER_POSTING' => 'L’extension « %s » a été désactivée et ne peut plus être affichée.',
	'EXTENSION_DOES_NOT_EXIST'         => 'L’extension « %s » est introuvable.',

	'FACEBOOK'              => 'Facebook',
	'FAQ'                   => 'FAQ',
	'FAQ_EXPLAIN'           => 'Foire aux questions',
	'FEATURE_NOT_AVAILABLE' => 'Cette fonctionnalité n’est pas disponible sur ce forum.',
	'FILENAME'              => 'Nom du fichier',
	'FILESIZE'              => 'Taille du fichier',
	'FILEDATE'              => 'Date du fichier',
	'FILE_COMMENT'          => 'Description du fichier',
	'FILE_CONTENT_ERR'      => 'Impossible de lire le contenu de ce fichier : %s',
	'FILE_JSON_DECODE_ERR'  => 'Impossible de déchiffrer le fichier JSON : %s',
	'FILE_NOT_FOUND'        => 'Le fichier que vous recherchez est introuvable : %s',
	'FIND_USERNAME'         => 'Trouver un membre',
	'FOLDER'                => 'Boîte',
	'FORGOT_PASS'           => 'J’ai oublié mon mot de passe',
	'FORM_INVALID'          => 'Une erreur est survenue lors de l’envoi du formulaire. Veuillez réessayer.',
	'FORUM'                 => 'Forum',
	'FORUMS'                => 'Forums',
	'FORUMS_MARKED'         => 'Les forums ont été marqués comme lus.',
	'FORUM_CAT'             => 'Catégorie du forum',
	'FORUM_INDEX'           => 'Accueil du forum',
	'FORUM_LINK'            => 'Forum-lien',
	'FORUM_LOCATION'        => 'Emplacement du forum',
	'FORUM_LOCKED'          => 'Forum verrouillé',
	'FORUM_RULES'           => 'Règles du forum',
	'FORUM_RULES_LINK'      => 'Veuillez cliquer ici afin de consulter les règles du forum',
	'FROM'                  => 'de',
	'FSOCK_DISABLED'        => 'L’opération a échoué car la fonction « fsockopen » est désactivée ou le serveur interrogé est introuvable.',
	'FSOCK_TIMEOUT'         => 'Le délai de réponse a expiré lors de la lecture du flux réseau.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'       => 'Impossible de modifier le groupe du fichier',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS' => 'Impossible de modifier les permissions du fichier',
	'FILESYSTEM_CANNOT_COPY_FILES'              => 'Impossible de copier les fichiers',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'          => 'Impossible de créer un lien symbolique',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'        => 'Impossible de créer le répertoire',
	'FILESYSTEM_CANNOT_DELETE_FILES'            => 'Impossible de supprimer les fichiers du système',
	'FILESYSTEM_CANNOT_DUMP_FILE'               => 'Impossible de vider le contenu du fichier',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'        => 'Impossible de répliquer le répertoire',
	'FILESYSTEM_CANNOT_RENAME_FILE'             => 'Impossible de renommer un fichier du système',
	'FILESYSTEM_CANNOT_TOUCH_FILES'             => 'Impossible de créer ou de modifier les horodatages des fichiers',

	'FTP_FSOCK_HOST'              => 'Hôte FTP',
	'FTP_FSOCK_HOST_EXPLAIN'      => 'Le serveur FTP qui est utilisé afin de vous connecter à votre site.',
	'FTP_FSOCK_PASSWORD'          => 'Mot de passe FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'  => 'Le mot de passe qui est affilié à votre nom d’utilisateur FTP.',
	'FTP_FSOCK_PORT'              => 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'      => 'Le port qui est utilisé afin de vous connecter à votre serveur.',
	'FTP_FSOCK_ROOT_PATH'         => 'Chemin vers le forum',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN' => 'Le chemin relatif à la racine de votre serveur.',
	'FTP_FSOCK_TIMEOUT'           => 'Délai d’attente FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'   => 'Le nombre de secondes que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_FSOCK_USERNAME'          => 'Nom d’utilisateur FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'  => 'Le nom d’utilisateur qui est utilisé afin de vous connecter à votre serveur.',

	'FTP_HOST'              => 'Hôte FTP',
	'FTP_HOST_EXPLAIN'      => 'Le serveur FTP qui est utilisé afin de vous connecter à votre site.',
	'FTP_PASSWORD'          => 'Mot de passe FTP',
	'FTP_PASSWORD_EXPLAIN'  => 'Le mot de passe qui est affilié à votre nom d’utilisateur FTP.',
	'FTP_PORT'              => 'Port FTP',
	'FTP_PORT_EXPLAIN'      => 'Le port qui est utilisé afin de vous connecter à votre serveur.',
	'FTP_ROOT_PATH'         => 'Chemin vers le forum',
	'FTP_ROOT_PATH_EXPLAIN' => 'Le chemin relatif à la racine de votre serveur.',
	'FTP_TIMEOUT'           => 'Délai d’attente FTP',
	'FTP_TIMEOUT_EXPLAIN'   => 'Le nombre de secondes que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_USERNAME'          => 'Nom d’utilisateur FTP',
	'FTP_USERNAME_EXPLAIN'  => 'Le nom d’utilisateur qui est utilisé afin de vous connecter à votre serveur.',

	'GENERAL_ERROR'       => 'Erreur générale',
	'GB'                  => 'Go',
	'GIB'                 => 'Gio',
	'GO'                  => 'Aller',
	'GOTO_FIRST_POST'     => 'Aller au premier message',
	'GOTO_LAST_POST'      => 'Aller au dernier message',
	'GOTO_PAGE'           => 'Aller à la page',
	'GROUP'               => 'Groupe',
	'GROUPS'              => 'Groupes',
	'GROUP_ERR_TYPE'      => 'Le type de groupe que vous avez spécifié est invalide.',
	'GROUP_ERR_USERNAME'  => 'Vous devez saisir le nom du groupe.',
	'GROUP_ERR_USER_LONG' => 'Le nom de groupe que vous avez saisi est trop long. Les noms de groupe ne doivent pas dépasser 60 caractères.',
	'GUEST'               => 'Invité',
	'GUEST_USERS_ONLINE'  => [
		1 => 'Il y a %d invité en ligne',
		2 => 'Il y a %d invités en ligne',
	],
	'GUEST_USERS_TOTAL' => [
		1 => '%d invité',
		2 => '%d invités',
	],
	'G_ADMINISTRATORS'    => 'Administrateurs',
	'G_BOTS'              => 'Robots',
	'G_GUESTS'            => 'Invités',
	'G_REGISTERED'        => 'Utilisateurs inscrits',
	'G_REGISTERED_COPPA'  => 'Utilisateurs COPPA inscrits',
	'G_GLOBAL_MODERATORS' => 'Modérateurs généraux',
	'G_NEWLY_REGISTERED'  => 'Utilisateurs nouvellement inscrits',

	'HIDDEN_USERS_ONLINE' => [
		1 => '%d utilisateur invisible',
		2 => '%d utilisateurs invisibles',
	],
	'HIDDEN_USERS_TOTAL' => [
		1 => '%d invisible',
		2 => '%d invisibles',
	],
	'HIDE_GUESTS' => 'Masquer les invités',
	'HIDE_ME'     => 'Masquer ma présence lors de cette session',
	'HOURS'       => 'Heures',
	'HOME'        => 'Accueil',

	'ICQ'                      => 'ICQ',
	'IF'                       => 'Si',
	'IMAGE'                    => 'Image',
	'IMAGE_FILETYPE_INVALID'   => 'Le type d’image « %d » du standard MIME « %s » n’est pas pris en charge.',
	'IMAGE_FILETYPE_MISMATCH'  => 'Le type d’image ne correspond pas. L’extension « %1$s » était attendue mais l’extension « %2$s » a été transférée.',
	'IN'                       => 'dans',
	'INACTIVE'                 => 'Inactif',
	'INDEX'                    => 'Page d’accueil',
	'INFORMATION'              => 'Information',
	'INSECURE_REDIRECT'        => 'Redirection vers un lien potentiellement insécurisé.',
	'INTERESTS'                => 'Centres d’intérêt',
	'INVALID_DIGEST_CHALLENGE' => 'Le Digest Challenge est invalide.',
	'INVALID_EMAIL_LOG'        => 'L’adresse de courriel « %s » est potentiellement invalide.',
	'INVALID_FEED_ATTACHMENTS' => 'Le flux sélectionné a tenté d’extraire des pièces jointes contenant des contraintes invalides.',
	'INVALID_PLURAL_RULE'      => 'Cette règle de pluriel est invalide. Seuls les nombres entiers compris entre 0 et 15 sont autorisés.',
	'IP'                       => 'IP',
	'IP_BLACKLISTED'           => 'Votre adresse IP %1$s a été bloquée car elle est présente dans la liste noire. Pour plus d’informations, veuillez consulter <a href="%2$s">%2$s</a>.',

	'JABBER'             => 'Jabber',
	'JOINED'             => 'Inscription',
	'JUMP_PAGE'          => 'Saisissez le numéro de la page que vous souhaitez atteindre',
	'JUMP_TO'            => 'Aller',
	'JUMP_TO_PAGE'       => 'Aller sur la page',
	'JUMP_TO_PAGE_CLICK' => 'Cliquez ici afin d’atteindre une page…',

	'KB'  => 'Ko',
	'KIB' => 'Kio',

	'LAST_POST'                                => 'Dernier message',
	'LAST_UPDATED'                             => 'Dernière mise à jour',
	'LAST_VISIT'                               => 'Dernière visite',
	'LDAP_NO_LDAP_EXTENSION'                   => 'L’extension LDAP est indisponible.',
	'LDAP_NO_SERVER_CONNECTION'                => 'Une erreur est survenue lors de la connexion au serveur LDAP.',
	'LDAP_SEARCH_FAILED'                       => 'Le répertoire LDAP est introuvable.',
	'LEGEND'                                   => 'Légende',
	'LIVE_SEARCHES_NOT_ALLOWED'                => 'Les prédictions de recherche ne sont pas autorisées.',
	'LOADING'                                  => 'Chargement…',
	'LOCATION'                                 => 'Localisation',
	'LOCK_POST'                                => 'Verrouiller le message',
	'LOCK_POST_EXPLAIN'                        => 'Il ne pourra plus être modifié',
	'LOCK_TOPIC'                               => 'Verrouiller le sujet',
	'LOGIN'                                    => 'Connexion',
	'LOGIN_CHECK_PM'                           => 'Connectez-vous afin de consulter vos messages privés.',
	'LOGIN_CONFIRMATION'                       => 'Confirmation de connexion',
	'LOGIN_CONFIRM_EXPLAIN'                    => 'Pour des raisons de sécurité, vous devez saisir un code de confirmation après avoir échoué plusieurs fois lors de vos tentatives de connexion. Le code est affiché dans l’image affichée ci-dessous. Si vous éprouvez des difficultés à lire ce code correctement, veuillez contacter un %sadministrateur du forum%s.', // Unused
	'LOGIN_ERROR_ATTEMPTS'                     => 'Vous avez dépassé le nombre maximal de tentatives de connexion autorisées. En plus de renseigner votre nom d’utilisateur et de votre mot de passe, vous devez également passer le test CAPTCHA.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'         => 'Une erreur est survenue lors de votre authentification par Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST' => 'Le service OAuth est introuvable.',
	'LOGIN_ERROR_PASSWORD'                     => 'Le mot de passe que vous avez spécifié est incorrect. Veuillez vérifier votre mot de passe et réessayer. Si ce problème persiste, veuillez contacter un %sadministrateur du forum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'             => 'La conversion de votre mot de passe a échoué lors de la mise à jour du logiciel de ce forum de discussions. Veuillez %sdemander un nouveau mot de passe%s. Si ce problème persiste, veuillez %scontacter un administrateur du forum%s.',
	'LOGIN_ERROR_USERNAME'                     => 'Le nom d’utilisateur que vous avez spécifié est incorrect. Veuillez vérifier votre nom d’utilisateur et réessayer. Si ce problème persiste, veuillez contacter un %sadministrateur du forum%s.',
	'LOGIN_FORUM'                              => 'Vous devez saisir le mot de passe de ce forum afin de consulter et de publier des sujets et des messages.',
	'LOGIN_INFO'                               => 'Vous devez être inscrit avant de pouvoir vous connecter. L’inscription est rapide et vous offre de nombreux avantages. Les administrateurs du forum peuvent accorder des fonctionnalités supplémentaires aux utilisateurs inscrits. Avant de vous inscrire, assurez-vous d’avoir pris connaissance de nos conditions d’utilisation et de notre politique de confidentialité. Veuillez également prendre le temps de consulter attentivement toutes les règles du forum lors de votre navigation.',
	'LOGIN_VIEWFORUM'                          => 'Vous devez être inscrit et connecté afin de pouvoir consulter ce forum.',
	'LOGIN_EXPLAIN_EDIT'                       => 'Vous devez être inscrit et connecté afin de pouvoir modifier les messages de ce forum.',
	'LOGIN_EXPLAIN_VIEWONLINE'                 => 'Vous devez être inscrit et connecté afin de pouvoir consulter la liste des utilisateurs en ligne.',
	'LOGIN_REQUIRED'                           => 'Vous devez être connecté afin d’effectuer cette opération.',
	'LOGOUT'                                   => 'Déconnexion',
	'LOGOUT_USER'                              => 'Déconnexion [ %s ]',
	'LOG_ME_IN'                                => 'Se souvenir de moi',

	'MAIN'                => 'Général',
	'MARK'                => 'Cocher',
	'MARK_ALL'            => 'Tout cocher',
	'MARK_ALL_READ'       => 'Tout marquer comme lu',
	'MARK_FORUMS_READ'    => 'Marquer tous les forums comme lus',
	'MARK_READ'           => 'Marquer comme lu',
	'MARK_SUBFORUMS_READ' => 'Marquer tous les sous-forums comme lus',
	'MB'                  => 'Mo',
	'MIB'                 => 'Mio',
	'MCP'                 => 'Panneau de contrôle du modérateur',
	'MCP_SHORT'           => 'PCM',
	'MEMBERLIST'          => 'Membres',
	'MEMBERLIST_EXPLAIN'  => 'La liste complète des membres du forum',
	'MERGE'               => 'Fusionner',
	'MERGE_POSTS'         => 'Déplacer les messages',
	'MERGE_TOPIC'         => 'Fusionner le sujet',
	'MESSAGE'             => 'Message',
	'MESSAGES'            => 'Messages',
	'MESSAGES_COUNT'      => [
		0 => 'Messages illimités',
		1 => '%d message',
		2 => '%d messages',
	],
	'MESSAGE_BODY'                => 'Corps du message',
	'MINUTES'                     => 'minutes',
	'MODERATE'                    => 'Modérer',
	'MODERATOR'                   => 'Modérateur',
	'MODERATORS'                  => 'Modérateurs',
	'MODULE_NOT_ACCESS'           => 'Le module est inaccessible',
	'MODULE_NOT_FIND'             => 'Le module « %s » est introuvable',
	'MODULE_FILE_INCORRECT_CLASS' => 'Le fichier du module « %s » ne contient pas la classe « %s »',
	'MONTH'                       => 'Mois',
	'MOVE'                        => 'Déplacer',

	'NA'                       => 'ND',
	'NEWEST_USER'              => 'Notre membre le plus récent est <strong>%s</strong>',
	'NEW_MESSAGE'              => 'Nouveau message',
	'NEW_MESSAGES'             => 'Nouveaux messages',
	'NEW_POST'                 => 'Nouveau message', // Not used anymore
	'NEW_POSTS'                => 'Nouveaux messages', // Not used anymore
	'NEXT'                     => 'Suivant', // Used in pagination
	'NEXT_STEP'                => 'Suivant',
	'NEVER'                    => 'Jamais',
	'NO'                       => 'Non',
	'NO_NOTIFICATIONS'         => 'Aucune notification.',
	'NOT_ALLOWED_MANAGE_GROUP' => 'Vous ne pouvez pas gérer ce groupe.',
	'NOT_AUTHORISED'           => 'Vous ne pouvez pas accéder à cette page.',
	'NOT_WATCHING_FORUM'       => 'Vous n’êtes à présent plus abonné à ce forum. Vous ne recevrez plus de notification lorsqu’un nouveau sujet sera publié.',
	'NOT_WATCHING_TOPIC'       => 'Vous n’êtes à présent plus abonné à ce sujet. Vous ne recevrez plus de notification lorsqu’un nouveau message sera publié.',
	'NOTIFICATIONS'            => 'Notifications',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK' => [
		1 => '<strong>Publication d’un message</strong> par %1$s dans le sujet ajouté aux favoris :',
		2 => '<strong>Publication de messages</strong> par %1$s dans le sujet ajouté aux favoris :',
	],
	'NOTIFICATION_FORUM'                  => '<em>Forum :</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'          => '<strong>Demande d’invitation</strong> par %1$s afin de rejoindre le groupe %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED' => '<strong>Demande d’invitation approuvée</strong> afin de rejoindre le groupe %1$s.',
	'NOTIFICATION_METHOD_INVALID'         => 'La méthode « %s » ne fait pas référence à une méthode de notification valide.',
	'NOTIFICATION_PM'                     => '<strong>Réception d’un message privé</strong> par %1$s :',
	'NOTIFICATION_POST'                   => [
		1 => '<strong>Publication d’un message</strong> par %1$s dans le sujet :',
		2 => '<strong>Publication de messages</strong> par %1$s dans le sujet :',
	],
	'NOTIFICATION_POST_APPROVED'    => '<strong>Approbation d’un message</strong> :',
	'NOTIFICATION_POST_DISAPPROVED' => '<strong>Désapprobation d’un message</strong> :',
	'NOTIFICATION_POST_IN_QUEUE'    => '<strong>Demande d’approbation d’un message</strong> par %1$s :',
	'NOTIFICATION_QUOTE'            => [
		1 => '<strong>Citation</strong> par %1$s dans :',
		2 => '<strong>Citations</strong> par %1$s dans :',
	],
	'NOTIFICATION_REFERENCE'           => '« %1$s »',
	'NOTIFICATION_REASON'              => '<em>Raison :</em> %1$s.',
	'NOTIFICATION_REPORT_PM'           => '<strong>Rapport d’un message privé</strong> par %1$s :',
	'NOTIFICATION_REPORT_PM_CLOSED'    => '<strong>Rapport d’un message privé clôturé</strong> par %1$s :',
	'NOTIFICATION_REPORT_POST'         => '<strong>Rapport d’un message</strong> par %1$s :',
	'NOTIFICATION_REPORT_CLOSED'       => '<strong>Clôture d’un rapport</strong> par %1$s pour :',
	'NOTIFICATION_TOPIC'               => '<strong>Publication d’un sujet</strong> par %1$s :',
	'NOTIFICATION_TOPIC_APPROVED'      => '<strong>Approbation d’un sujet</strong> :',
	'NOTIFICATION_TOPIC_DISAPPROVED'   => '<strong>Désapprobation d’un sujet</strong> :',
	'NOTIFICATION_TOPIC_IN_QUEUE'      => '<strong>Demande d’approbation d’un sujet</strong> par %1$s :',
	'NOTIFICATION_TYPE_NOT_EXIST'      => 'Le type de notification « %s » est introuvable dans le système de fichiers.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER' => '<strong>Demande d’activation</strong> par un utilisateur désactivé ou nouvellement inscrit : « %1$s »',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS' => 'plusieurs autres utilisateurs',
	'NOTIFICATION_X_OTHERS'    => [
		1 => '%d autre utilisateur',
		2 => '%d autres utilisateurs',
	],
	'NOTIFY_ADMIN'              => 'Veuillez contacter un administrateur du forum.',
	'NOTIFY_ADMIN_EMAIL'        => 'Veuillez contacter un administrateur du forum : <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'      => 'Vous ne pouvez pas accéder à ce fichier.',
	'NO_ACTION'                 => 'Aucune opération n’a été sélectionnée.',
	'NO_ADMINISTRATORS'         => 'Aucun administrateur.',
	'NO_AUTH_ADMIN'             => 'Vous ne pouvez pas accéder au panneau de contrôle d’administration.',
	'NO_AUTH_ADMIN_USER_DIFFER' => 'Vous ne pouvez pas vous authentifier de nouveau avec un compte d’utilisateur différent du vôtre.',
	'NO_AUTH_OPERATION'         => 'Vous ne pouvez pas effectuer cette opération.',
	'NO_AVATARS'                => 'Aucun avatar n’est disponible',
	'NO_CONNECT_TO_SMTP_HOST'   => 'Une erreur est survenue lors de la connexion à l’hôte du protocole SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'              => 'Aucun membre ne fête son anniversaire aujourd’hui.',
	'NO_EMAIL_MESSAGE'          => 'Ce courriel ne contient aucun contenu.',
	'NO_EMAIL_RESPONSE_CODE'    => 'Une erreur est survenue lors de la récupération des codes de réponse du serveur de la messagerie électronique.',
	'NO_EMAIL_SUBJECT'          => 'Vous devez saisir le sujet du courriel.',
	'NO_FORUM'                  => 'Le forum que vous souhaitez consulter est introuvable.',
	'NO_FORUMS'                 => 'Aucun forum.',
	'NO_GROUP'                  => 'Le groupe d’utilisateurs que vous souhaitez consulter est introuvable.',
	'NO_GROUP_MEMBERS'          => 'Ce groupe d’utilisateurs ne contient aucun membre.',
	'NO_IPS_DEFINED'            => 'Aucun nom d’hôte ou adresse IP n’a été spécifié.',
	'NO_MEMBERS'                => 'Aucun membre ne correspond à ce critère.',
	'NO_MESSAGES'               => 'Aucun message',
	'NO_MODE'                   => 'Aucun mode n’a été sélectionné.',
	'NO_MODERATORS'             => 'Aucun modérateur.',
	'NO_NEW_MESSAGES'           => 'Aucun nouveau message',
	'NO_NEW_POSTS'              => 'Aucun nouveau message', // Not used anymore
	'NO_ONLINE_USERS'           => 'Aucun utilisateur inscrit',
	'NO_POSTS'                  => 'Aucun message',
	'NO_POSTS_TIME_FRAME'       => 'Aucun message n’a été publié dans ce sujet lors de cette période.',
	'NO_FEED_ENABLED'           => 'Les flux ne sont pas disponibles sur ce forum.',
	'NO_FEED'                   => 'Le flux que vous souhaitez consulter n’est pas disponible.',
	'NO_STYLE_DATA'             => 'Impossible d’accéder aux données du style concernant l’« user_style » %s paramétré pour le « user_id » %s',
	'NO_STYLE_CFG'              => 'Impossible d’accéder au fichier de configuration du style concernant : %s',
	'NO_SUBJECT'                => 'Aucun sujet n’a été spécifié', // Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'     => 'Le module de recherche que vous avez spécifié est introuvable.',
	'NO_SUPPORTED_AUTH_METHODS' => 'Aucune méthode d’authentification n’est prise en charge.',
	'NO_TOPIC'                  => 'Le sujet que vous souhaitez consulter est introuvable.',
	'NO_TOPIC_FORUM'            => 'Le forum ou le sujet que vous souhaitez consulter est introuvable.',
	'NO_TOPICS'                 => 'Aucun sujet n’a été publié dans ce forum.',
	'NO_TOPICS_TIME_FRAME'      => 'Aucun sujet n’a été publié dans ce forum lors de cette période.',
	'NO_UNREAD_POSTS'           => 'Aucun message non lu',
	'NO_UPLOAD_FORM_FOUND'      => 'Le transfert a démarré mais le formulaire de transfert de fichiers est introuvable.',
	'NO_USER'                   => 'L’utilisateur que vous souhaitez consulter est introuvable.',
	'NO_USERS'                  => 'Les utilisateurs que vous souhaitez consulter sont introuvables.',
	'NO_USER_SPECIFIED'         => 'Aucun nom d’utilisateur n’a été spécifié.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS' => [
		1 => '%d pièce jointe',
		2 => '%d pièces jointes',
	],
	'NUM_POSTS_IN_QUEUE' => [
		0 => 'Aucun message en attente', // 0
		1 => '1 message en attente', // 1
		2 => '%d messages en attente', // 2+
	],

	'OCCUPATION'     => 'Profession',
	'OFFLINE'        => 'Hors-ligne',
	'ONLINE'         => 'En ligne',
	'ONLINE_BUDDIES' => 'Amis en ligne',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL' => [
		1 => 'Au total, il y a <strong>%1$d</strong> utilisateur en ligne :: %2$s et %3$s',
		2 => 'Au total, il y a <strong>%1$d</strong> utilisateurs en ligne :: %2$s et %3$s',
	],
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS' => [
		1 => 'Au total, il y a <strong>%1$d</strong> utilisateur en ligne :: %2$s, %3$s et %4$s',
		2 => 'Au total, il y a <strong>%1$d</strong> utilisateurs en ligne :: %2$s, %3$s et %4$s',
	],
	'OPTIONS' => 'Options',

	'PAGE_NOT_FOUND'    => 'La page demandée est introuvable.',
	'PAGE_OF'           => 'Page <strong>%1$d</strong> sur <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER' => 'Page %s',
	'PASSWORD'          => 'Mot de passe',
	'PIXEL'             => 'px',
	'PIXELS'            => [
		1 => '%d pixel',
		2 => '%d pixels',
	],
	'PLEASE_WAIT'             => 'Veuillez patienter.',
	'PM'                      => 'MP',
	'PM_REPORTED'             => 'Cliquez ici afin de consulter le rapport',
	'POSTING_MESSAGE'         => 'Rédige un message dans %s',
	'POSTING_PRIVATE_MESSAGE' => 'Rédige un message privé',
	'POST'                    => 'Message',
	'POST_ANNOUNCEMENT'       => 'Annonce',
	'POST_STICKY'             => 'Note',
	'POSTED'                  => 'Publié',
	'POSTED_IN_FORUM'         => 'dans',
	'POSTED_ON_DATE'          => 'le',
	'POSTS'                   => 'Messages',
	'POSTS_UNAPPROVED'        => 'Au moins un message de ce sujet n’a pas été approuvé.',
	'POSTS_UNAPPROVED_FORUM'  => 'Au moins un message de ce forum n’a pas été approuvé.',
	'POST_BY_AUTHOR'          => 'par',
	'POST_BY_FOE'             => '<strong>%1$s</strong>, qui est actuellement dans votre liste d’utilisateurs ignorés, a publié ce message.',
	'POST_DISPLAY'            => 'Afficher ce message',
	'POST_DAY'                => '%.2f messages par jour',
	'POST_DELETED_ACTION'     => 'Message supprimé :',
	'POST_DELETED'            => 'Ce message a été supprimé.',
	'POST_DELETED_BY'         => '<strong>%2$s</strong> a supprimé le message publié par <strong>%1$s</strong> le %3$s.',
	'POST_DELETED_BY_REASON'  => '<strong>%2$s</strong> a supprimé le message publié par <strong>%1$s</strong> le %3$s pour la raison suivante : %4$s',
	'POST_DETAILS'            => 'Informations sur le message',
	'POST_NEW_TOPIC'          => 'Publier un nouveau sujet',
	'POST_PCT'                => '%.2f %% de tous les messages',
	'POST_PCT_ACTIVE'         => '%.2f %% de tous les messages de l’utilisateur',
	'POST_PCT_ACTIVE_OWN'     => '%.2f %% de tous vos messages',
	'POST_REPLY'              => 'Répondre',
	'POST_REPORTED'           => 'Cliquez ici afin de consulter le rapport',
	'POST_SUBJECT'            => 'Sujet du message',
	'POST_TIME'               => 'Date du message',
	'POST_TOPIC'              => 'Publier un nouveau sujet',
	'POST_UNAPPROVED_ACTION'  => 'Message en attente d’approbation :',
	'POST_UNAPPROVED'         => 'Ce message n’a pas été approuvé.',
	'POST_UNAPPROVED_EXPLAIN' => 'Ce message ne sera visible aux autres utilisateurs que lorsqu’il sera approuvé.',
	'POWERED_BY'              => 'Développé par %s',

	'QUOTE' => 'Citation',

	'PREVIEW'           => 'Prévisualiser',
	'PREVIOUS'          => 'Précédent', // Used in pagination
	'PREVIOUS_STEP'     => 'Précédent',
	'PRIVACY'           => 'Politique de confidentialité',
	'PRIVACY_LINK'      => 'Confidentialité',
	'PRIVATE_MESSAGE'   => 'Message privé',
	'PRIVATE_MESSAGES'  => 'Messages privés',
	'PRIVATE_MESSAGING' => 'Messagerie privée',
	'PROFILE'           => 'Panneau de contrôle de l’utilisateur',

	'QUICK_LINKS' => 'Raccourcis',

	'RANK'                    => 'Rang',
	'READING_FORUM'           => 'Consulte des sujets dans %s',
	'READING_GLOBAL_ANNOUNCE' => 'Consulte une annonce générale',
	'READING_LINK'            => 'Visite le forum-lien %s',
	'READING_TOPIC'           => 'Consulte un sujet dans %s',
	'READ_PROFILE'            => 'Profil',
	'REASON'                  => 'Raison',
	'RECORD_ONLINE_USERS'     => 'Le nombre maximal d’utilisateurs en ligne simultanément a été de <strong>%1$s</strong> le %2$s',
	'REDIRECT'                => 'Redirection',
	'REDIRECTS'               => 'Nombre total de redirections',
	'REGISTER'                => 'Inscription',
	'REGISTERED_USERS'        => 'Utilisateurs inscrits :',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE' => [
		1 => 'Il y a %1$d utilisateur inscrit et %2$s en ligne',
		2 => 'Il y a %1$d utilisateurs inscrits et %2$s en ligne',
	],
	'REG_USERS_TOTAL' => [
		1 => '%d inscrit',
		2 => '%d inscrits',
	],
	'REMOVE'                   => 'Supprimer',
	'REMOVE_INSTALL'           => 'Veuillez supprimer, déplacer ou renommer le répertoire « install/ » de votre serveur. Seul le panneau de contrôle d’administration sera accessible tant que ce répertoire est présent.',
	'REPLIES'                  => 'Réponses',
	'REPLY_WITH_QUOTE'         => 'Répondre en citant le message',
	'REPLYING_GLOBAL_ANNOUNCE' => 'Répond à une annonce générale',
	'REPLYING_MESSAGE'         => 'Répond à un message dans %s',
	'REPORT_BY'                => 'Rapporté par',
	'REPORT_POST'              => 'Rapporter le message',
	'REPORTING_POST'           => 'Rapporte un message',
	'RESEND_ACTIVATION'        => 'Renvoyer le courriel d’activation',
	'RESET'                    => 'Réinitialiser',
	'RESTORE_PERMISSIONS'      => 'Restaurer les permissions',
	'RETURN_INDEX'             => '%sRevenir à la page d’accueil%s',
	'RETURN_FORUM'             => '%sRevenir au dernier forum visité%s',
	'RETURN_PAGE'              => '%sRevenir à la page précédente%s',
	'RETURN_TOPIC'             => '%sRevenir au dernier sujet visité%s',
	'RETURN_TO'                => 'Revenir à « %s »',
	'RETURN_TO_INDEX'          => 'Revenir à l’accueil du forum',
	'FEED'                     => 'Flux',
	'FEED_NEWS'                => 'Nouveautés',
	'FEED_TOPICS_ACTIVE'       => 'Sujets actifs',
	'FEED_TOPICS_NEW'          => 'Nouveaux sujets',
	'RULES_ATTACH_CAN'         => 'Vous <strong>pouvez</strong> transférer des pièces jointes dans ce forum',
	'RULES_ATTACH_CANNOT'      => 'Vous <strong>ne pouvez pas</strong> transférer de pièces jointes dans ce forum',
	'RULES_DELETE_CAN'         => 'Vous <strong>pouvez</strong> supprimer vos messages dans ce forum',
	'RULES_DELETE_CANNOT'      => 'Vous <strong>ne pouvez pas</strong> supprimer vos messages dans ce forum',
	'RULES_DOWNLOAD_CAN'       => 'Vous <strong>pouvez</strong> télécharger des pièces jointes dans ce forum',
	'RULES_DOWNLOAD_CANNOT'    => 'Vous <strong>ne pouvez pas</strong> télécharger de pièces jointes dans ce forum',
	'RULES_EDIT_CAN'           => 'Vous <strong>pouvez</strong> modifier vos messages dans ce forum',
	'RULES_EDIT_CANNOT'        => 'Vous <strong>ne pouvez pas</strong> modifier vos messages dans ce forum',
	'RULES_LOCK_CAN'           => 'Vous <strong>pouvez</strong> verrouiller vos sujets dans ce forum',
	'RULES_LOCK_CANNOT'        => 'Vous <strong>ne pouvez pas</strong> verrouiller vos sujets dans ce forum',
	'RULES_POST_CAN'           => 'Vous <strong>pouvez</strong> publier de nouveaux sujets dans ce forum',
	'RULES_POST_CANNOT'        => 'Vous <strong>ne pouvez pas</strong> publier de nouveaux sujets dans ce forum',
	'RULES_REPLY_CAN'          => 'Vous <strong>pouvez</strong> répondre aux sujets dans ce forum',
	'RULES_REPLY_CANNOT'       => 'Vous <strong>ne pouvez pas</strong> répondre aux sujets dans ce forum',
	'RULES_VOTE_CAN'           => 'Vous <strong>pouvez</strong> voter aux sondages dans ce forum',
	'RULES_VOTE_CANNOT'        => 'Vous <strong>ne pouvez pas</strong> voter aux sondages dans ce forum',

	'SEARCH'                   => 'Rechercher',
	'SEARCH_MINI'              => 'Rechercher…',
	'SEARCH_ADV'               => 'Recherche avancée',
	'SEARCH_ADV_EXPLAIN'       => 'Accéder aux paramètres avancés de la recherche',
	'SEARCH_KEYWORDS'          => 'Rechercher par mots-clés',
	'SEARCHING_FORUMS'         => 'Recherche dans les forums',
	'SEARCH_ACTIVE_TOPICS'     => 'Sujets actifs',
	'SEARCH_FOR'               => 'Rechercher',
	'SEARCH_FORUM'             => 'Rechercher…',
	'SEARCH_NEW'               => 'Nouveaux messages',
	'SEARCH_POSTS_BY'          => 'Rechercher les messages de',
	'SEARCH_SELF'              => 'Vos messages',
	'SEARCH_TOPIC'             => 'Rechercher…',
	'SEARCH_UNANSWERED'        => 'Sujets sans réponse',
	'SEARCH_UNREAD'            => 'Messages non lus',
	'SEARCH_USER_POSTS'        => 'Rechercher les messages de l’utilisateur',
	'SECONDS'                  => 'secondes',
	'SEE_ALL'                  => 'Tout consulter',
	'SELECT'                   => 'Sélectionner',
	'SELECT_ALL_CODE'          => 'Tout sélectionner',
	'SELECT_DESTINATION_FORUM' => 'Veuillez sélectionner un forum de destination',
	'SELECT_FORUM'             => 'Sélectionner un forum',
	'SEND_EMAIL'               => 'Envoyer un courriel', // Used for submit buttons
	'SEND_EMAIL_USER'          => 'Envoyer un courriel à %s',
	'SEND_PRIVATE_MESSAGE'     => 'Envoyer un message privé',
	'SETTINGS'                 => 'Paramètres',
	'SIGNATURE'                => 'Signature',
	'SKIP'                     => 'Accéder au contenu',
	'SKYPE'                    => 'Skype',
	'SMTP_NO_AUTH_SUPPORT'     => 'Une erreur est survenue lors de l’authentification par le serveur SMTP.',
	'SORRY_AUTH_READ'          => 'Vous ne pouvez pas consulter ce forum.',
	'SORRY_AUTH_READ_TOPIC'    => 'Vous ne pouvez pas consulter ce sujet.',
	'SORRY_AUTH_VIEW_ATTACH'   => 'Vous ne pouvez pas télécharger cette pièce jointe.',
	'SORT_BY'                  => 'Trier par',
	'SORT_DIRECTION'           => 'Ordre',
	'SORT_JOINED'              => 'Date d’inscription',
	'SORT_LOCATION'            => 'Localisation',
	'SORT_OPTIONS'             => 'Options d’affichage et de tri',
	'SORT_RANK'                => 'Rang',
	'SORT_POSTS'               => 'Messages',
	'SORT_TOPIC_TITLE'         => 'Titre du sujet',
	'SORT_USERNAME'            => 'Nom d’utilisateur',
	'SPLIT_TOPIC'              => 'Diviser le sujet',
	'SQL_ERROR_OCCURRED'       => 'Une erreur SQL est survenue lors du chargement de la page. Si ce problème persiste, veuillez contacter un %sadministrateur du forum%s.',
	'STATISTICS'               => 'Statistiques',
	'START_WATCHING_FORUM'     => 'S’abonner au forum',
	'START_WATCHING_TOPIC'     => 'S’abonner au sujet',
	'STOP_WATCHING_FORUM'      => 'Se désabonner du forum',
	'STOP_WATCHING_TOPIC'      => 'Se désabonner du sujet',
	'STRING_LIST_MULTI'        => '%1$s, et %2$s',
	'STRING_LIST_SIMPLE'       => '%1$s et %2$s',
	'SUBFORUM'                 => 'Sous-forum',
	'SUBFORUMS'                => 'Sous-forums',
	'SUBJECT'                  => 'Sujet',
	'SUBMIT'                   => 'Envoyer',

	'TB'                     => 'To',
	'TERMS_LINK'             => 'Conditions',
	'TERMS_USE'              => 'Conditions d’utilisation',
	'TEST_CONNECTION'        => 'Tester la connexion',
	'THE_TEAM'               => 'L’équipe',
	'TIB'                    => 'Tio',
	'TIME'                   => 'Date',
	'TIMEOUT_PROCESSING_REQ' => 'Le délai a été dépassé.',

	'TOO_LARGE'                => 'La valeur que vous avez spécifiée est trop importante.',
	'TOO_LARGE_MAX_RECIPIENTS' => 'La valeur du nombre maximal de destinataires autorisés par message privé que vous avez spécifiée est trop importante.',

	'TOO_LONG' => 'La valeur que vous avez spécifiée est trop longue.',

	'TOO_LONG_CONFIRM_CODE'     => 'Le code de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_DATEFORMAT'       => 'Le format de date que vous avez spécifié est trop long.',
	'TOO_LONG_JABBER'           => 'Le nom du compte Jabber que vous avez spécifié est trop long.',
	'TOO_LONG_NEW_PASSWORD'     => 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_PASSWORD_CONFIRM' => 'Le mot de passe de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_USER_PASSWORD'    => 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_USERNAME'         => 'Le nom d’utilisateur que vous avez spécifié est trop long.',
	'TOO_LONG_EMAIL'            => 'L’adresse de courriel que vous avez spécifiée est trop longue.',

	'TOO_MANY_VOTE_OPTIONS' => 'Vous avez voté pour un trop grand nombre d’options.',

	'TOO_SHORT' => 'La valeur que vous avez spécifiée est trop courte.',

	'TOO_SHORT_CONFIRM_CODE'     => 'Le code de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_DATEFORMAT'       => 'Le format de date que vous avez spécifié est trop court.',
	'TOO_SHORT_JABBER'           => 'Le nom du compte Jabber que vous avez spécifié est trop court.',
	'TOO_SHORT_NEW_PASSWORD'     => 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_PASSWORD_CONFIRM' => 'Le mot de passe de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_USER_PASSWORD'    => 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_USERNAME'         => 'Le nom d’utilisateur que vous avez spécifié est trop court.',
	'TOO_SHORT_EMAIL'            => 'L’adresse de courriel que vous avez spécifiée est trop courte.',
	'TOO_SHORT_EMAIL_CONFIRM'    => 'L’adresse de courriel de confirmation que vous avez spécifiée est trop courte.',
	'TOO_SMALL'                  => 'La valeur que vous avez spécifiée est trop faible.',
	'TOO_SMALL_MAX_RECIPIENTS'   => 'La valeur du nombre maximal de destinataires autorisés par message privé que vous avez spécifiée est trop faible.',

	'TOPIC'                  => 'Sujet',
	'TOPICS'                 => 'Sujets',
	'TOPICS_UNAPPROVED'      => 'Au moins un des sujets de ce forum n’a pas été approuvé.',
	'TOPIC_ICON'             => 'Icône de sujet',
	'TOPIC_LOCKED'           => 'Ce sujet est verrouillé. Vous ne pouvez pas publier ou modifier de messages.',
	'TOPIC_LOCKED_SHORT'     => 'Sujet verrouillé',
	'TOPIC_MOVED'            => 'Sujet déplacé',
	'TOPIC_REVIEW'           => 'Relecture du sujet',
	'TOPIC_TITLE'            => 'Titre du sujet',
	'TOPIC_UNAPPROVED'       => 'Ce sujet n’a pas encore été approuvé.',
	'TOPIC_UNAPPROVED_FORUM' => [
		1 => 'Sujet en attente d’approbation',
		2 => 'Sujets en attente d’approbation',
	],
	'TOPIC_DELETED'      => 'Ce sujet a été supprimé.',
	'TOTAL_ATTACHMENTS'  => 'Pièces jointes',
	'TOTAL_LOGS'         => [
		1 => '%d historique',
		2 => '%d historiques',
	],
	'TOTAL_PMS' => [
		1 => '%d message privé',
		2 => '%d messages privés',
	],
	'TOPIC_POLL'        => 'Ce sujet contient un sondage.',
	'TOTAL_POSTS'       => 'Nombre total de messages',
	'TOTAL_POSTS_COUNT' => [
		1 => '<strong>%d</strong> message',
		2 => '<strong>%d</strong> messages',
	],
	'TOPIC_REPORTED' => 'Ce sujet a été rapporté',
	'TOTAL_TOPICS'   => [
		1 => '<strong>%d</strong> sujet',
		2 => '<strong>%d</strong> sujets',
	],
	'TOTAL_USERS' => [
		1 => '<strong>%d</strong> membre',
		2 => '<strong>%d</strong> membres',
	],
	'TRACKED_PHP_ERROR' => 'Erreurs PHP survenues : %s',
	'TWITTER'           => 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'   => 'Les dimensions de l’image n’ont pu être détectées automatiquement. Veuillez vérifier que le lien que vous avez saisi est valide.',
	'UNABLE_TO_DELIVER_FILE'  => 'Une erreur est survenue lors du transfert du fichier.',
	'UNKNOWN_BROWSER'         => 'Navigateur inconnu',
	'UNMARK_ALL'              => 'Tout décocher',
	'UNREAD_MESSAGES'         => 'Messages non lus',
	'UNREAD_POST'             => 'Message non lu',
	'UNREAD_POSTS'            => 'Messages non lus',
	'UNWATCH_FORUM_CONFIRM'   => 'Êtes-vous sûr de vouloir vous désabonner de ce forum ?',
	'UNWATCH_FORUM_DETAILED'  => 'Êtes-vous sûr de vouloir vous désabonner du forum « %s » ?',
	'UNWATCH_TOPIC_CONFIRM'   => 'Êtes-vous sûr de vouloir vous désabonner de ce sujet ?',
	'UNWATCH_TOPIC_DETAILED'  => 'Êtes-vous sûr de vouloir vous désabonner du sujet « %s » ?',
	'UNWATCHED_FORUMS'        => 'Vous n’êtes à présent plus abonné à ces forums.',
	'UNWATCHED_TOPICS'        => 'Vous n’êtes à présent plus abonné à ces sujets.',
	'UNWATCHED_FORUMS_TOPICS' => 'Vous n’êtes à présent plus abonné à ces éléments.',
	'UPDATE'                  => 'Mettre à jour',
	'UPLOAD_IN_PROGRESS'      => 'Transfert en cours.',
	'URL_REDIRECT'            => 'Si votre navigateur ne prend pas en charge les redirections automatiques, veuillez %scliquer ici%s afin d’être redirigé.',
	'USERGROUPS'              => 'Groupes',
	'USERNAME'                => 'Nom d’utilisateur',
	'USERNAMES'               => 'Noms d’utilisateurs',
	'USER_AVATAR'             => 'Avatar de l’utilisateur',
	'USER_CANNOT_READ'        => 'Vous ne pouvez pas consulter les messages de ce forum.',
	'USER_POSTS'              => [
		1 => '%d message',
		2 => '%d messages',
	],
	'USERS'           => 'Utilisateurs',
	'USE_PERMISSIONS' => 'Tester les permissions de l’utilisateur',

	'USER_NEW_PERMISSION_DISALLOWED' => 'Vous ne pouvez pas utiliser cette fonctionnalité. Vous devez vous inscrire et participer activement aux discussions du forum.',

	'VARIANT_DATE_SEPARATOR' => ' / ', // Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'                 => 'Consulté',
	'VIEWED_COUNTS'          => [
		0 => 'Consulté 0 fois',
		1 => 'Consulté %d fois',
		2 => 'Consulté %d fois',
	],
	'VIEWING_CONTACT_ADMIN'    => 'Consulte la page de contact',
	'VIEWING_FAQ'              => 'Consulte la foire aux questions',
	'VIEWING_MEMBERS'          => 'Consulte les informations d’un membre',
	'VIEWING_ONLINE'           => 'Consulte la liste des utilisateurs en ligne',
	'VIEWING_MCP'              => 'Consulte le panneau de contrôle du modérateur',
	'VIEWING_MEMBER_PROFILE'   => 'Consulte le profil d’un membre',
	'VIEWING_PRIVATE_MESSAGES' => 'Consulte ses messages privés',
	'VIEWING_REGISTER'         => 'Crée un compte',
	'VIEWING_UCP'              => 'Consulte le panneau de contrôle de l’utilisateur',
	'VIEWS'                    => 'Vues',
	'VIEW_BOOKMARKS'           => 'Consulter les favoris',
	'VIEW_FORUM_LOGS'          => 'Consulter l’historique',
	'VIEW_LATEST_POST'         => 'Consulter le dernier message',
	'VIEW_NEWEST_POST'         => 'Consulter le message non lu le plus récent',
	'VIEW_NOTES'               => 'Consulter les remarques sur l’utilisateur',
	'VIEW_ONLINE_TIMES'        => [
		1 => 'selon le nombre d’utilisateurs actifs de la dernière minute',
		2 => 'selon le nombre d’utilisateurs actifs des %d dernières minutes',
	],
	'VIEW_TOPIC'              => 'Consulter le sujet',
	'VIEW_TOPIC_ANNOUNCEMENT' => 'Annonce : ',
	'VIEW_TOPIC_GLOBAL'       => 'Annonce générale : ',
	'VIEW_TOPIC_LOCKED'       => 'Verrouillé : ',
	'VIEW_TOPIC_LOGS'         => 'Consulter l’historique',
	'VIEW_TOPIC_MOVED'        => 'Déplacé : ',
	'VIEW_TOPIC_POLL'         => 'Sondage : ',
	'VIEW_TOPIC_STICKY'       => 'Note : ',
	'VISIT_WEBSITE'           => 'Visiter le site internet',

	'WARNINGS'             => 'Avertissements',
	'WARN_USER'            => 'Avertir l’utilisateur',
	'WATCH_FORUM_CONFIRM'  => 'Êtes-vous sûr de vouloir vous abonner à ce forum ?',
	'WATCH_FORUM_DETAILED' => 'Êtes-vous sûr de vouloir vous abonner au forum « %s » ?',
	'WATCH_TOPIC_CONFIRM'  => 'Êtes-vous sûr de vouloir vous abonner à ce sujet ?',
	'WATCH_TOPIC_DETAILED' => 'Êtes-vous sûr de vouloir vous abonner au sujet « %s » ?',
	'WELCOME_SUBJECT'      => 'Bienvenue sur les forums de %s',
	'WEBSITE'              => 'Site internet',
	'WHOIS'                => 'Qui est-ce ?',
	'WHO_IS_ONLINE'        => 'Qui est en ligne ?',
	'WRONG_PASSWORD'       => 'Le mot de passe que vous avez spécifié est incorrect.',

	'WRONG_DATA_COLOUR'   => 'La valeur de couleur que vous avez spécifiée est invalide.',
	'WRONG_DATA_JABBER'   => 'Le nom du compte Jabber que vous avez spécifié est invalide.',
	'WRONG_DATA_LANG'     => 'La langue que vous avez spécifiée est invalide.',
	'WRONG_DATA_POST_SD'  => 'L’ordre de tri des messages que vous avez spécifié est invalide.',
	'WRONG_DATA_POST_SK'  => 'L’option de tri des messages que vous avez spécifiée est invalide.',
	'WRONG_DATA_TOPIC_SD' => 'L’ordre de tri des sujets que vous avez spécifié est invalide.',
	'WRONG_DATA_TOPIC_SK' => 'L’option de tri des sujets que vous avez spécifiée est invalide.',
	'WROTE'               => 'a écrit',

	'YAHOO'          => 'Yahoo Messenger',
	'YOUTUBE'        => 'YouTube',
	'YEAR'           => 'Année',
	'YEAR_MONTH_DAY' => '(AAAA-MM-JJ)',
	'YES'            => 'Oui',
	'YOU_LAST_VISIT' => 'Dernière visite : %s',

	'datetime' => [
		'TODAY'     => 'Aujourd’hui',
		'TOMORROW'  => 'Demain',
		'YESTERDAY' => 'Hier',
		'AGO'       => [
			0 => 'il y a moins d’une minute',
			1 => 'il y a %d minute',
			2 => 'il y a %d minutes',
		],

		'Sunday'    => 'dimanche',
		'Monday'    => 'lundi',
		'Tuesday'   => 'mardi',
		'Wednesday' => 'mercredi',
		'Thursday'  => 'jeudi',
		'Friday'    => 'vendredi',
		'Saturday'  => 'samedi',

		'Sun' => 'dim.',
		'Mon' => 'lun.',
		'Tue' => 'mar.',
		'Wed' => 'mer.',
		'Thu' => 'jeu.',
		'Fri' => 'ven.',
		'Sat' => 'sam.',

		'January'   => 'janvier',
		'February'  => 'février',
		'March'     => 'mars',
		'April'     => 'avril',
		'May'       => 'mai',
		'June'      => 'juin',
		'July'      => 'juillet',
		'August'    => 'août',
		'September' => 'septembre',
		'October'   => 'octobre',
		'November'  => 'novembre',
		'December'  => 'décembre',

		'Jan'       => 'janv.',
		'Feb'       => 'févr.',
		'Mar'       => 'mars',
		'Apr'       => 'avr.',
		'May_short' => 'mai', // Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'       => 'juin',
		'Jul'       => 'juil.',
		'Aug'       => 'août',
		'Sep'       => 'sept.',
		'Oct'       => 'oct.',
		'Nov'       => 'nov.',
		'Dec'       => 'déc.',
	],

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones' => [
		'UTC'                => 'UTC',
		'UTC_OFFSET'         => 'UTC%1$s',
		'UTC_OFFSET_CURRENT' => 'UTC%1$s – %2$s',

		'Etc/GMT-12' => 'UTC+12',
		'Etc/GMT-11' => 'UTC+11',
		'Etc/GMT-10' => 'UTC+10',
		'Etc/GMT-9'  => 'UTC+9',
		'Etc/GMT-8'  => 'UTC+8',
		'Etc/GMT-7'  => 'UTC+7',
		'Etc/GMT-6'  => 'UTC+6',
		'Etc/GMT-5'  => 'UTC+5',
		'Etc/GMT-4'  => 'UTC+4',
		'Etc/GMT-3'  => 'UTC+3',
		'Etc/GMT-2'  => 'UTC+2',
		'Etc/GMT-1'  => 'UTC+1',
		'Etc/GMT+1'  => 'UTC-1',
		'Etc/GMT+2'  => 'UTC-2',
		'Etc/GMT+3'  => 'UTC-3',
		'Etc/GMT+4'  => 'UTC-4',
		'Etc/GMT+5'  => 'UTC-5',
		'Etc/GMT+6'  => 'UTC-6',
		'Etc/GMT+7'  => 'UTC-7',
		'Etc/GMT+8'  => 'UTC-8',
		'Etc/GMT+9'  => 'UTC-9',
		'Etc/GMT+10' => 'UTC-10',
		'Etc/GMT+11' => 'UTC-11',
		'Etc/GMT+12' => 'UTC-12',

		'Africa/Abidjan'       => 'Afrique/Abidjan',
		'Africa/Accra'         => 'Afrique/Accra',
		'Africa/Addis_Ababa'   => 'Afrique/Addis-Abeba',
		'Africa/Algiers'       => 'Afrique/Alger',
		'Africa/Asmara'        => 'Afrique/Asmara',
		'Africa/Bamako'        => 'Afrique/Bamako',
		'Africa/Bangui'        => 'Afrique/Bangui',
		'Africa/Banjul'        => 'Afrique/Banjul',
		'Africa/Bissau'        => 'Afrique/Bissau',
		'Africa/Blantyre'      => 'Afrique/Blantyre',
		'Africa/Brazzaville'   => 'Afrique/Brazzaville',
		'Africa/Bujumbura'     => 'Afrique/Bujumbura',
		'Africa/Cairo'         => 'Afrique/Le Caire',
		'Africa/Casablanca'    => 'Afrique/Casablanca',
		'Africa/Ceuta'         => 'Afrique/Ceuta',
		'Africa/Conakry'       => 'Afrique/Conakry',
		'Africa/Dakar'         => 'Afrique/Dakar',
		'Africa/Dar_es_Salaam' => 'Afrique/Dar es Salam',
		'Africa/Djibouti'      => 'Afrique/Djibouti',
		'Africa/Douala'        => 'Afrique/Douala',
		'Africa/El_Aaiun'      => 'Afrique/Laâyoune',
		'Africa/Freetown'      => 'Afrique/Freetown',
		'Africa/Gaborone'      => 'Afrique/Gaborone',
		'Africa/Harare'        => 'Afrique/Harare',
		'Africa/Johannesburg'  => 'Afrique/Johannesburg',
		'Africa/Juba'          => 'Afrique/Juba',
		'Africa/Kampala'       => 'Afrique/Kampala',
		'Africa/Khartoum'      => 'Afrique/Khartoum',
		'Africa/Kigali'        => 'Afrique/Kigali',
		'Africa/Kinshasa'      => 'Afrique/Kinshasa',
		'Africa/Lagos'         => 'Afrique/Lagos',
		'Africa/Libreville'    => 'Afrique/Libreville',
		'Africa/Lome'          => 'Afrique/Lomé',
		'Africa/Luanda'        => 'Afrique/Luanda',
		'Africa/Lubumbashi'    => 'Afrique/Lubumbashi',
		'Africa/Lusaka'        => 'Afrique/Lusaka',
		'Africa/Malabo'        => 'Afrique/Malabo',
		'Africa/Maputo'        => 'Afrique/Maputo',
		'Africa/Maseru'        => 'Afrique/Maseru',
		'Africa/Mbabane'       => 'Afrique/Mbabane',
		'Africa/Mogadishu'     => 'Afrique/Mogadiscio',
		'Africa/Monrovia'      => 'Afrique/Monrovia',
		'Africa/Nairobi'       => 'Afrique/Nairobi',
		'Africa/Ndjamena'      => 'Afrique/N’Djamena',
		'Africa/Niamey'        => 'Afrique/Niamey',
		'Africa/Nouakchott'    => 'Afrique/Nouakchott',
		'Africa/Ouagadougou'   => 'Afrique/Ouagadougou',
		'Africa/Porto-Novo'    => 'Afrique/Porto-Novo',
		'Africa/Sao_Tome'      => 'Afrique/Sao Tomé-et-Principe',
		'Africa/Tripoli'       => 'Afrique/Tripoli',
		'Africa/Tunis'         => 'Afrique/Tunis',
		'Africa/Windhoek'      => 'Afrique/Windhoek',

		'America/Adak'      => 'Amérique/Adak',
		'America/Anchorage' => 'Amérique/Anchorage',
		'America/Anguilla'  => 'Amérique/Anguilla',
		'America/Antigua'   => 'Amérique/Antigua-et-Barbuda',
		'America/Araguaina' => 'Amérique/Araguaína',

		'America/Argentina/Buenos_Aires' => 'Amérique/Argentine/Buenos Aires',
		'America/Argentina/Catamarca'    => 'Amérique/Argentine/Catamarca',
		'America/Argentina/Cordoba'      => 'Amérique/Argentine/Córdoba',
		'America/Argentina/Jujuy'        => 'Amérique/Argentine/Jujuy',
		'America/Argentina/La_Rioja'     => 'Amérique/Argentine/La Rioja',
		'America/Argentina/Mendoza'      => 'Amérique/Argentine/Mendoza',
		'America/Argentina/Rio_Gallegos' => 'Amérique/Argentine/Río Gallegos',
		'America/Argentina/Salta'        => 'Amérique/Argentine/Salta',
		'America/Argentina/San_Juan'     => 'Amérique/Argentine/San Juan',
		'America/Argentina/San_Luis'     => 'Amérique/Argentine/San Luis',
		'America/Argentina/Tucuman'      => 'Amérique/Argentine/Tucumán',
		'America/Argentina/Ushuaia'      => 'Amérique/Argentine/Ushuaïa',

		'America/Aruba'                  => 'Amérique/Aruba',
		'America/Asuncion'               => 'Amérique/Asuncion',
		'America/Atikokan'               => 'Amérique/Atikokan',
		'America/Bahia'                  => 'Amérique/Bahia',
		'America/Bahia_Banderas'         => 'Amérique/Bahía de Banderas',
		'America/Barbados'               => 'Amérique/Barbade',
		'America/Belem'                  => 'Amérique/Belem',
		'America/Belize'                 => 'Amérique/Belize',
		'America/Blanc-Sablon'           => 'Amérique/Blanc-Sablon',
		'America/Boa_Vista'              => 'Amérique/Boa Vista',
		'America/Bogota'                 => 'Amérique/Bogota',
		'America/Boise'                  => 'Amérique/Boise',
		'America/Cambridge_Bay'          => 'Amérique/Ikaluktutiak',
		'America/Campo_Grande'           => 'Amérique/Campo Grande',
		'America/Cancun'                 => 'Amérique/Cancún',
		'America/Caracas'                => 'Amérique/Caracas',
		'America/Cayenne'                => 'Amérique/Cayenne',
		'America/Cayman'                 => 'Amérique/Îles Caïmans',
		'America/Chicago'                => 'Amérique/Chicago',
		'America/Chihuahua'              => 'Amérique/Chihuahua',
		'America/Costa_Rica'             => 'Amérique/Costa Rica',
		'America/Creston'                => 'Amérique/Creston',
		'America/Cuiaba'                 => 'Amérique/Cuiabá',
		'America/Curacao'                => 'Amérique/Curaçao',
		'America/Danmarkshavn'           => 'Amérique/Danmarkshavn',
		'America/Dawson'                 => 'Amérique/Dawson',
		'America/Dawson_Creek'           => 'Amérique/Dawson Creek',
		'America/Denver'                 => 'Amérique/Denver',
		'America/Detroit'                => 'Amérique/Détroit',
		'America/Dominica'               => 'Amérique/Dominique',
		'America/Edmonton'               => 'Amérique/Edmonton',
		'America/Eirunepe'               => 'Amérique/Eirunepé',
		'America/El_Salvador'            => 'Amérique/Salvador',
		'America/Fortaleza'              => 'Amérique/Fortaleza',
		'America/Glace_Bay'              => 'Amérique/Glace Bay',
		'America/Godthab'                => 'Amérique/Nuuk',
		'America/Goose_Bay'              => 'Amérique/Happy Valley-Goose Bay',
		'America/Grand_Turk'             => 'Amérique/Grand Turk',
		'America/Grenada'                => 'Amérique/Grenade',
		'America/Guadeloupe'             => 'Amérique/Guadeloupe',
		'America/Guatemala'              => 'Amérique/Guatemala',
		'America/Guayaquil'              => 'Amérique/Guayaquil',
		'America/Guyana'                 => 'Amérique/Guyana',
		'America/Halifax'                => 'Amérique/Halifax',
		'America/Havana'                 => 'Amérique/La Havane',
		'America/Hermosillo'             => 'Amérique/Hermosillo',
		'America/Indiana/Indianapolis'   => 'Amérique/Indiana/Indianapolis',
		'America/Indiana/Knox'           => 'Amérique/Indiana/Knox',
		'America/Indiana/Marengo'        => 'Amérique/Indiana/Marengo',
		'America/Indiana/Petersburg'     => 'Amérique/Indiana/Petersburg',
		'America/Indiana/Tell_City'      => 'Amérique/Indiana/Tell City',
		'America/Indiana/Vevay'          => 'Amérique/Indiana/Vevay',
		'America/Indiana/Vincennes'      => 'Amérique/Indiana/Vincennes',
		'America/Indiana/Winamac'        => 'Amérique/Indiana/Winamac',
		'America/Inuvik'                 => 'Amérique/Inuvik',
		'America/Iqaluit'                => 'Amérique/Iqaluit',
		'America/Jamaica'                => 'Amérique/Jamaïque',
		'America/Juneau'                 => 'Amérique/Juneau',
		'America/Kentucky/Louisville'    => 'Amérique/Kentucky/Louisville',
		'America/Kentucky/Monticello'    => 'Amérique/Kentucky/Monticello',
		'America/Kralendijk'             => 'Amérique/Kralendijk',
		'America/La_Paz'                 => 'Amérique/La Paz',
		'America/Lima'                   => 'Amérique/Lima',
		'America/Los_Angeles'            => 'Amérique/Los Angeles',
		'America/Lower_Princes'          => 'Amérique/Lower Prince’s Quarter',
		'America/Maceio'                 => 'Amérique/Maceió',
		'America/Managua'                => 'Amérique/Managua',
		'America/Manaus'                 => 'Amérique/Manaus',
		'America/Marigot'                => 'Amérique/Marigot',
		'America/Martinique'             => 'Amérique/Martinique',
		'America/Matamoros'              => 'Amérique/Matamoros',
		'America/Mazatlan'               => 'Amérique/Mazatlán',
		'America/Menominee'              => 'Amérique/Menominee',
		'America/Merida'                 => 'Amérique/Mérida',
		'America/Metlakatla'             => 'Amérique/Metlakatla',
		'America/Mexico_City'            => 'Amérique/Mexico',
		'America/Miquelon'               => 'Amérique/Saint-Pierre-et-Miquelon',
		'America/Moncton'                => 'Amérique/Moncton',
		'America/Monterrey'              => 'Amérique/Monterrey',
		'America/Montevideo'             => 'Amérique/Montevideo',
		'America/Montreal'               => 'Amérique/Montréal',
		'America/Montserrat'             => 'Amérique/Montserrat',
		'America/Nassau'                 => 'Amérique/Nassau',
		'America/New_York'               => 'Amérique/New York',
		'America/Nipigon'                => 'Amérique/Nipigon',
		'America/Nome'                   => 'Amérique/Nome',
		'America/Noronha'                => 'Amérique/Fernando de Noronha',
		'America/North_Dakota/Beulah'    => 'Amérique/Dakota du Nord/Beulah',
		'America/North_Dakota/Center'    => 'Amérique/Dakota du Nord/Center',
		'America/North_Dakota/New_Salem' => 'Amérique/Dakota du Nord/New Salem',
		'America/Ojinaga'                => 'Amérique/Ojinaga',
		'America/Panama'                 => 'Amérique/Panama',
		'America/Pangnirtung'            => 'Amérique/Pangnirtung',
		'America/Paramaribo'             => 'Amérique/Paramaribo',
		'America/Phoenix'                => 'Amérique/Phoenix',
		'America/Port-au-Prince'         => 'Amérique/Port-au-Prince',
		'America/Port_of_Spain'          => 'Amérique/Port-d’Espagne',
		'America/Porto_Velho'            => 'Amérique/Porto Velho',
		'America/Puerto_Rico'            => 'Amérique/Porto Rico',
		'America/Rainy_River'            => 'Amérique/Rainy River',
		'America/Rankin_Inlet'           => 'Amérique/Rankin Inlet',
		'America/Recife'                 => 'Amérique/Recife',
		'America/Regina'                 => 'Amérique/Regina',
		'America/Resolute'               => 'Amérique/Resolute',
		'America/Rio_Branco'             => 'Amérique/Rio Branco',
		'America/Santa_Isabel'           => 'Amérique/Santa Isabel',
		'America/Santarem'               => 'Amérique/Santarém',
		'America/Santiago'               => 'Amérique/Santiago',
		'America/Santo_Domingo'          => 'Amérique/Saint-Domingue',
		'America/Sao_Paulo'              => 'Amérique/São Paulo',
		'America/Scoresbysund'           => 'Amérique/Scoresby Sund',
		'America/Shiprock'               => 'Amérique/Shiprock',
		'America/Sitka'                  => 'Amérique/Sitka',
		'America/St_Barthelemy'          => 'Amérique/Saint-Barthélemy',
		'America/St_Johns'               => 'Amérique/Saint John’s',
		'America/St_Kitts'               => 'Amérique/Saint-Christophe',
		'America/St_Lucia'               => 'Amérique/Sainte-Lucie',
		'America/St_Thomas'              => 'Amérique/Saint Thomas',
		'America/St_Vincent'             => 'Amérique/Saint-Vincent',
		'America/Swift_Current'          => 'Amérique/Swift Current',
		'America/Tegucigalpa'            => 'Amérique/Tegucigalpa',
		'America/Thule'                  => 'Amérique/Thulé',
		'America/Thunder_Bay'            => 'Amérique/Thunder Bay',
		'America/Tijuana'                => 'Amérique/Tijuana',
		'America/Toronto'                => 'Amérique/Toronto',
		'America/Tortola'                => 'Amérique/Tortola',
		'America/Vancouver'              => 'Amérique/Vancouver',
		'America/Whitehorse'             => 'Amérique/Whitehorse',
		'America/Winnipeg'               => 'Amérique/Winnipeg',
		'America/Yakutat'                => 'Amérique/Yakutat',
		'America/Yellowknife'            => 'Amérique/Yellowknife',

		'Antarctica/Casey'          => 'Antarctique/Casey',
		'Antarctica/Davis'          => 'Antarctique/Davis',
		'Antarctica/DumontDUrville' => 'Antarctique/Dumont d’Urville',
		'Antarctica/Macquarie'      => 'Antarctique/Île Macquarie',
		'Antarctica/Mawson'         => 'Antarctique/Mawson',
		'Antarctica/McMurdo'        => 'Antarctique/McMurdo',
		'Antarctica/Palmer'         => 'Antarctique/Palmer',
		'Antarctica/Rothera'        => 'Antarctique/Rothera',
		'Antarctica/South_Pole'     => 'Antarctique/Amundsen-Scott',
		'Antarctica/Syowa'          => 'Antarctique/Syowa',
		'Antarctica/Vostok'         => 'Antarctique/Vostok',

		'Arctic/Longyearbyen' => 'Arctique/Longyearbyen',

		'Asia/Aden'          => 'Asie/Aden',
		'Asia/Almaty'        => 'Asie/Almaty',
		'Asia/Amman'         => 'Asie/Amman',
		'Asia/Anadyr'        => 'Asie/Anadyr',
		'Asia/Aqtau'         => 'Asie/Aktaou',
		'Asia/Aqtobe'        => 'Asie/Aktioubé',
		'Asia/Ashgabat'      => 'Asie/Achgabat',
		'Asia/Baghdad'       => 'Asie/Bagdad',
		'Asia/Bahrain'       => 'Asie/Bahreïn',
		'Asia/Baku'          => 'Asie/Bakou',
		'Asia/Bangkok'       => 'Asie/Bangkok',
		'Asia/Beirut'        => 'Asie/Beyrouth',
		'Asia/Bishkek'       => 'Asie/Bichkek',
		'Asia/Brunei'        => 'Asie/Brunei',
		'Asia/Choibalsan'    => 'Asie/Choybalsan',
		'Asia/Chongqing'     => 'Asie/Chongqing',
		'Asia/Colombo'       => 'Asie/Colombo',
		'Asia/Damascus'      => 'Asie/Damas',
		'Asia/Dhaka'         => 'Asie/Dacca',
		'Asia/Dili'          => 'Asie/Dili',
		'Asia/Dubai'         => 'Asie/Dubaï',
		'Asia/Dushanbe'      => 'Asie/Douchanbé',
		'Asia/Gaza'          => 'Asie/Gaza',
		'Asia/Harbin'        => 'Asie/Harbin',
		'Asia/Hebron'        => 'Asie/Hébron',
		'Asia/Ho_Chi_Minh'   => 'Asie/Hô-Chi-Minh-Ville',
		'Asia/Hong_Kong'     => 'Asie/Hong Kong',
		'Asia/Hovd'          => 'Asie/Hovd',
		'Asia/Irkutsk'       => 'Asie/Irkoutsk',
		'Asia/Jakarta'       => 'Asie/Jakarta',
		'Asia/Jayapura'      => 'Asie/Jayapura',
		'Asia/Jerusalem'     => 'Asie/Jérusalem',
		'Asia/Kabul'         => 'Asie/Kaboul',
		'Asia/Kamchatka'     => 'Asie/Kamtchatka',
		'Asia/Karachi'       => 'Asie/Karachi',
		'Asia/Kashgar'       => 'Asie/Kachgar',
		'Asia/Kathmandu'     => 'Asie/Katmandou',
		'Asia/Khandyga'      => 'Asie/Khandyga',
		'Asia/Kolkata'       => 'Asie/Calcutta',
		'Asia/Krasnoyarsk'   => 'Asie/Krasnoïarsk',
		'Asia/Kuala_Lumpur'  => 'Asie/Kuala Lumpur',
		'Asia/Kuching'       => 'Asie/Kuching',
		'Asia/Kuwait'        => 'Asie/Koweït',
		'Asia/Macau'         => 'Asie/Macao',
		'Asia/Magadan'       => 'Asie/Magadan',
		'Asia/Makassar'      => 'Asie/Makassar',
		'Asia/Manila'        => 'Asie/Manille',
		'Asia/Muscat'        => 'Asie/Mascate',
		'Asia/Nicosia'       => 'Asie/Nicosia',
		'Asia/Novokuznetsk'  => 'Asie/Novokouznetsk',
		'Asia/Novosibirsk'   => 'Asie/Novossibirsk',
		'Asia/Omsk'          => 'Asie/Omsk',
		'Asia/Oral'          => 'Asie/Orel',
		'Asia/Phnom_Penh'    => 'Asie/Phnom Penh',
		'Asia/Pontianak'     => 'Asie/Pontianak',
		'Asia/Pyongyang'     => 'Asie/Pyongyang',
		'Asia/Qatar'         => 'Asie/Qatar',
		'Asia/Qyzylorda'     => 'Asie/Kyzylorda',
		'Asia/Rangoon'       => 'Asie/Rangoun',
		'Asia/Riyadh'        => 'Asie/Riyad',
		'Asia/Sakhalin'      => 'Asie/Sakhaline',
		'Asia/Samarkand'     => 'Asie/Samarcande',
		'Asia/Seoul'         => 'Asie/Séoul',
		'Asia/Shanghai'      => 'Asie/Shanghai',
		'Asia/Singapore'     => 'Asie/Singapour',
		'Asia/Taipei'        => 'Asie/Taipei',
		'Asia/Tashkent'      => 'Asie/Tachkent',
		'Asia/Tbilisi'       => 'Asie/Tbilissi',
		'Asia/Tehran'        => 'Asie/Téhéran',
		'Asia/Thimphu'       => 'Asie/Thimphou',
		'Asia/Tokyo'         => 'Asie/Tokyo',
		'Asia/Ulaanbaatar'   => 'Asie/Oulan-Bator',
		'Asia/Urumqi'        => 'Asie/Ürümqi',
		'Asia/Ust-Nera'      => 'Asie/Ust-Nera',
		'Asia/Vientiane'     => 'Asie/Vientiane',
		'Asia/Vladivostok'   => 'Asie/Vladivostok',
		'Asia/Yakutsk'       => 'Asie/Iakoutsk',
		'Asia/Yekaterinburg' => 'Asie/Iekaterinbourg',
		'Asia/Yerevan'       => 'Asie/Erevan',

		'Atlantic/Azores'        => 'Océan Atlantique/Açores',
		'Atlantic/Bermuda'       => 'Océan Atlantique/Bermudes',
		'Atlantic/Canary'        => 'Océan Atlantique/Îles Canaries',
		'Atlantic/Cape_Verde'    => 'Océan Atlantique/Cap-Vert',
		'Atlantic/Faroe'         => 'Océan Atlantique/Îles Féroé',
		'Atlantic/Madeira'       => 'Océan Atlantique/Madère',
		'Atlantic/Reykjavik'     => 'Océan Atlantique/Reykjavik',
		'Atlantic/South_Georgia' => 'Océan Atlantique/Géorgie du Sud-et-les Îles Sandwich du Sud',
		'Atlantic/St_Helena'     => 'Océan Atlantique/Sainte-Hélène',
		'Atlantic/Stanley'       => 'Océan Atlantique/Port Stanley',

		'Australia/Adelaide'    => 'Australie/Adélaïde',
		'Australia/Brisbane'    => 'Australie/Brisbane',
		'Australia/Broken_Hill' => 'Australie/Broken Hill',
		'Australia/Currie'      => 'Australie/Currie',
		'Australia/Darwin'      => 'Australie/Darwin',
		'Australia/Eucla'       => 'Australie/Eucla',
		'Australia/Hobart'      => 'Australie/Hobart',
		'Australia/Lindeman'    => 'Australie/Îles Whitsunday',
		'Australia/Lord_Howe'   => 'Australie/Île Lord Howe',
		'Australia/Melbourne'   => 'Australie/Melbourne',
		'Australia/Perth'       => 'Australie/Perth',
		'Australia/Sydney'      => 'Australie/Sydney',

		'Europe/Amsterdam'   => 'Europe/Amsterdam',
		'Europe/Andorra'     => 'Europe/Andorre',
		'Europe/Athens'      => 'Europe/Athènes',
		'Europe/Belgrade'    => 'Europe/Belgrade',
		'Europe/Berlin'      => 'Europe/Berlin',
		'Europe/Bratislava'  => 'Europe/Bratislava',
		'Europe/Brussels'    => 'Europe/Bruxelles',
		'Europe/Bucharest'   => 'Europe/Bucarest',
		'Europe/Budapest'    => 'Europe/Budapest',
		'Europe/Busingen'    => 'Europe/Büsingen am Hochrhein',
		'Europe/Chisinau'    => 'Europe/Chișinău',
		'Europe/Copenhagen'  => 'Europe/Copenhague',
		'Europe/Dublin'      => 'Europe/Dublin',
		'Europe/Gibraltar'   => 'Europe/Gibraltar',
		'Europe/Guernsey'    => 'Europe/Guernesey',
		'Europe/Helsinki'    => 'Europe/Helsinki',
		'Europe/Isle_of_Man' => 'Europe/Île de Man',
		'Europe/Istanbul'    => 'Europe/Istanbul',
		'Europe/Jersey'      => 'Europe/Jersey',
		'Europe/Kaliningrad' => 'Europe/Kaliningrad',
		'Europe/Kiev'        => 'Europe/Kiev',
		'Europe/Lisbon'      => 'Europe/Lisbonne',
		'Europe/Ljubljana'   => 'Europe/Ljubljana',
		'Europe/London'      => 'Europe/Londres',
		'Europe/Luxembourg'  => 'Europe/Luxembourg',
		'Europe/Madrid'      => 'Europe/Madrid',
		'Europe/Malta'       => 'Europe/Malte',
		'Europe/Mariehamn'   => 'Europe/Mariehamn',
		'Europe/Minsk'       => 'Europe/Minsk',
		'Europe/Monaco'      => 'Europe/Monaco',
		'Europe/Moscow'      => 'Europe/Moscou',
		'Europe/Oslo'        => 'Europe/Oslo',
		'Europe/Paris'       => 'Europe/Paris',
		'Europe/Podgorica'   => 'Europe/Podgorica',
		'Europe/Prague'      => 'Europe/Prague',
		'Europe/Riga'        => 'Europe/Riga',
		'Europe/Rome'        => 'Europe/Rome',
		'Europe/Samara'      => 'Europe/Samara',
		'Europe/San_Marino'  => 'Europe/Saint-Marin',
		'Europe/Sarajevo'    => 'Europe/Sarajevo',
		'Europe/Simferopol'  => 'Europe/Simferopol',
		'Europe/Skopje'      => 'Europe/Skopje',
		'Europe/Sofia'       => 'Europe/Sofia',
		'Europe/Stockholm'   => 'Europe/Stockholm',
		'Europe/Tallinn'     => 'Europe/Tallinn',
		'Europe/Tirane'      => 'Europe/Tirana',
		'Europe/Uzhgorod'    => 'Europe/Oujhorod',
		'Europe/Vaduz'       => 'Europe/Vaduz',
		'Europe/Vatican'     => 'Europe/Vatican',
		'Europe/Vienna'      => 'Europe/Vienne',
		'Europe/Vilnius'     => 'Europe/Vilnius',
		'Europe/Volgograd'   => 'Europe/Volgograd',
		'Europe/Warsaw'      => 'Europe/Varsovie',
		'Europe/Zagreb'      => 'Europe/Zagreb',
		'Europe/Zaporozhye'  => 'Europe/Zaporijia',
		'Europe/Zurich'      => 'Europe/Zurich',

		'Indian/Antananarivo' => 'Océan Indien/Antananarivo',
		'Indian/Chagos'       => 'Océan Indien/Archipel des Chagos',
		'Indian/Christmas'    => 'Océan Indien/Île Christmas',
		'Indian/Cocos'        => 'Océan Indien/Îles Cocos',
		'Indian/Comoro'       => 'Océan Indien/Comores',
		'Indian/Kerguelen'    => 'Océan Indien/Îles Kerguelen',
		'Indian/Mahe'         => 'Océan Indien/Mahé',
		'Indian/Maldives'     => 'Océan Indien/Maldives',
		'Indian/Mauritius'    => 'Océan Indien/Maurice',
		'Indian/Mayotte'      => 'Océan Indien/Mayotte',
		'Indian/Reunion'      => 'Océan Indien/La Réunion',

		'Pacific/Apia'         => 'Océan Pacifique/Apia',
		'Pacific/Auckland'     => 'Océan Pacifique/Auckland',
		'Pacific/Chatham'      => 'Océan Pacifique/Chatham',
		'Pacific/Chuuk'        => 'Océan Pacifique/Chuuk',
		'Pacific/Easter'       => 'Océan Pacifique/Île de Pâques',
		'Pacific/Efate'        => 'Océan Pacifique/Éfaté',
		'Pacific/Enderbury'    => 'Océan Pacifique/Enderbury',
		'Pacific/Fakaofo'      => 'Océan Pacifique/Fakaofo',
		'Pacific/Fiji'         => 'Océan Pacifique/Fidji',
		'Pacific/Funafuti'     => 'Océan Pacifique/Funafuti',
		'Pacific/Galapagos'    => 'Océan Pacifique/Îles Galápagos',
		'Pacific/Gambier'      => 'Océan Pacifique/Îles Gambier',
		'Pacific/Guadalcanal'  => 'Océan Pacifique/Guadalcanal',
		'Pacific/Guam'         => 'Océan Pacifique/Guam',
		'Pacific/Honolulu'     => 'Océan Pacifique/Honolulu',
		'Pacific/Johnston'     => 'Océan Pacifique/Atoll Johnston',
		'Pacific/Kiritimati'   => 'Océan Pacifique/Île Christmas',
		'Pacific/Kosrae'       => 'Océan Pacifique/Kosrae',
		'Pacific/Kwajalein'    => 'Océan Pacifique/Kwajalein',
		'Pacific/Majuro'       => 'Océan Pacifique/Majuro',
		'Pacific/Marquesas'    => 'Océan Pacifique/Îles Marquises',
		'Pacific/Midway'       => 'Océan Pacifique/Îles Midway',
		'Pacific/Nauru'        => 'Océan Pacifique/Nauru',
		'Pacific/Niue'         => 'Océan Pacifique/Niue',
		'Pacific/Norfolk'      => 'Océan Pacifique/Norfolk',
		'Pacific/Noumea'       => 'Océan Pacifique/Nouméa',
		'Pacific/Pago_Pago'    => 'Océan Pacifique/Pago Pago',
		'Pacific/Palau'        => 'Océan Pacifique/Palaos',
		'Pacific/Pitcairn'     => 'Océan Pacifique/Îles Pitcairn',
		'Pacific/Pohnpei'      => 'Océan Pacifique/Pohnpei',
		'Pacific/Port_Moresby' => 'Océan Pacifique/Port Moresby',
		'Pacific/Rarotonga'    => 'Océan Pacifique/Rarotonga',
		'Pacific/Saipan'       => 'Océan Pacifique/Saipan',
		'Pacific/Tahiti'       => 'Océan Pacifique/Tahiti',
		'Pacific/Tarawa'       => 'Océan Pacifique/Tarawa',
		'Pacific/Tongatapu'    => 'Océan Pacifique/Tongatapu',
		'Pacific/Wake'         => 'Océan Pacifique/Wake',
		'Pacific/Wallis'       => 'Océan Pacifique/Wallis-et-Futuna',
	],

	// The value is only an example and will get replaced by the current time on view
	'dateformats' => [
		'd M Y, H:i'       => '01 janv. 2007, 13:37',
		'd M Y H:i'        => '01 janv. 2007 13:37',
		'M jS, \'y, H:i'   => 'janv. 1er, ’07, 13:37',
		'D M d, Y g:i a'   => 'lun. janv. 01, 2007 1:37 pm',
		'F jS, Y, g:i a'   => 'janvier 1er, 2007, 1:37 pm',
		'|d M Y|, H:i'     => 'Aujourd’hui, 13:37 / 01 janv. 2007, 13:37',
		'|F jS, Y|, g:i a' => 'Aujourd’hui, 1:37 pm / janv. 1er, 2007, 1:37 pm',
	],

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat' => 'd F Y, H:i', // 01 January 2007, 13:37
]);
