<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2021 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
class s9e_renderer_0b57826602a6e9c2461e840d372b603937f65dff extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['AMAZON_ASSOCIATE_TAG'=>'','AMAZON_ASSOCIATE_TAG_CA'=>'','AMAZON_ASSOCIATE_TAG_DE'=>'','AMAZON_ASSOCIATE_TAG_ES'=>'','AMAZON_ASSOCIATE_TAG_FR'=>'','AMAZON_ASSOCIATE_TAG_IN'=>'','AMAZON_ASSOCIATE_TAG_IT'=>'','AMAZON_ASSOCIATE_TAG_JP'=>'','AMAZON_ASSOCIATE_TAG_UK'=>'','L_CODE'=>'','L_COLON'=>'','L_IMAGE'=>'','L_SELECT_ALL_CODE'=>'','L_WROTE'=>'','MEDIAEMBED_THEME'=>'','S_VIEWFLASH'=>'','S_VIEWIMG'=>'','S_VIEWSMILIES'=>'','T_SMILIES_PATH'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ABCNEWS':$this->out.='<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ACAD':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'&amp;autostart=false" width="400" height="300" frameborder="0" scrolling="no" class="float_left_webcast"></iframe>';break;case'ACAST':$this->out.='<iframe title="Embed Player" width="100%" height="188px" src="https://embed.acast.com/'.htmlspecialchars($node->textContent,2).'" scrolling="no" frameborder="0" style="border:none;overflow:hidden"></iframe>';break;case'AKAD':$this->out.='<iframe width="560" height="315" src="//embedftv-a.akamaihd.net/%7BTEXT%5D" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'ALTER':$this->out.='<iframe width="684" height="667" frameborder="0" src="https://www.alternatives-economiques.fr/embed/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'AMAZON':$this->out.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://www.amazon.com/favicon.ico) center no-repeat;border:0;height:100%;left:0;position:absolute;width:100%" src="//ws-';if($node->getAttribute('tld')==='jp')$this->out.='fe';elseif($node->hasAttribute('tld')&&(strpos('desfrinituk',$node->getAttribute('tld'))!==false))$this->out.='eu';else$this->out.='na';$this->out.='.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=';switch($node->getAttribute('tld')){case'ca':$this->out.='15&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);break;case'de':$this->out.='3&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);break;case'es':$this->out.='30&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);break;case'fr':$this->out.='8&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);break;case'in':$this->out.='31&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);break;case'it':$this->out.='29&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);break;case'jp':$this->out.='9&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);break;case'uk':$this->out.='2&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);break;default:$this->out.='1&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);}$this->out.='&amp;asins='.htmlspecialchars($node->getAttribute('id'),2).'"></iframe></span></span>';break;case'API':$this->out.='<iframe frameborder="0" width="640" height="360" src="'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'APO':case'FR3':case'SOIR3':case'TVINFO':$this->out.='<iframe frameborder="0" width="640" height="360" src="http://api.dmcloud.net/player/embed/'.htmlspecialchars($node->textContent,2).'?exported=1"></iframe>';break;case'ARD':$this->out.='<iframe src="https://www.ardmediathek.de/embed/'.htmlspecialchars($node->textContent,2).'" width="640" height="420" allowfullscreen="" frameborder="0" scrolling="no"></iframe>';break;case'ARTE':$this->out.='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" id="playerArte" allowscriptaccess="always" width="450" height="303"><param name="allowFullScreen" value="true"><param name="allowScriptAccess" value="always"><param name="quality" value="high"><param name="movie" value="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl='.htmlspecialchars($node->textContent,2).'&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false"><embed src="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Ffr%2Fdo%5Fdelegate%2Fvideos%2Fray%2Dkurzweil%2Dqu%2Dest%2Dce%2Dque%2Dla%2Dsingularite%2D%2D4157746%2Cview%2CasPlayerXml%2Exml&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false" width="450" height="303" allowfullscreen="true" name="playerArte" quality="high" allowscriptaccess="always" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></object>';break;case'ARTE7':$this->out.='<script type="text/javascript" src="https://www-secure.arte.tv/arte_vp/embed.php?json_url=http%3A%2F%2Fconcert.arte.tv%2Ffr%2Fplayer%2F'.htmlspecialchars($node->textContent,2).'&amp;lang=fr_FR&amp;config=arte_concert&amp;width=720&amp;height=406"></script>';break;case'ATTACHMENT':$this->out.='<div class="inline-attachment"><!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' -->'.htmlspecialchars($node->getAttribute('filename'),0).'<!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' --></div>';break;case'ATTV':$this->out.='<iframe src="https://vp.telvue.com/player?id=T03105&amp;video='.htmlspecialchars($node->textContent,2).'&amp;mini=true" width="400" height="300" marginwidth="0" marginheight="0" hpsace="0" vspace="0" frameborder="1" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'AUDIOBOOM':$this->out.='<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>';break;case'AUDIOMACK':$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($node->getAttribute('mode')==='album'){$this->out.=' src="https://www.audiomack.com/embed/album/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$this->out.=' src="https://www.audiomack.com/embed/song/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:252px;max-width:900px;width:100%"';}$this->out.='></iframe>';break;case'AUSHA':$this->out.='<iframe frameborder="0" loading="lazy" id="'.htmlspecialchars($node->textContent,2).'" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId=bzPxksVdjQnD&amp;v=3&amp;playerId=ausha-WWk4"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'B':$this->out.='<strong class="text-strong">';$this->at($node);$this->out.='</strong>';break;case'BANDCAMP':$this->out.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if($node->hasAttribute('album_id')){$this->out.='album='.htmlspecialchars($node->getAttribute('album_id'),2);if($node->hasAttribute('track_num'))$this->out.='/t='.htmlspecialchars($node->getAttribute('track_num'),2);}else$this->out.='track='.htmlspecialchars($node->getAttribute('track_id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='/bgcol=333333/linkcol=0f91ff';$this->out.='"></iframe></span></span>';break;case'BBC':$this->out.='<iframe width="400" height="500" frameborder="0" src="https://www.bbc.com/news/av/embed/p080qwnv/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'BBC4':$this->out.='<iframe width="400" height="500" frameborder="0" src="http://www.bbc.co.uk/programmes/'.htmlspecialchars($node->textContent,2).'/player"></iframe>';break;case'BBCNEWS':$this->out.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av-embeds/';if((strpos($node->getAttribute('playlist'),'/news/')===0))if((strpos($node->getAttribute('playlist'),'-')!==false))$this->out.=htmlspecialchars(substr(strstr(substr(strstr(strtr($node->getAttribute('playlist'),'A','#'),'news/'),5),'-'),1),2);else$this->out.=htmlspecialchars(substr(strstr(strtr($node->getAttribute('playlist'),'A','/'),'/news/'),6),2);elseif((strpos($node->getAttribute('id'),'/')!==false))$this->out.=htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'BCOVE':$this->out.='<iframe src="https://players.brightcove.net/45228659001/rkPdEdoaW_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFIG':$this->out.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFM':$this->out.='<div style="display:block;position:relative"><div style="padding-top:56.25%"><iframe src="'.htmlspecialchars($node->textContent,2).'" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" style="width:100%;height:100%;position:absolute;top:0;bottom:0;right:0;left:0;border:none"></iframe></div></div>';break;case'BITCHUTE':$this->out.='<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BLEACHERREPORT':$this->out.='<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id='.htmlspecialchars($node->getAttribute('id'),2).'&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BM':$this->out.='<iframe src="http://donnees.banquemondiale.org/share/widget?indicators='.htmlspecialchars($node->textContent,2).'" width="450" height="300" frameborder="0" scrolling="no"></iframe>';break;case'BRIGHTCOVE':$this->out.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if($node->hasAttribute('bckey'))$this->out.='link.brightcove.com/services/player/bcpid'.htmlspecialchars($node->getAttribute('bcpid'),2).'?bckey='.htmlspecialchars($node->getAttribute('bckey'),2).'&amp;bctid='.htmlspecialchars($node->getAttribute('bctid'),2).'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$this->out.='players.brightcove.net/'.htmlspecialchars($node->getAttribute('bcpid'),2).'/default_default/index.html?videoId='.htmlspecialchars($node->getAttribute('bctid'),2);$this->out.='"></iframe></span></span>';break;case'CALAMEO':$this->out.='<iframe src="//v.calameo.com/?bkcode='.htmlspecialchars($node->textContent,2).'" width="900" height="582" frameborder="0" scrolling="no" allowtransparency="" allowfullscreen="" style="margin:0 auto"></iframe>';break;case'CANAL':$this->out.='<div><iframe width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=cplus&amp;vid='.htmlspecialchars($node->textContent,2).'"></iframe></div>';break;case'CANAL-U':$this->out.='<div style="position:relative;padding-bottom:56.25%;padding-top:10px;height:0;overflow:hidden"><iframe src="https://www.canal-u.tv/video/cerimes/embed.1/'.htmlspecialchars($node->textContent,2).'?width=100%25&amp;height=100%25" style="position:absolute;top:0;left:0;width:100%;height:100%" width="550" height="306" frameborder="0" allowfullscreen="" scrolling="no"></iframe></div>';break;case'CBSNEWS':$this->out.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($node->getAttribute('id'),'-')!==false))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif($node->hasAttribute('pid'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.htmlspecialchars($node->getAttribute('pid'),2).'"></object>';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.htmlspecialchars($node->getAttribute('id'),2).'"></object>';$this->out.='</span></span>';break;case'CDF':$this->out.='<embed src="http://www.mariamagdalenakaczor.eu/mediaplayer/player.swf" height="560" width="745" allowscriptaccess="always" allowfullscreen="true" flashvars="&amp;controlbar=over&amp;item='.htmlspecialchars($node->textContent,2).'&amp;playlistfile=http%3A%2F%2Fwww.mariamagdalenakaczor.eu%2Fmediapayer%2Fplaylist.xml&amp;plugins=viral-2d">';break;case'CDN':$this->out.='<iframe src="//cdn.jwplayer.com/players/'.htmlspecialchars($node->textContent,2).'" width="640" height="360" frameborder="0" scrolling="auto"></iframe>';break;case'CHART':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART1':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART2':$this->out.='<iframe src="https://ourworldindata.org/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=2020-12-20..latest&amp;country=USA~DEU~GBR~FRA~ISR~ITA~ESP&amp;region=World&amp;vaccinationsMetric=true&amp;interval=total&amp;perCapita=true&amp;smoothing=0&amp;pickerMetric=total_vaccinations_per_hundred&amp;pickerSort=desc" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART3':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-12-20..latest&amp;pickerSort=asc&amp;pickerMetric=location&amp;Metric=Vaccine+doses&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTCO2':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;country=FRA~DEU~NLD~POL~EU-27&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNDL':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=earliest..latest&amp;country=~NLD&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNEWDEATHS':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=GBR~FRA~USA~BRA~IND~MEX~RUS~ITA&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTTOTALDEATH':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~GBR~FRA~BRA~HUN" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CNBC':$this->out.='<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid='.htmlspecialchars($node->getAttribute('id'),2).'&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNN':$this->out.='<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video='.htmlspecialchars($node->getAttribute('id'),2).'&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNNMONEY':$this->out.='<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CODE':$this->out.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';$this->at($node);$this->out.='</code></pre></div>';break;case'COLOR':$this->out.='<span style="color:'.htmlspecialchars($node->getAttribute('color'),2).'">';$this->at($node);$this->out.='</span>';break;case'COMEDYCENTRAL':$this->out.='<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COUB':$this->out.='<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CULT':$this->out.='<iframe src="http://www.franceculture.fr/player/export-reecouter?content='.htmlspecialchars($node->textContent,2).'" width="481" frameborder="0" scrolling="no" height="139"></iframe>';break;case'DAILYMOTION':$this->out.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('t'))$this->out.='?start='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'DATA':$this->out.='<div class="flourish-embed flourish-bar-chart-race" data-src="visualisation/'.htmlspecialchars($node->textContent,2).'" data-url="https://flo.uri.sh/visualisation/'.htmlspecialchars($node->textContent,2).'/embed"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'DC':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DD':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DDC':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Color+by+test+positivity=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DEB':$this->out.='<iframe width="480" height="270" style="width:480px;height:270px" src="http://mediaspip.ptitdeb.infini.fr/spip.php?page=embed_code&amp;id_objet='.htmlspecialchars($node->textContent,2).'&amp;objet=document&amp;largeur=480&amp;hauteur=270" frameborder="0" allowfullscreen=""></iframe>';break;case'DEMOCRACYNOW':$this->out.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((strpos($node->getAttribute('id'),'/headlines')!==false))$this->out.='headlines/'.htmlspecialchars(strstr($node->getAttribute('id'),'/headlines',true),2);elseif((strpos($node->getAttribute('id'),'2')===0))$this->out.='story/'.htmlspecialchars($node->getAttribute('id'),2);elseif((strpos($node->getAttribute('id'),'shows/')===0))$this->out.='show/'.htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'DEW':$this->out.='<audio controls=""><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/ogg"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/mpeg"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/wav"></audio>';break;case'DH':$this->out.='<iframe src="https://ourworldindata.org/grapher/weekly-hospital-admissions-covid?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DMOTION':$this->out.='<iframe frameborder="0" width="480" height="270" src="https://www.dailymotion.com/embed/video/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'DOCGOOGLE':$this->out.='<iframe src="https://docs.google.com/file/d/'.htmlspecialchars($node->textContent,2).'/preview" width="640" height="480"></iframe>';break;case'DOCPLAYER':$this->out.='<div><div><a target="_blank" href="'.htmlspecialchars($node->textContent,2).'" rel="noreferrer"></a></div><div><iframe frameborder="0" style="border-bottom:2px solid #eee;border-top:0" scrolling="no" src="http://docplayer.fr/docview/112/202650701/" width="728" height="1040" allowfullscreen=""></iframe></div></div>';break;case'DR':$this->out.='<iframe src="https://ourworldindata.org/grapher/current-covid-patients-icu?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DUMPERT':$this->out.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.htmlspecialchars(strtr($node->getAttribute('id'),'/','_'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'E':if($this->params['S_VIEWSMILIES']==='')$this->out.=htmlspecialchars($node->textContent,0);else{switch($node->textContent){case'8-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="17" alt="8-)" title="Cool">';break;case':!:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_exclaim.gif" width="15" height="17" alt=":!:" title="Exclamation">';break;case':(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":(" title="Triste">';break;case':)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":)" title="Sourire">';break;case':-(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":-(" title="Triste">';break;case':-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":-)" title="Sourire">';break;case':-?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":-?" title="Confus">';break;case':-D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":-D" title="Très content">';break;case':-P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":-P" title="Tire la langue">';break;case':-o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":-o" title="Surprise">';break;case':-x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":-x" title="Fou">';break;case':-|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="17" alt=":-|" title="Neutre">';break;case':?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":?" title="Confus">';break;case':?:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_question.gif" width="15" height="17" alt=":?:" title="Question">';break;case':???:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":???:" title="Confus">';break;case':D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":D" title="Très content">';break;case':P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":P" title="Tire la langue">';break;case':arrow:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow.gif" width="15" height="17" alt=":arrow:" title="Flèche">';break;case':cool:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="17" alt=":cool:" title="Cool">';break;case':cry:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cry.gif" width="15" height="17" alt=":cry:" title="Très triste, en pleurs">';break;case':eek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":eek:" title="Surprise">';break;case':evil:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_evil.gif" width="15" height="17" alt=":evil:" title="Diable">';break;case':geek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_geek.gif" width="17" height="17" alt=":geek:" title="Geek">';break;case':grin:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":grin:" title="Très content">';break;case':idea:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_idea.gif" width="15" height="17" alt=":idea:" title="Idée">';break;case':lol:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_lol.gif" width="15" height="17" alt=":lol:" title="Rire">';break;case':mad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":mad:" title="Fou">';break;case':mrgreen:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mrgreen.gif" width="15" height="17" alt=":mrgreen:" title="M. Vert">';break;case':o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":o" title="Surprise">';break;case':oops:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redface.gif" width="15" height="17" alt=":oops:" title="Embarrassé">';break;case':razz:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":razz:" title="Tire la langue">';break;case':roll:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rolleyes.gif" width="15" height="17" alt=":roll:" title="Yeux tournants">';break;case':sad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":sad:" title="Triste">';break;case':shock:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="17" alt=":shock:" title="Choqué">';break;case':smile:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":smile:" title="Sourire">';break;case':twisted:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_twisted.gif" width="15" height="17" alt=":twisted:" title="Diable rieur">';break;case':ugeek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_ugeek.gif" width="17" height="18" alt=":ugeek:" title="Geek barbu">';break;case':wink:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=":wink:" title="Clin d’œil">';break;case':x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":x" title="Fou">';break;case':|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="17" alt=":|" title="Neutre">';break;case';)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=";)" title="Clin d’œil">';break;case';-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=";-)" title="Clin d’œil">';break;default:$this->out.=htmlspecialchars($node->textContent,0);}}break;case'ECHOS':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01578907/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="480" height="400" allow="autoplay; fullscreen"></iframe>';break;case'ED':$this->out.='<iframe src="https://ourworldindata.org/grapher/excess-deaths-cumulative-economist-who?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EDV':$this->out.='<iframe src="https://ourworldindata.org/grapher/life-expectancy?tab=chart&amp;time=earliest..2019&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EIGHTTRACKS':$this->out.='<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/'.htmlspecialchars($node->getAttribute('id'),2).'/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'EMAIL':$this->out.='<a href="mailto:'.htmlspecialchars($node->getAttribute('email'),2);if($node->hasAttribute('subject')||$node->hasAttribute('body')){$this->out.='?';if($node->hasAttribute('subject'))$this->out.='subject='.htmlspecialchars($node->getAttribute('subject'),2);if($node->hasAttribute('body')){if($node->hasAttribute('subject'))$this->out.='&amp;';$this->out.='body='.htmlspecialchars($node->getAttribute('body'),2);}}$this->out.='">';$this->at($node);$this->out.='</a>';break;case'EMOJI':if($this->params['S_VIEWSMILIES']!==''){$this->out.='<img alt="'.htmlspecialchars($node->textContent,2).'" class="emoji smilies" draggable="false" src="';if($node->hasAttribute('tseq'))$this->out.='//twemoji.maxcdn.com/2/svg/'.htmlspecialchars($node->getAttribute('tseq'),2).'.svg';else$this->out.='https://cdn.jsdelivr.net/gh/s9e/emoji-assets-twemoji@11.2/dist/svgz/'.htmlspecialchars($node->getAttribute('seq'),2).'.svgz';$this->out.='">';}else$this->out.=htmlspecialchars($node->textContent,0);break;case'ENS':$this->out.='<div id="jwplayer">Loading the player...</div><script type="text/javascript">
	        jwplayer("jwplayer").setup({
	        playlist: [{
	        		poster: "http://savoirs.ens.fr/images/accueil_video_savoirs.jpg",
	                image: "http://savoirs.ens.fr/images/accueil_video_savoirs.jpg",
	                sources: [{ 
	                    file: "rtmp://91.121.116.112:1935/vod/mp4:/diffusion/';$this->at($node);$this->out.='"
	                },{
	                    file: "./uploads/videos//diffusion/';$this->at($node);$this->out.='",
	                }]
	         }],
	        height: 360,
	        primary: "flash",
	        width: 640
	        });
		</script>';break;case'ESPN':$this->out.='<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'EUR1':$this->out.='<iframe src="https://www.europe1.fr/videos/embed/'.htmlspecialchars($node->textContent,2).'" width="734px" height="406px"></iframe>';break;case'EUROSTAT':$this->out.='<iframe width="964" height="462" src="https://ec.europa.eu/eurostat/statistics-explained/index.php?'.htmlspecialchars($node->textContent,2).'" scrolling="no" frameborder="0"></iframe>';break;case'EXPLORER':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER2':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER3':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~European+Union&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'FACEBOOK':$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FB':$this->out.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href='.htmlspecialchars($node->textContent,2).'&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FBBRUT':$this->out.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href=https%3A%2F%2Fwww.facebook.com%2Fbrutofficiel%2Fvideos%2F'.htmlspecialchars($node->textContent,2).'%2F&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FIG':$this->out.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;autoplay=true" allowfullscreen="" width="640" height="360"></iframe>';break;case'FLASH':if($this->params['S_VIEWFLASH']!=='')$this->out.='<object classid="clsid:D27CDB6E-AE6D-11CF-96B8-444553540000" codebase="http://active.macromedia.com/flash2/cabs/swflash.cab#version=5,0,0,0" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'"><param name="movie" value="'.htmlspecialchars($node->getAttribute('url'),2).'"><param name="play" value="false"><param name="loop" value="false"><param name="quality" value="high"><param name="allowScriptAccess" value="never"><param name="allowNetworking" value="internal"><embed src="'.htmlspecialchars($node->getAttribute('url'),2).'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'" play="false" loop="false" quality="high" allowscriptaccess="never" allownetworking="internal"></object>';else$this->at($node);break;case'FLICKR':$this->out.='<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/'.htmlspecialchars($node->getAttribute('id'),2).'/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FLO':$this->out.='<div class="flourish-embed flourish-table" data-src="'.htmlspecialchars($node->textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLOURISH':$this->out.='<div class="flourish-embed flourish-chart" data-src="visualisation/'.htmlspecialchars($node->textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLV':$this->out.='<embed src="http://yourserver.com/player.swf" width="450" height="360" allowscriptaccess="always" allowfullscreen="true" flashvars="width=450&amp;volume=50&amp;displayclick=none&amp;fullscreen=true&amp;file='.htmlspecialchars($node->getAttribute('content'),2).'">';break;case'FM':$this->out.='<iframe src="http://www.francemusique.fr/player/export-reecouter?content='.htmlspecialchars($node->textContent,2).'" width="481" frameborder="0" scrolling="no" height="137"></iframe>';break;case'FOXNEWS':$this->out.='<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FRANCEINFO':$this->out.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe><br>';break;case'FREEMP3':$this->out.='<table><tr><td><a href="http://www.freemp3go.org/track.php?id='.htmlspecialchars($node->textContent,2).'="></a></td></tr><tr><td><script type="text/javascript" src="http://jwpsrv.com/library/lNwD_IqdEeKinyIACp8kUw.js"></script><div id="playAround_wrapper">Loading the player...</div><script type="text/javascript">/**/jwplayer.key=&quot;7VoWoDgr0Gmogb5TdwF7v2lsIYKG8SZUo1ztUg==&quot;;jwplayer(&quot;playAround_wrapper&quot;).setup({&quot;width&quot;:340,&quot;height&quot;:26,&quot;autostart&quot;:true,&quot;playlist&quot;:[{&quot;image&quot;:&quot;http:\\/\\/www.freemp3go.org\\/images\\/logo.jpg&quot;,&quot;sources&quot;:[{&quot;type&quot;:&quot;flv&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=flv&quot;,&quot;default&quot;:true},{&quot;type&quot;:&quot;mp4&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=mp4&quot;}]}]});/**/</script></td></tr><tr></tr></table>';break;case'FTV':$this->out.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'FUNNYORDIE':$this->out.='<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMESPOT':$this->out.='<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GBOOK':$this->out.='<iframe frameborder="0" scrolling="no" style="border:0" src="https://books.google.fr/books?id='.htmlspecialchars($node->textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;output=embed" width="500" height="500"></iframe>';break;case'GBOOK155':$this->out.='<iframe frameborder="0" scrolling="no" style="border:0" src="http://books.google.fr/books?id='.htmlspecialchars($node->textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;pg=PA155&amp;output=embed" width="500" height="500"></iframe>';break;case'GEND':$this->out.='<iframe src="http://players.brightcove.net/610043537001/B1c7CqZH_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'GETTY':$this->out.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?et='.htmlspecialchars($node->getAttribute('et'),2).'&amp;tld=com&amp;sig='.htmlspecialchars($node->getAttribute('sig'),2).'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$this->out.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*($node->getAttribute('height')+44)/$node->getAttribute('width'),2).'%;padding-bottom:calc('.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'% + 44px)';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gfycat.com/ifr/'.htmlspecialchars($node->getAttribute('id'),2).'?hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$this->out.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$this->out.='<iframe src="https://giphy.com/embed/'.htmlspecialchars($node->textContent,2).'" width="480" height="384" frameborder="0" class="giphy-embed" allowfullscreen=""></iframe><p><a href="https://giphy.com/gifs/harvardmed-LmCsBMgBeXBY4yUWWq">via GIPHY</a></p>';break;case'GIST':$this->out.='<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;width:100%"></iframe>';break;case'GLOBALNEWS':$this->out.='<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOFUNDME':$this->out.='<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund='.htmlspecialchars($node->getAttribute('id'),2).'&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEDRIVE':$this->out.='<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/'.htmlspecialchars($node->getAttribute('id'),2).'/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEPLUS':$this->out.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if($node->hasAttribute('oid'))$this->out.=htmlspecialchars($node->getAttribute('oid'),2);else$this->out.='+'.htmlspecialchars($node->getAttribute('name'),2);$this->out.='/posts/'.htmlspecialchars($node->getAttribute('pid'),2).'"></iframe>';break;case'GOOGLESHEETS':if($node->getAttribute('type')==='chart')$this->out.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/pubchart?oid='.htmlspecialchars($node->getAttribute('oid'),2).'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$this->out.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/p';if((strpos($node->getAttribute('id'),'e/')===0))$this->out.='ubhtml?widget=true&amp;headers=false';else$this->out.='review';$this->out.='#gid='.htmlspecialchars($node->getAttribute('gid'),2).'"></iframe>';}break;case'GRAPH':$this->out.='<iframe width="45%" height="500" src="'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no"></iframe>';break;case'GVIEW':$this->out.='<iframe src="https://docs.google.com/viewerng/viewer?url='.htmlspecialchars($node->getAttribute('content'),2).'" width="100%"></iframe>';break;case'HUDL':$this->out.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if($node->hasAttribute('id'))$this->out.='video/'.htmlspecialchars($node->getAttribute('id'),2);else$this->out.='athlete/'.htmlspecialchars($node->getAttribute('athlete'),2).'/highlights/'.htmlspecialchars($node->getAttribute('highlight'),2);$this->out.='"></iframe></span></span>';break;case'HULU':$this->out.='<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'I':$this->out.='<em class="text-italics">';$this->at($node);$this->out.='</em>';break;case'IFRAP':$this->out.='<iframe src="http://www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($node->textContent,2).'" width="670" height="715" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px 1px 0;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'IGN':$this->out.='<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMDB':$this->out.='<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi'.htmlspecialchars($node->getAttribute('id'),2).'/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMG':if($this->params['S_VIEWIMG']!=='')$this->out.='<img src="'.htmlspecialchars($node->getAttribute('src'),2).'" class="postimage" alt="'.htmlspecialchars($this->params['L_IMAGE'],2).'">';else$this->at($node);break;case'IMGUR':$this->out.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){var d=e.data.split(\' \');style.height=d[0]+\'px\';style.width=d[1]+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($node->getAttribute('type')==='album')$this->out.='a/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';break;case'INA':$this->out.='<iframe width="620" height="349" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="http://player.ina.fr/player/embed/'.htmlspecialchars($node->textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/620/349/0/148db8"></iframe>';break;case'INA1':$this->out.='<iframe width="100%" height="100%" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://player.ina.fr/player/embed/'.htmlspecialchars($node->textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/wide/1" allow="fullscreen,autoplay"></iframe>';break;case'INA2':$this->out.='<iframe frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://fresques.ina.fr/de-gaulle/export/player/'.htmlspecialchars($node->textContent,2).'/wide?isAmalia=1" width="620" height="465" allowfullscreen=""></iframe>';break;case'INDIEGOGO':$this->out.='<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/'.htmlspecialchars($node->getAttribute('id'),2).'/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'INSTAGRAM':$this->out.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/instagram.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="background:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"></iframe>';break;case'INTER':$this->out.='<iframe src="https://www.franceinter.fr/embed/player/aod/'.htmlspecialchars($node->textContent,2).'" width="100%" height="64" frameborder="0" scrolling="no"></iframe>';break;case'INTERNETARCHIVE':if((strpos($node->getAttribute('id'),'playlist=1')!==false))$this->out.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$this->out.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'IRSEM':$this->out.='<iframe width="100%" height="300" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->textContent,2).'&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe>';break;case'IRSN':$this->out.='<iframe frameborder="0" width="240" height="210" title="" src="https://barometre.irsn.fr/'.htmlspecialchars($node->textContent,2).'/" type="text/html" allowfullscreen="true" scrolling="no" marginwidth="0" marginheight="0"></iframe>';break;case'ITELE':$this->out.='<div><iframe webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen="" width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=itele_vod&amp;vid='.htmlspecialchars($node->textContent,2).'"></iframe></div>';break;case'IZLESENE':$this->out.='<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/'.htmlspecialchars($node->getAttribute('id'),2).'?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'JWPLATFORM':$this->out.='<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/'.htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KHL':$this->out.='<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/'.htmlspecialchars($node->getAttribute('id'),2).'?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KICKSTARTER':$this->out.='<span data-s9e-mediaembed="kickstarter"';if($node->hasAttribute('video'))$this->out.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'KNOEMA':$this->out.='<iframe src="https://knoema.fr/atlas/embed/topics/'.htmlspecialchars($node->textContent,2).'?type=maps" allowtransparency="true" frameborder="0" width="920" min-width="560" height="700" scrolling="no"></iframe>';break;case'LB':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/'.htmlspecialchars($node->textContent,2).'/src/qx5kszf/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="620" height="349" allow="autoplay; fullscreen"></iframe>';break;case'LC':$this->out.='<iframe src="https://ourworldindata.org/grapher/low-carbon-share-energy?tab=chart&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'LESOIR':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01613302/src/'.htmlspecialchars($node->textContent,2).'/zone/34/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="646" height="363" allow="autoplay; fullscreen"></iframe>';break;case'LI':$this->out.='<li>';$this->at($node);$this->out.='</li>';break;case'LIBSYN':$this->out.='<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/'.htmlspecialchars($node->getAttribute('id'),2).'/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>';break;case'LINKEDIN':$this->out.='<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:'.htmlspecialchars($node->textContent,2).'" height="541" width="504" frameborder="0" allowfullscreen="" title="Post intégré"></iframe>';break;case'LINK_TEXT':$this->out.=htmlspecialchars($node->getAttribute('text'),0);break;case'LIST':if(!$node->hasAttribute('type')){$this->out.='<ul>';$this->at($node);$this->out.='</ul>';}elseif((strpos('upperlowerdecim',mb_substr($node->getAttribute('type'),0,5,'utf-8'))!==false)){$this->out.='<ol style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ol>';}else{$this->out.='<ul style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ul>';}break;case'LIVELEAK':$this->out.='<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIVESTREAM':$this->out.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->hasAttribute('clip_id'))$this->out.='cdn.livestream.com/embed/'.htmlspecialchars($node->getAttribute('channel'),2).'?layout=4&amp;autoplay=false&amp;clip='.htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='livestream.com/accounts/'.htmlspecialchars($node->getAttribute('account_id'),2).'/events/'.htmlspecialchars($node->getAttribute('event_id'),2);if($node->hasAttribute('video_id'))$this->out.='/videos/'.htmlspecialchars($node->getAttribute('video_id'),2);$this->out.='/player?autoPlay=false';}$this->out.='"></iframe></span></span>';break;case'LUMNI':$this->out.='<iframe allow="autoplay" title="" src="https://enseignants.lumni.fr/export/player/'.htmlspecialchars($node->textContent,2).'" width="100%" height="100%" allowfullscreen=""></iframe>';break;case'MAILRU':$this->out.='<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MAP':$this->out.='<div class="cpi-node" data-embed="map"></div><script src="'.htmlspecialchars($node->textContent,2).'"></script>';break;case'MEDIUM':$this->out.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:316px;max-width:900px;width:100%"></iframe>';break;case'METACAFE':$this->out.='<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MIXCLOUD':$this->out.='<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F'.htmlspecialchars($node->getAttribute('id'),2).'%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MLB':$this->out.='<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MP3':$this->out.='<p style="color:rgb(0,0,0);font-family:Arial,sans-serif;font-size:11px;font-weight:normal;text-align:center;text-decoration:none"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" id="dewplayer" align="middle" height="30" width="300"><param name="allowScriptAccess" value="sameDomain"><param name="movie" value="http://forum.frequencebonheur.fr//dewplayer.swf?son='.htmlspecialchars($node->getAttribute('content'),2).'&amp;autostart=0&amp;bgcolor=FFFFFF"><param name="quality" value="high"><param name="bgcolor" value="FFFFFF"><embed src="http://forum.frequencebonheur.fr//dewplayer.swf?son='.htmlspecialchars($node->getAttribute('content'),2).'&amp;autostart=0&amp;bgcolor=FFFFFF" quality="high" bgcolor="FFFFFF" name="dewplayer" allowscriptaccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" align="middle" height="30" width="300"></object> <a href="'.htmlspecialchars($node->getAttribute('content'),2).'"><img style="border:medium none;text-decoration:none" src="http://img159.imageshack.us/img159/7397/f7943d41oy2.jpg" title="Podcast" alt="Podcast" align="absbottom"></a><br></p>';break;case'MP4':$this->out.='<video width="600" controls="controls"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="video/mp4"></video>';break;case'MRCTV':$this->out.='<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MSNBC':$this->out.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($node->getAttribute('id'),'_')!==false))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$this->out.='</span></span>';break;case'NATGEOCHANNEL':$this->out.='<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NATGEOVIDEO':$this->out.='<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCNEWS':$this->out.='<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCSPORTS':$this->out.='<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/'.htmlspecialchars($node->getAttribute('id'),2).'?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NFR':$this->out.='<embed src="http://www.npr.org/v2/?i='.htmlspecialchars($node->textContent,2).'&amp;m=259646821&amp;t=audio" height="386" wmode="opaque" allowfullscreen="true" width="400" base="http://www.npr.org" type="application/x-shockwave-flash">';break;case'NHL':$this->out.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if($node->hasAttribute('t'))$this->out.='/t-'.htmlspecialchars($node->getAttribute('t'),2);if($node->hasAttribute('c'))$this->out.='/c-'.htmlspecialchars($node->getAttribute('c'),2);$this->out.='?autostart=false"></iframe></span></span>';break;case'NPR':$this->out.='<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/'.htmlspecialchars($node->getAttribute('i'),2).'/'.htmlspecialchars($node->getAttribute('m'),2).'" style="border:0;height:228px;max-width:800px;width:100%"></iframe>';break;case'NYT':$this->out.='<iframe width="480" height="373" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" id="nyt_video_player" title="New York Times Video - Embed Player" src="http://graphics8.nytimes.com/bcvideo/1.0/iframe/embed.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;playerType=embed"></iframe>';break;case'NYTIMES':$this->out.='<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'OCDE':$this->out.='<embed src="http://www.pearsonfoundation.org/media/player-licensed.swf" width="640" height="376" allowscriptaccess="always" allowfullscreen="false" flashvars="file=http://www.pearsonfoundation.org/oecd/media/'.htmlspecialchars($node->textContent,2).'.mp4&amp;skin=http://www.pearsonfoundation.org/media/pf.swf">';break;case'ODYSEE':$this->out.='<iframe id="lbry-iframe" width="560" height="315" src="https://odysee.com/$/embed/'.htmlspecialchars($node->textContent,2).'" allowfullscreen=""></iframe>';break;case'OF':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01124706/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="640" height="360"></iframe>';break;case'OOYALA':$this->out.='<iframe width="640" height="480" frameborder="0" allowfullscreen="" src="//player.ooyala.com/static/v4/candidate/latest/skin-plugin/iframe.html?'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'ORFIUM':$this->out.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if($node->hasAttribute('album_id'))$this->out.='album/'.htmlspecialchars($node->getAttribute('album_id'),2);elseif($node->hasAttribute('playlist_id'))$this->out.='playlist/'.htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('set_id'))$this->out.='live-set/'.htmlspecialchars($node->getAttribute('set_id'),2);else$this->out.='track/'.htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='" style="border:0;height:';if($node->hasAttribute('album_id'))$this->out.='550';else$this->out.='275';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'OWID':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'OWIDEX':case'e':case'i':case's':break;case'PASTEBIN':$this->out.='<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;resize:vertical;width:100%"></iframe>';break;case'PDF':$this->out.='<embed src="'.htmlspecialchars($node->getAttribute('content'),2).'" width="100%" height="500px">';break;case'PINTEREST':$this->out.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:';if((strpos($node->getAttribute('id'),'/')!==false))$this->out.='730';else$this->out.='345';$this->out.='px;width:100%"></iframe>';break;case'PODBEAN':$this->out.='<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.podbean.com/player-v2/?i='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'POLLSTER':$this->out.='<script src="http://elections.huffingtonpost.com/pollster/'.htmlspecialchars($node->textContent,2).'/embed.js"></script>';break;case'PREZI':$this->out.='<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'QUOTE':$this->out.='<blockquote';if($node->hasAttribute('post_url'))$this->out.=' cite="'.htmlspecialchars($node->getAttribute('post_url'),2).'"';if(!$node->hasAttribute('author'))$this->out.=' class="uncited"';$this->out.='><div>';if($node->hasAttribute('author')){$this->out.='<cite>';if($node->hasAttribute('url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';elseif($node->hasAttribute('profile_url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('profile_url'),2).'">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';else$this->out.=htmlspecialchars($node->getAttribute('author'),0);$this->out.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if($node->hasAttribute('post_url'))$this->out.=' <a href="'.htmlspecialchars($node->getAttribute('post_url'),2).'" data-post-id="'.htmlspecialchars($node->getAttribute('post_id'),2).'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if($node->hasAttribute('msg_url'))$this->out.=' <a href="'.htmlspecialchars($node->getAttribute('msg_url'),2).'" data-msg-id="'.htmlspecialchars($node->getAttribute('msg_id'),2).'">↑</a>';if($node->hasAttribute('date'))$this->out.='<span class="responsive-hide">'.htmlspecialchars($node->getAttribute('date'),0).'</span>';$this->out.='</cite>';}$this->at($node);$this->out.='</div></blockquote>';break;case'REDDIT':$this->out.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.htmlspecialchars($node->getAttribute('id').$node->getAttribute('path'),2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'REPORTERRE':$this->out.='<iframe frameborder="0" loading="lazy" id="ausha-r1JH" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId='.htmlspecialchars($node->textContent,2).'&amp;v=3&amp;playerId=ausha-r1JH"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'RESIZE':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('content'),2).'"><img style="max-width:800px;max-height;800px" src="'.htmlspecialchars($node->getAttribute('content'),2).'" alt="Image"></a>';break;case'RTE':$this->out.='<iframe src="https://eco2mix.rte-france.com/pluginWeb/data?key='.htmlspecialchars($node->textContent,2).'" width="350" height="370"></iframe>';break;case'RTL':case'RTLBE':$this->out.='<div style="width:600px;height:338px"><script async="async" type="text/javascript" src="//www.rtl.be/videos/player/vp_embed.js" videoid="'.htmlspecialchars($node->textContent,2).'"></script></div>';break;case'RTS':$this->out.='<iframe width="560" height="315" src="https://www.rts.ch/play/embed?urn=urn:rts:video:'.htmlspecialchars($node->textContent,2).'&amp;subdivisions=false" allowfullscreen="" allow="geolocation *; autoplay; encrypted-media"></iframe>';break;case'RUTUBE':$this->out.='<iframe width="720" height="405" src="//rutube.ru/video/embed/'.htmlspecialchars($node->textContent,2).'" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'SAPIENS':$this->out.='<iframe width="100%" height="450" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/859584016&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe><div style="font-size:10px;color:#ccc;line-break:anywhere;word-break:normal;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight:100"><a href="https://soundcloud.com/user-702632852" title="Institut Sapiens" target="_blank" style="color:#ccc;text-decoration:none" rel="noreferrer">Institut Sapiens</a> · <a href="https://soundcloud.com/user-702632852/'.htmlspecialchars($node->textContent,2).'"></a></div>';break;case'SCRIB':$this->out.='<iframe class="scribd_iframe_embed" src="https://www.scribd.com/embeds/'.htmlspecialchars($node->textContent,2).'/content?start_page=1&amp;view_mode=scroll&amp;access_key=key-2imc0qq0kxk41ryg1wrd&amp;show_recommendations=false" data-auto-height="false" data-aspect-ratio="0.7729220222793488" scrolling="no" id="doc_25852" width="600" height="800" frameborder="0"></iframe>';break;case'SCRIBD':$this->out.='<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/'.htmlspecialchars($node->getAttribute('id'),2).'/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';break;case'SENAT':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'" width="640" height="430" frameborder="0" allowfullscreen="true" scrolling="no"></iframe>';break;case'SIZE':$this->out.='<span style="font-size:'.htmlspecialchars($node->getAttribute('size'),2).'%;line-height:116%">';$this->at($node);$this->out.='</span>';break;case'SLIDE':$this->out.='<iframe src="//www.slideshare.net/slideshow/embed_code/key/'.htmlspecialchars($node->textContent,2).'" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'SLIDESHARE':$this->out.='<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SOUNDCLOUD':case'UNO':$this->out.='<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->textContent,2).'&amp;color=ff5500"></iframe>';break;case'SPORTSNET':$this->out.='<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPOTIFY':$this->out.='<iframe src="https://open.spotify.com/embed/show/'.htmlspecialchars($node->textContent,2).'" width="100%" height="232" frameborder="0" allowtransparency="true" allow="encrypted-media"></iframe>';break;case'STATIC':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'" width="480" height="270" frameborder="0" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'STEAMSTORE':$this->out.='<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:190px;max-width:900px;width:100%"></iframe>';break;case'STITCHER':$this->out.='<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/'.htmlspecialchars($node->getAttribute('fid'),2).'/'.htmlspecialchars($node->getAttribute('eid'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'STRAWPOLL':$this->out.='<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMABLE':$this->out.='<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMJA':$this->out.='<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TABLE':$this->out.='<table style="width:100%;display:inline-table;border:#333 solid 1px;background:#f2f2f2">';$this->at($node);$this->out.='</table>';break;case'TD':$this->out.='<td valign="top" style="border-top:1px solid #808080;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">';$this->at($node);$this->out.='</td>';break;case'TEAMCOCO':$this->out.='<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TED':case'TED2':case'TED3':$this->out.='<div style="max-width:854px"><div style="position:relative;height:0;padding-bottom:56.25%"><iframe src="https://embed.ted.com/talks/lang/fr/'.htmlspecialchars($node->textContent,2).'" width="854" height="480" style="position:absolute;left:0;top:0;width:100%;height:100%" frameborder="0" scrolling="no" allowfullscreen=""></iframe></div></div>';break;case'TELEGRAM':$this->out.='<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/telegram.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:96px;max-width:500px;width:100%"></iframe>';break;case'TELEGRAMME':$this->out.='<iframe src="https://www.letelegramme.fr/static/ftp/dossier/data/dataviz/iframe/iframe.php?id='.htmlspecialchars($node->textContent,2).'" width="100%" height="400&quot;" style="max-width:100%" frameborder="0"></iframe>';break;case'TF1':$this->out.='<iframe src="//www.tf1.fr/embedframe/'.htmlspecialchars($node->textContent,2).'" frameborder="0" style="width:640px;height:360px"></iframe>';break;case'TH':$this->out.='<td valign="top" style="border-top:1px solid #808080;font-weight:bold;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">';$this->at($node);$this->out.='</td>';break;case'THEATLANTIC':$this->out.='<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEGUARDIAN':$this->out.='<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEONION':$this->out.='<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TIKTOK':$this->out.='<span data-s9e-mediaembed="tiktok" style="display:inline-block;width:100%;max-width:340px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:205.882353%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.tiktok.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TLG':$this->out.='<script async="" src="https://telegram.org/js/telegram-widget.js?19" data-telegram-post="'.htmlspecialchars($node->textContent,2).'" data-width="100%"></script>';break;case'TMZ':$this->out.='<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TR':$this->out.='<tr>';$this->at($node);$this->out.='</tr>';break;case'TRAILERADDICT':$this->out.='<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TUMBLR':$this->out.='<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#'.htmlspecialchars($node->getAttribute('key'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;max-width:520px;width:100%"></iframe>';break;case'TWENTYFOURSEVENSPORTS':if($node->hasAttribute('video_id'))$this->out.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26channel%3Dmobilevideo%26pcid%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$this->out.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.htmlspecialchars($node->getAttribute('player_id'),2).'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITCH':$this->out.='<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="contentWindow.postMessage(\'\',\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel='.htmlspecialchars($node->getAttribute('channel'),2).';clip_id='.htmlspecialchars($node->getAttribute('clip_id'),2).';t='.htmlspecialchars($node->getAttribute('t'),2).';video_id='.htmlspecialchars($node->getAttribute('video_id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TWITTER':$this->out.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars($node->getAttribute('id').$this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:250px;max-width:550px;width:100%"></iframe>';break;case'TWT':$this->out.='<script type="text/javascript"> function loadx(data) { document.write(data.html); } </script> <script type="text/javascript" src="https://api.twitter.com/1/statuses/oembed.json?id='.htmlspecialchars($node->getAttribute('content2'),2).'&amp;callback=loadx"></script> <div class="twitter" onload="loadx().html"></div>';break;case'U':$this->out.='<span style="text-decoration:underline">';$this->at($node);$this->out.='</span>';break;case'ULTI':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01946947/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="470" height="300" allow="autoplay; fullscreen"></iframe>';break;case'UNIGE':$this->out.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url=https://mediaserver.unige.ch/media/'.htmlspecialchars($node->textContent,2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'UNIV':$this->out.='<iframe class="player" frameborder="0" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="'.htmlspecialchars($node->textContent,2).'" width="576" height="324"> </iframe>';break;case'URL':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">';$this->at($node);$this->out.='</a>';break;case'USTREAM':$this->out.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if($node->hasAttribute('vid'))$this->out.='recorded/'.htmlspecialchars($node->getAttribute('vid'),2);else$this->out.=htmlspecialchars($node->getAttribute('cid'),2);$this->out.='?html5ui"></iframe></span></span>';break;case'VBOX7':$this->out.='<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VEOH':$this->out.='<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v'.htmlspecialchars($node->getAttribute('id'),2).'&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'VEVO':$this->out.='<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEO':$this->out.='<div class="bbvideo" data-url="'.htmlspecialchars($node->getAttribute('content'),2).'" style="width:640px;height:390px;margin:2px 0;display:inline-block;background:#000;color:#fff;overflow:hidden;vertical-align:bottom"><div style="height:100%"><script>if (typeof bbmedia == \'undefined\') { bbmedia = true; var e = document.createElement(\'script\'); e.async = true; e.src = \'http://phpbbex.com/api/bbmedia.js\'; var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(e, s); }</script></div><div style="text-align:right;height:14px;margin-top:-14px;padding-right:2px;font:10px/10px Verdana;color:#555"><a style="color:#105289;text-decoration:none" href="http://phpbbex.com/" target="_blank" rel="noreferrer">phpBB</a> [video]</div></div>';break;case'VIDEODETECTIVE':$this->out.='<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEOFIG':$this->out.='<object id="flashObj" width="800" height="450" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=4500912462001&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId='.htmlspecialchars($node->textContent,2).'&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="800" height="450" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'VIMEO':$this->out.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('t'))$this->out.='#t='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'VINE':$this->out.='<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VK':$this->out.='<iframe src="'.htmlspecialchars($node->getAttribute('content'),2).'" width="640" height="360" frameborder="0" allowfullscreen="1" allow="autoplay; encrypted-media; fullscreen; picture-in-picture"></iframe>';break;case'VMO':$this->out.='<iframe src="//player.vimeo.com/video/'.htmlspecialchars($node->textContent,2).'" width="640" height="470" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'VOCAROO':$this->out.='<span data-s9e-mediaembed="vocaroo"';if((strpos($node->getAttribute('id'),'s0')===0)||(strpos($node->getAttribute('id'),'s1')===0))$this->out.=' style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID='.htmlspecialchars($node->getAttribute('id'),2).'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:300px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:20%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'VOX':$this->out.='<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WASHINGTONPOST':$this->out.='<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WAT':$this->out.='<iframe src="http://www.wat.tv/embedframe/'.htmlspecialchars($node->textContent,2).'" frameborder="0" style="width:620px;height:350px"></iframe>';break;case'WID':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=latest&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'WMP':$this->out.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url='.htmlspecialchars($node->getAttribute('content'),2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'WPVIDEO':$this->out.='<embed type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" width="400" height="224" wmode="direct" seamlesstabbing="true" allowfullscreen="true" allowscriptaccess="always" overstretch="true" flashvars="guid='.htmlspecialchars($node->textContent,2).'&amp;isDynamicSeeking=true">';break;case'WSHH':$this->out.='<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//worldstarhiphop.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSJ':$this->out.='<iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" width="512" height="288" src="https://video-api.wsj.com/api-video/player/v3/iframe.html?guid='.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'XBOXCLIPS':$this->out.='<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/'.htmlspecialchars($node->getAttribute('user'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXDVR':$this->out.='<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/'.htmlspecialchars($node->getAttribute('user'),2).'/video/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUKU':$this->out.='<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUSCRIBE':$this->out.='<iframe src="//www.youscribe.com/BookReader/IframeEmbed?productId='.htmlspecialchars($node->textContent,2).'&amp;token=&amp;width=620&amp;height=917&amp;startPage=1&amp;displayMode=scroll&amp;fullscreen=0" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" frameborder="0" scrolling="no" width="620px" height="917px" marginwidth="0" marginheight="0" style="border:1px solid #44444a;width:620px;height:917px;margin:0;padding:0"></iframe>';break;case'YOUTUBE':$this->out.='<iframe width="480" height="360" src="//www.youtube.com/embed/'.htmlspecialchars($node->textContent,2).'" frameborder="0" allowfullscreen=""></iframe>';break;case'ZAD1':$this->out.='<object id="flashObj" width="480" height="270" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID=1321210711001&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID='.htmlspecialchars($node->textContent,2).'&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="480" height="270" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'br':$this->out.='<br>';break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	/** {@inheritdoc} */
	public $enableQuickRenderer=true;
	/** {@inheritdoc} */
	protected $static=['/B'=>'</strong>','/CODE'=>'</code></pre></div>','/COLOR'=>'</span>','/EMAIL'=>'</a>','/I'=>'</em>','/LI'=>'</li>','/QUOTE'=>'</div></blockquote>','/SIZE'=>'</span>','/TABLE'=>'</table>','/TD'=>'</td>','/TH'=>'</td>','/TR'=>'</tr>','/U'=>'</span>','/URL'=>'</a>','AKAD'=>'<iframe width="560" height="315" src="//embedftv-a.akamaihd.net/%7BTEXT%5D" frameborder="0" scrolling="no" allowfullscreen=""></iframe>','B'=>'<strong class="text-strong">','I'=>'<em class="text-italics">','LI'=>'<li>','OWIDEX'=>'','TABLE'=>'<table style="width:100%;display:inline-table;border:#333 solid 1px;background:#f2f2f2">','TD'=>'<td valign="top" style="border-top:1px solid #808080;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">','TH'=>'<td valign="top" style="border-top:1px solid #808080;font-weight:bold;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">','TR'=>'<tr>','U'=>'<span style="text-decoration:underline">'];
	/** {@inheritdoc} */
	protected $dynamic=['ABCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'AUDIOBOOM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/$1/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>'],'BITCHUTE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BLEACHERREPORT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id=$1&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNBC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid=$1&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video=$1&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNNMONEY'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/$1&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COLOR'=>['(^[^ ]+(?> (?!color=)[^=]+="[^"]*")*(?> color="([^"]*)")?.*)s','<span style="color:$1">'],'COMEDYCENTRAL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COUB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'DEW'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<audio controls=""><source src="$1" type="audio/ogg"><source src="$1" type="audio/mpeg"><source src="$1" type="audio/wav"></audio>'],'EIGHTTRACKS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/$1/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ESPN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FLICKR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/$1/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FLV'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<embed src="http://yourserver.com/player.swf" width="450" height="360" allowscriptaccess="always" allowfullscreen="true" flashvars="width=450&amp;volume=50&amp;displayclick=none&amp;fullscreen=true&amp;file=$1">'],'FOXNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FUNNYORDIE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GAMESPOT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GIST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#$1" style="border:0;height:180px;width:100%"></iframe>'],'GLOBALNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOFUNDME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund=$1&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOOGLEDRIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/$1/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GVIEW'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="https://docs.google.com/viewerng/viewer?url=$1" width="100%"></iframe>'],'HULU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IGN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IMDB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi$1/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INDIEGOGO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/$1/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INSTAGRAM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/instagram.min.html#$1" style="background:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"></iframe>'],'IZLESENE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/$1?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'JWPLATFORM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'KHL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/$1?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'LIBSYN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/$1/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>'],'LIVELEAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MAILRU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MEDIUM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#$1" style="border:0;height:316px;max-width:900px;width:100%"></iframe>'],'METACAFE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MIXCLOUD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F$1%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MLB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MP3'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<p style="color:rgb(0,0,0);font-family:Arial,sans-serif;font-size:11px;font-weight:normal;text-align:center;text-decoration:none"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" id="dewplayer" align="middle" height="30" width="300"><param name="allowScriptAccess" value="sameDomain"><param name="movie" value="http://forum.frequencebonheur.fr//dewplayer.swf?son=$1&amp;autostart=0&amp;bgcolor=FFFFFF"><param name="quality" value="high"><param name="bgcolor" value="FFFFFF"><embed src="http://forum.frequencebonheur.fr//dewplayer.swf?son=$1&amp;autostart=0&amp;bgcolor=FFFFFF" quality="high" bgcolor="FFFFFF" name="dewplayer" allowscriptaccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" align="middle" height="30" width="300"></object> <a href="$1"><img style="border:medium none;text-decoration:none" src="http://img159.imageshack.us/img159/7397/f7943d41oy2.jpg" title="Podcast" alt="Podcast" align="absbottom"></a><br></p>'],'MP4'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<video width="600" controls="controls"><source src="$1" type="video/mp4"></video>'],'MRCTV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOCHANNEL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/$1/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOVIDEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCSPORTS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/$1?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NPR'=>['(^[^ ]+(?> (?![im]=)[^=]+="[^"]*")*(?> i="([^"]*)")?(?> (?!m=)[^=]+="[^"]*")*(?> m="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/$1/$2" style="border:0;height:228px;max-width:800px;width:100%"></iframe>'],'NYTIMES'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'PASTEBIN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i=$1" style="border:0;height:300px;resize:vertical;width:100%"></iframe>'],'PDF'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<embed src="$1" width="100%" height="500px">'],'PODBEAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.podbean.com/player-v2/?i=$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'PREZI'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'RESIZE'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<a href="$1"><img style="max-width:800px;max-height;800px" src="$1" alt="Image"></a>'],'SCRIBD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/$1/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'],'SIZE'=>['(^[^ ]+(?> (?!size=)[^=]+="[^"]*")*(?> size="([^"]*)")?.*)s','<span style="font-size:$1%;line-height:116%">'],'SLIDESHARE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SPORTSNET'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STEAMSTORE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/$1" style="border:0;height:190px;max-width:900px;width:100%"></iframe>'],'STITCHER'=>['(^[^ ]+(?> (?![ef]id=)[^=]+="[^"]*")*(?> eid="([^"]*)")?(?> (?!fid=)[^=]+="[^"]*")*(?> fid="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/$2/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'STRAWPOLL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMABLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMJA'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TEAMCOCO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TELEGRAM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/telegram.min.html#$1" style="border:0;height:96px;max-width:500px;width:100%"></iframe>'],'THEATLANTIC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEGUARDIAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEONION'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TIKTOK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tiktok" style="display:inline-block;width:100%;max-width:340px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:205.882353%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.tiktok.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TMZ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRAILERADDICT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TUMBLR'=>['(^[^ ]+(?> (?!(?:id|key)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#$2/$1" style="border:0;height:300px;max-width:520px;width:100%"></iframe>'],'TWITCH'=>['(^[^ ]+(?> (?!(?:c(?:hannel|lip_id)|t|video_id)=)[^=]+="[^"]*")*(?> channel="([^"]*)")?(?> (?!(?:clip_id|t|video_id)=)[^=]+="[^"]*")*(?> clip_id="([^"]*)")?(?> (?!(?:t|video_id)=)[^=]+="[^"]*")*(?> t="([^"]*)")?(?> (?!video_id=)[^=]+="[^"]*")*(?> video_id="([^"]*)")?.*)s','<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="contentWindow.postMessage(\'\',\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel=$1;clip_id=$2;t=$3;video_id=$4" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TWT'=>['(^[^ ]+(?> (?!content2=)[^=]+="[^"]*")*(?> content2="([^"]*)")?.*)s','<script type="text/javascript"> function loadx(data) { document.write(data.html); } </script> <script type="text/javascript" src="https://api.twitter.com/1/statuses/oembed.json?id=$1&amp;callback=loadx"></script> <div class="twitter" onload="loadx().html"></div>'],'URL'=>['(^[^ ]+(?> (?!url=)[^=]+="[^"]*")*(?> url="([^"]*)")?.*)s','<a href="$1" class="postlink">'],'VBOX7'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VEOH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v$1&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'VEVO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDEO'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<div class="bbvideo" data-url="$1" style="width:640px;height:390px;margin:2px 0;display:inline-block;background:#000;color:#fff;overflow:hidden;vertical-align:bottom"><div style="height:100%"><script>if (typeof bbmedia == \'undefined\') { bbmedia = true; var e = document.createElement(\'script\'); e.async = true; e.src = \'http://phpbbex.com/api/bbmedia.js\'; var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(e, s); }</script></div><div style="text-align:right;height:14px;margin-top:-14px;padding-right:2px;font:10px/10px Verdana;color:#555"><a style="color:#105289;text-decoration:none" href="http://phpbbex.com/" target="_blank" rel="noreferrer">phpBB</a> [video]</div></div>'],'VIDEODETECTIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VINE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/$1/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VK'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="$1" width="640" height="360" frameborder="0" allowfullscreen="1" allow="autoplay; encrypted-media; fullscreen; picture-in-picture"></iframe>'],'VOX'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WASHINGTONPOST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WMP'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="http://elearn-services.unige.ch/medias/share/video?url=$1&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>'],'WSHH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//worldstarhiphop.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXCLIPS'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/$2/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXDVR'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/$2/video/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YOUKU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>']];
	/** {@inheritdoc} */
	protected $quickRegexp='(<(?:(?!/)((?:A(?:BCNEWS|CA(?:D|ST)|KAD|LTER|P[IO]|R(?:D|TE7?)|TT(?:ACHMENT|V)|U(?:DIO(?:BOOM|MACK)|SHA))|B(?:ANDCAMP|BC(?:4|NEWS)?|COVE|F(?:IG|M)|ITCHUTE|LEACHERREPORT|M|RIGHTCOVE)|C(?:A(?:LAMEO|NAL(?:-U)?)|BSNEWS|D[FN]|HART(?:[1-3]|CO2|N(?:DL|EWDEATHS)|TOTALDEATH)?|N(?:BC|N(?:MONEY)?)|O(?:MEDYCENTRAL|UB)|ULT)|D(?:[CHR]|A(?:ILYMOTION|TA)|DC?|E(?:[BW]|MOCRACYNOW)|MOTION|OC(?:GOOGLE|PLAYER)|UMPERT)|E(?:CHOS|DV?|IGHTTRACKS|MOJI|SPN|UR(?:1|OSTAT)|XPLORER[23]?)|F(?:ACEBOOK|B(?:BRUT)?|IG|L(?:ICKR|O(?:URISH)?|V)|M|OXNEWS|R(?:3|ANCEINFO|EEMP3)|TV|UNNYORDIE)|G(?:AMESPOT|BOOK(?:155)?|E(?:ND|TTY)|FYCAT|I(?:FS|PHY|ST)|LOBALNEWS|O(?:FUNDME|OGLE(?:DRIVE|PLUS|SHEETS))|RAPH|VIEW)|HU(?:DL|LU)|I(?:FRAP|GN|M(?:DB|GUR)|N(?:A[12]?|DIEGOGO|STAGRAM|TER(?:NETARCHIVE)?)|RS(?:EM|N)|TELE|ZLESENE)|JWPLATFORM|K(?:HL|ICKSTARTER|NOEMA)|L(?:[BC]|ESOIR|I(?:BSYN|NK(?:EDIN|_TEXT)|VE(?:LEAK|STREAM))|UMNI)|M(?:A(?:ILRU|P)|E(?:DIUM|TACAFE)|IXCLOUD|LB|P[34]|RCTV|SNBC)|N(?:[FP]R|ATGEO(?:CHANNEL|VIDEO)|BC(?:NEW|SPORT)S|HL|YT(?:IMES)?)|O(?:CDE|DYSEE|F|OYALA|RFIUM|WID(?:EX)?)|P(?:ASTEBIN|DF|INTEREST|O(?:DBEAN|LLSTER)|REZI)|R(?:E(?:DDIT|PORTERRE|SIZE)|T(?:[ES]|L(?:BE)?)|UTUBE)|S(?:APIENS|CRIBD?|ENAT|LIDE(?:SHARE)?|O(?:IR3|UNDCLOUD)|PO(?:RTSNET|TIFY)|T(?:ATIC|EAMSTORE|ITCHER|R(?:AWPOLL|EAM(?:ABLE|JA))))|T(?:E(?:AMCOCO|D[23]?|LEGRAM(?:ME)?)|F1|HE(?:ATLANTIC|GUARDIAN|ONION)|IKTOK|LG|MZ|RAILERADDICT|UMBLR|VINFO|W(?:ENTYFOURSEVENSPORTS|IT(?:CH|TER)|T))|U(?:LTI|N(?:I(?:GE|V)|O)|STREAM)|V(?:BOX7|E(?:OH|VO)|I(?:DEO(?:DETECTIVE|FIG)?|MEO|NE)|K|MO|O(?:CAROO|X))|W(?:A(?:SHINGTONPOS)?T|ID|MP|PVIDEO|S(?:HH|J))|XBOX(?:CLIPS|DVR)|YOU(?:KU|SCRIBE|TUBE)|ZAD1))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	/** {@inheritdoc} */
	protected $quickRenderingTest='((?<=<)(?:[!?]|(?:AMAZON|E(?:NS)?|FLASH|IMG)[ />]))';
	/** {@inheritdoc} */
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'/LIST':$attributes=array_pop($this->attributes);if(!isset($attributes['type']))$html.='</ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']??''),0,5,'utf-8'))!==false))$html.='</ol>';else$html.='</ul>';break;case'ACAD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'&amp;autostart=false" width="400" height="300" frameborder="0" scrolling="no" class="float_left_webcast"></iframe>';break;case'ACAST':$textContent=$this->getQuickTextContent($xml);$html.='<iframe title="Embed Player" width="100%" height="188px" src="https://embed.acast.com/'.htmlspecialchars($textContent,2).'" scrolling="no" frameborder="0" style="border:none;overflow:hidden"></iframe>';break;case'ALTER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="684" height="667" frameborder="0" src="https://www.alternatives-economiques.fr/embed/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'API':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="640" height="360" src="'.htmlspecialchars($textContent,2).'"></iframe>';break;case'APO':case'FR3':case'SOIR3':case'TVINFO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="640" height="360" src="http://api.dmcloud.net/player/embed/'.htmlspecialchars($textContent,2).'?exported=1"></iframe>';break;case'ARD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.ardmediathek.de/embed/'.htmlspecialchars($textContent,2).'" width="640" height="420" allowfullscreen="" frameborder="0" scrolling="no"></iframe>';break;case'ARTE':$textContent=$this->getQuickTextContent($xml);$html.='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" id="playerArte" allowscriptaccess="always" width="450" height="303"><param name="allowFullScreen" value="true"><param name="allowScriptAccess" value="always"><param name="quality" value="high"><param name="movie" value="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl='.htmlspecialchars($textContent,2).'&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false"><embed src="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Ffr%2Fdo%5Fdelegate%2Fvideos%2Fray%2Dkurzweil%2Dqu%2Dest%2Dce%2Dque%2Dla%2Dsingularite%2D%2D4157746%2Cview%2CasPlayerXml%2Exml&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false" width="450" height="303" allowfullscreen="true" name="playerArte" quality="high" allowscriptaccess="always" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></object>';break;case'ARTE7':$textContent=$this->getQuickTextContent($xml);$html.='<script type="text/javascript" src="https://www-secure.arte.tv/arte_vp/embed.php?json_url=http%3A%2F%2Fconcert.arte.tv%2Ffr%2Fplayer%2F'.htmlspecialchars($textContent,2).'&amp;lang=fr_FR&amp;config=arte_concert&amp;width=720&amp;height=406"></script>';break;case'ATTACHMENT':$attributes+=['index'=>null,'filename'=>null];$html.='<div class="inline-attachment"><!-- ia'.str_replace('&quot;','"',$attributes['index']??'').' -->'.str_replace('&quot;','"',$attributes['filename']??'').'<!-- ia'.str_replace('&quot;','"',$attributes['index']??'').' --></div>';break;case'ATTV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://vp.telvue.com/player?id=T03105&amp;video='.htmlspecialchars($textContent,2).'&amp;mini=true" width="400" height="300" marginwidth="0" marginheight="0" hpsace="0" vspace="0" frameborder="1" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'AUDIOMACK':$attributes+=['mode'=>null,'artist'=>null,'title'=>null];$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($attributes['mode']==='album'){$html.=' src="https://www.audiomack.com/embed/album/';if(isset($attributes['id']))$html.=($attributes['id']??'');else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$html.=' src="https://www.audiomack.com/embed/song/';if(isset($attributes['id']))$html.=($attributes['id']??'');else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:252px;max-width:900px;width:100%"';}$html.='></iframe>';break;case'AUSHA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" loading="lazy" id="'.htmlspecialchars($textContent,2).'" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId=bzPxksVdjQnD&amp;v=3&amp;playerId=ausha-WWk4"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'BANDCAMP':$attributes+=['track_num'=>null,'track_id'=>null];$html.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if(isset($attributes['album_id'])){$html.='album='.$attributes['album_id'];if(isset($attributes['track_num']))$html.='/t='.$attributes['track_num'];}else$html.='track='.$attributes['track_id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='/bgcol=333333/linkcol=0f91ff';$html.='"></iframe></span></span>';break;case'BBC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="400" height="500" frameborder="0" src="https://www.bbc.com/news/av/embed/p080qwnv/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'BBC4':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="400" height="500" frameborder="0" src="http://www.bbc.co.uk/programmes/'.htmlspecialchars($textContent,2).'/player"></iframe>';break;case'BBCNEWS':$attributes+=['playlist'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av-embeds/';if((strpos($attributes['playlist']??'','/news/')===0))if((strpos($attributes['playlist']??'','-')!==false))$html.=htmlspecialchars(substr(strstr(substr(strstr(strtr(htmlspecialchars_decode($attributes['playlist']??''),'A','#'),'news/'),5),'-'),1),2);else$html.=htmlspecialchars(substr(strstr(strtr(htmlspecialchars_decode($attributes['playlist']??''),'A','/'),'/news/'),6),2);elseif((strpos($attributes['id']??'','/')!==false))$html.=htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']??''),'/'),1),2);else$html.=($attributes['id']??'');$html.='"></iframe></span></span>';break;case'BCOVE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/45228659001/rkPdEdoaW_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFIG':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFM':$textContent=$this->getQuickTextContent($xml);$html.='<div style="display:block;position:relative"><div style="padding-top:56.25%"><iframe src="'.htmlspecialchars($textContent,2).'" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" style="width:100%;height:100%;position:absolute;top:0;bottom:0;right:0;left:0;border:none"></iframe></div></div>';break;case'BM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://donnees.banquemondiale.org/share/widget?indicators='.htmlspecialchars($textContent,2).'" width="450" height="300" frameborder="0" scrolling="no"></iframe>';break;case'BRIGHTCOVE':$attributes+=['bcpid'=>null,'bctid'=>null];$html.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if(isset($attributes['bckey']))$html.='link.brightcove.com/services/player/bcpid'.$attributes['bcpid'].'?bckey='.$attributes['bckey'].'&amp;bctid='.$attributes['bctid'].'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$html.='players.brightcove.net/'.$attributes['bcpid'].'/default_default/index.html?videoId='.$attributes['bctid'];$html.='"></iframe></span></span>';break;case'CALAMEO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//v.calameo.com/?bkcode='.htmlspecialchars($textContent,2).'" width="900" height="582" frameborder="0" scrolling="no" allowtransparency="" allowfullscreen="" style="margin:0 auto"></iframe>';break;case'CANAL':$textContent=$this->getQuickTextContent($xml);$html.='<div><iframe width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=cplus&amp;vid='.htmlspecialchars($textContent,2).'"></iframe></div>';break;case'CANAL-U':$textContent=$this->getQuickTextContent($xml);$html.='<div style="position:relative;padding-bottom:56.25%;padding-top:10px;height:0;overflow:hidden"><iframe src="https://www.canal-u.tv/video/cerimes/embed.1/'.htmlspecialchars($textContent,2).'?width=100%25&amp;height=100%25" style="position:absolute;top:0;left:0;width:100%;height:100%" width="550" height="306" frameborder="0" allowfullscreen="" scrolling="no"></iframe></div>';break;case'CBSNEWS':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($attributes['id']??'','-')!==false))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.$attributes['id'].'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif(isset($attributes['pid']))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.$attributes['pid'].'"></object>';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.$attributes['id'].'"></object>';$html.='</span></span>';break;case'CDF':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.mariamagdalenakaczor.eu/mediaplayer/player.swf" height="560" width="745" allowscriptaccess="always" allowfullscreen="true" flashvars="&amp;controlbar=over&amp;item='.htmlspecialchars($textContent,2).'&amp;playlistfile=http%3A%2F%2Fwww.mariamagdalenakaczor.eu%2Fmediapayer%2Fplaylist.xml&amp;plugins=viral-2d">';break;case'CDN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//cdn.jwplayer.com/players/'.htmlspecialchars($textContent,2).'" width="640" height="360" frameborder="0" scrolling="auto"></iframe>';break;case'CHART':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=2020-12-20..latest&amp;country=USA~DEU~GBR~FRA~ISR~ITA~ESP&amp;region=World&amp;vaccinationsMetric=true&amp;interval=total&amp;perCapita=true&amp;smoothing=0&amp;pickerMetric=total_vaccinations_per_hundred&amp;pickerSort=desc" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART3':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-12-20..latest&amp;pickerSort=asc&amp;pickerMetric=location&amp;Metric=Vaccine+doses&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTCO2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;country=FRA~DEU~NLD~POL~EU-27&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNDL':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=earliest..latest&amp;country=~NLD&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNEWDEATHS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=GBR~FRA~USA~BRA~IND~MEX~RUS~ITA&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTTOTALDEATH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~GBR~FRA~BRA~HUN" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CODE':$html.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';break;case'CULT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.franceculture.fr/player/export-reecouter?content='.htmlspecialchars($textContent,2).'" width="481" frameborder="0" scrolling="no" height="139"></iframe>';break;case'DAILYMOTION':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.$attributes['id'];if(isset($attributes['t']))$html.='?start='.$attributes['t'];$html.='"></iframe></span></span>';break;case'DATA':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-bar-chart-race" data-src="visualisation/'.htmlspecialchars($textContent,2).'" data-url="https://flo.uri.sh/visualisation/'.htmlspecialchars($textContent,2).'/embed"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'DC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DDC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Color+by+test+positivity=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DEB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="270" style="width:480px;height:270px" src="http://mediaspip.ptitdeb.infini.fr/spip.php?page=embed_code&amp;id_objet='.htmlspecialchars($textContent,2).'&amp;objet=document&amp;largeur=480&amp;hauteur=270" frameborder="0" allowfullscreen=""></iframe>';break;case'DEMOCRACYNOW':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((strpos($attributes['id']??'','/headlines')!==false))$html.='headlines/'.htmlspecialchars(strstr(htmlspecialchars_decode($attributes['id']??''),'/headlines',true),2);elseif((strpos($attributes['id']??'','2')===0))$html.='story/'.$attributes['id'];elseif((strpos($attributes['id']??'','shows/')===0))$html.='show/'.htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']??''),'/'),1),2);else$html.=($attributes['id']??'');$html.='"></iframe></span></span>';break;case'DH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/weekly-hospital-admissions-covid?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DMOTION':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="480" height="270" src="https://www.dailymotion.com/embed/video/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'DOCGOOGLE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://docs.google.com/file/d/'.htmlspecialchars($textContent,2).'/preview" width="640" height="480"></iframe>';break;case'DOCPLAYER':$textContent=$this->getQuickTextContent($xml);$html.='<div><div><a target="_blank" href="'.htmlspecialchars($textContent,2).'" rel="noreferrer"></a></div><div><iframe frameborder="0" style="border-bottom:2px solid #eee;border-top:0" scrolling="no" src="http://docplayer.fr/docview/112/202650701/" width="728" height="1040" allowfullscreen=""></iframe></div></div>';break;case'DR':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/current-covid-patients-icu?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DUMPERT':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.strtr($attributes['id']??'','/','_').'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ECHOS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01578907/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="480" height="400" allow="autoplay; fullscreen"></iframe>';break;case'ED':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/excess-deaths-cumulative-economist-who?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EDV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/life-expectancy?tab=chart&amp;time=earliest..2019&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EMAIL':$attributes+=['email'=>null,'body'=>null];$html.='<a href="mailto:'.$attributes['email'];if(isset($attributes['subject'])||isset($attributes['body'])){$html.='?';if(isset($attributes['subject']))$html.='subject='.$attributes['subject'];if(isset($attributes['body'])){if(isset($attributes['subject']))$html.='&amp;';$html.='body='.$attributes['body'];}}$html.='">';break;case'EMOJI':$attributes+=['seq'=>null];$textContent=$this->getQuickTextContent($xml);if($this->params['S_VIEWSMILIES']!==''){$html.='<img alt="'.htmlspecialchars($textContent,2).'" class="emoji smilies" draggable="false" src="';if(isset($attributes['tseq']))$html.='//twemoji.maxcdn.com/2/svg/'.$attributes['tseq'].'.svg';else$html.='https://cdn.jsdelivr.net/gh/s9e/emoji-assets-twemoji@11.2/dist/svgz/'.$attributes['seq'].'.svgz';$html.='">';}else$html.=htmlspecialchars($textContent,0);break;case'EUR1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.europe1.fr/videos/embed/'.htmlspecialchars($textContent,2).'" width="734px" height="406px"></iframe>';break;case'EUROSTAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="964" height="462" src="https://ec.europa.eu/eurostat/statistics-explained/index.php?'.htmlspecialchars($textContent,2).'" scrolling="no" frameborder="0"></iframe>';break;case'EXPLORER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER3':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~European+Union&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'FACEBOOK':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.$attributes['type'].$attributes['id'].'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href='.htmlspecialchars($textContent,2).'&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FBBRUT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href=https%3A%2F%2Fwww.facebook.com%2Fbrutofficiel%2Fvideos%2F'.htmlspecialchars($textContent,2).'%2F&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FIG':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;autoplay=true" allowfullscreen="" width="640" height="360"></iframe>';break;case'FLO':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-table" data-src="'.htmlspecialchars($textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLOURISH':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-chart" data-src="visualisation/'.htmlspecialchars($textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.francemusique.fr/player/export-reecouter?content='.htmlspecialchars($textContent,2).'" width="481" frameborder="0" scrolling="no" height="137"></iframe>';break;case'FRANCEINFO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe><br>';break;case'FREEMP3':$textContent=$this->getQuickTextContent($xml);$html.='<table><tr><td><a href="http://www.freemp3go.org/track.php?id='.htmlspecialchars($textContent,2).'="></a></td></tr><tr><td><script type="text/javascript" src="http://jwpsrv.com/library/lNwD_IqdEeKinyIACp8kUw.js"></script><div id="playAround_wrapper">Loading the player...</div><script type="text/javascript">/**/jwplayer.key=&quot;7VoWoDgr0Gmogb5TdwF7v2lsIYKG8SZUo1ztUg==&quot;;jwplayer(&quot;playAround_wrapper&quot;).setup({&quot;width&quot;:340,&quot;height&quot;:26,&quot;autostart&quot;:true,&quot;playlist&quot;:[{&quot;image&quot;:&quot;http:\\/\\/www.freemp3go.org\\/images\\/logo.jpg&quot;,&quot;sources&quot;:[{&quot;type&quot;:&quot;flv&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=flv&quot;,&quot;default&quot;:true},{&quot;type&quot;:&quot;mp4&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=mp4&quot;}]}]});/**/</script></td></tr><tr></tr></table>';break;case'FTV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'GBOOK':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" scrolling="no" style="border:0" src="https://books.google.fr/books?id='.htmlspecialchars($textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;output=embed" width="500" height="500"></iframe>';break;case'GBOOK155':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" scrolling="no" style="border:0" src="http://books.google.fr/books?id='.htmlspecialchars($textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;pg=PA155&amp;output=embed" width="500" height="500"></iframe>';break;case'GEND':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://players.brightcove.net/610043537001/B1c7CqZH_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'GETTY':$attributes+=['width'=>null,'height'=>null,'id'=>null,'et'=>null,'sig'=>null];$html.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.$attributes['id'].'?et='.$attributes['et'].'&amp;tld=com&amp;sig='.$attributes['sig'].'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$attributes+=['width'=>null,'height'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*($attributes['height']+44)/htmlspecialchars_decode($attributes['width']??''),2).'%;padding-bottom:calc('.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'% + 44px)';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gfycat.com/ifr/'.$attributes['id'].'?hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$attributes+=['width'=>null,'height'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://giphy.com/embed/'.htmlspecialchars($textContent,2).'" width="480" height="384" frameborder="0" class="giphy-embed" allowfullscreen=""></iframe><p><a href="https://giphy.com/gifs/harvardmed-LmCsBMgBeXBY4yUWWq">via GIPHY</a></p>';break;case'GOOGLEPLUS':$attributes+=['name'=>null,'pid'=>null];$html.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if(isset($attributes['oid']))$html.=($attributes['oid']??'');else$html.='+'.$attributes['name'];$html.='/posts/'.$attributes['pid'].'"></iframe>';break;case'GOOGLESHEETS':$attributes+=['type'=>null,'id'=>null,'oid'=>null,'gid'=>null];if($attributes['type']==='chart')$html.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/pubchart?oid='.$attributes['oid'].'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$html.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/p';if((strpos($attributes['id']??'','e/')===0))$html.='ubhtml?widget=true&amp;headers=false';else$html.='review';$html.='#gid='.$attributes['gid'].'"></iframe>';}break;case'GRAPH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="45%" height="500" src="'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no"></iframe>';break;case'HUDL':$attributes+=['athlete'=>null,'highlight'=>null];$html.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if(isset($attributes['id']))$html.='video/'.$attributes['id'];else$html.='athlete/'.$attributes['athlete'].'/highlights/'.$attributes['highlight'];$html.='"></iframe></span></span>';break;case'IFRAP':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($textContent,2).'" width="670" height="715" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px 1px 0;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'IMGUR':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){var d=e.data.split(\' \');style.height=d[0]+\'px\';style.width=d[1]+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($attributes['type']==='album')$html.='a/';$html.=$attributes['id'].'"></iframe>';break;case'INA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="620" height="349" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="http://player.ina.fr/player/embed/'.htmlspecialchars($textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/620/349/0/148db8"></iframe>';break;case'INA1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="100%" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://player.ina.fr/player/embed/'.htmlspecialchars($textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/wide/1" allow="fullscreen,autoplay"></iframe>';break;case'INA2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://fresques.ina.fr/de-gaulle/export/player/'.htmlspecialchars($textContent,2).'/wide?isAmalia=1" width="620" height="465" allowfullscreen=""></iframe>';break;case'INTER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.franceinter.fr/embed/player/aod/'.htmlspecialchars($textContent,2).'" width="100%" height="64" frameborder="0" scrolling="no"></iframe>';break;case'INTERNETARCHIVE':$attributes+=['id'=>null,'width'=>null,'height'=>null];if((strpos($attributes['id']??'','playlist=1')!==false))$html.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$html.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'IRSEM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="300" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($textContent,2).'&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe>';break;case'IRSN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="240" height="210" title="" src="https://barometre.irsn.fr/'.htmlspecialchars($textContent,2).'/" type="text/html" allowfullscreen="true" scrolling="no" marginwidth="0" marginheight="0"></iframe>';break;case'ITELE':$textContent=$this->getQuickTextContent($xml);$html.='<div><iframe webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen="" width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=itele_vod&amp;vid='.htmlspecialchars($textContent,2).'"></iframe></div>';break;case'KICKSTARTER':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="kickstarter"';if(isset($attributes['video']))$html.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$html.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'KNOEMA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://knoema.fr/atlas/embed/topics/'.htmlspecialchars($textContent,2).'?type=maps" allowtransparency="true" frameborder="0" width="920" min-width="560" height="700" scrolling="no"></iframe>';break;case'LB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/'.htmlspecialchars($textContent,2).'/src/qx5kszf/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="620" height="349" allow="autoplay; fullscreen"></iframe>';break;case'LC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/low-carbon-share-energy?tab=chart&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'LESOIR':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01613302/src/'.htmlspecialchars($textContent,2).'/zone/34/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="646" height="363" allow="autoplay; fullscreen"></iframe>';break;case'LINKEDIN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:'.htmlspecialchars($textContent,2).'" height="541" width="504" frameborder="0" allowfullscreen="" title="Post intégré"></iframe>';break;case'LINK_TEXT':$attributes+=['text'=>null];$html.=str_replace('&quot;','"',$attributes['text']??'');break;case'LIST':$attributes+=['type'=>null];if(!isset($attributes['type']))$html.='<ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']??''),0,5,'utf-8'))!==false))$html.='<ol style="list-style-type:'.$attributes['type'].'">';else$html.='<ul style="list-style-type:'.$attributes['type'].'">';$this->attributes[]=$attributes;break;case'LIVESTREAM':$attributes+=['channel'=>null,'account_id'=>null,'event_id'=>null];$html.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if(isset($attributes['clip_id']))$html.='cdn.livestream.com/embed/'.$attributes['channel'].'?layout=4&amp;autoplay=false&amp;clip='.$attributes['clip_id'];else{$html.='livestream.com/accounts/'.$attributes['account_id'].'/events/'.$attributes['event_id'];if(isset($attributes['video_id']))$html.='/videos/'.$attributes['video_id'];$html.='/player?autoPlay=false';}$html.='"></iframe></span></span>';break;case'LUMNI':$textContent=$this->getQuickTextContent($xml);$html.='<iframe allow="autoplay" title="" src="https://enseignants.lumni.fr/export/player/'.htmlspecialchars($textContent,2).'" width="100%" height="100%" allowfullscreen=""></iframe>';break;case'MAP':$textContent=$this->getQuickTextContent($xml);$html.='<div class="cpi-node" data-embed="map"></div><script src="'.htmlspecialchars($textContent,2).'"></script>';break;case'MSNBC':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($attributes['id']??'','_')!==false))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$html.=$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$html.='</span></span>';break;case'NFR':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.npr.org/v2/?i='.htmlspecialchars($textContent,2).'&amp;m=259646821&amp;t=audio" height="386" wmode="opaque" allowfullscreen="true" width="400" base="http://www.npr.org" type="application/x-shockwave-flash">';break;case'NHL':$html.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if(isset($attributes['t']))$html.='/t-'.$attributes['t'];if(isset($attributes['c']))$html.='/c-'.$attributes['c'];$html.='?autostart=false"></iframe></span></span>';break;case'NYT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="373" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" id="nyt_video_player" title="New York Times Video - Embed Player" src="http://graphics8.nytimes.com/bcvideo/1.0/iframe/embed.html?videoId='.htmlspecialchars($textContent,2).'&amp;playerType=embed"></iframe>';break;case'OCDE':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.pearsonfoundation.org/media/player-licensed.swf" width="640" height="376" allowscriptaccess="always" allowfullscreen="false" flashvars="file=http://www.pearsonfoundation.org/oecd/media/'.htmlspecialchars($textContent,2).'.mp4&amp;skin=http://www.pearsonfoundation.org/media/pf.swf">';break;case'ODYSEE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe id="lbry-iframe" width="560" height="315" src="https://odysee.com/$/embed/'.htmlspecialchars($textContent,2).'" allowfullscreen=""></iframe>';break;case'OF':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01124706/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="640" height="360"></iframe>';break;case'OOYALA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="640" height="480" frameborder="0" allowfullscreen="" src="//player.ooyala.com/static/v4/candidate/latest/skin-plugin/iframe.html?'.htmlspecialchars($textContent,2).'"></iframe>';break;case'ORFIUM':$attributes+=['track_id'=>null];$html.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if(isset($attributes['album_id']))$html.='album/'.$attributes['album_id'];elseif(isset($attributes['playlist_id']))$html.='playlist/'.$attributes['playlist_id'];elseif(isset($attributes['set_id']))$html.='live-set/'.$attributes['set_id'];else$html.='track/'.$attributes['track_id'];$html.='" style="border:0;height:';if(isset($attributes['album_id']))$html.='550';else$html.='275';$html.='px;max-width:900px;width:100%"></iframe>';break;case'OWID':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'PINTEREST':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.$attributes['id'].'" style="border:0;height:360px;max-width:';if((strpos($attributes['id']??'','/')!==false))$html.='730';else$html.='345';$html.='px;width:100%"></iframe>';break;case'POLLSTER':$textContent=$this->getQuickTextContent($xml);$html.='<script src="http://elections.huffingtonpost.com/pollster/'.htmlspecialchars($textContent,2).'/embed.js"></script>';break;case'QUOTE':$attributes+=['url'=>null,'author'=>null,'post_id'=>null,'msg_id'=>null];$html.='<blockquote';if(isset($attributes['post_url']))$html.=' cite="'.$attributes['post_url'].'"';if(!isset($attributes['author']))$html.=' class="uncited"';$html.='><div>';if(isset($attributes['author'])){$html.='<cite>';if(isset($attributes['url']))$html.='<a href="'.$attributes['url'].'" class="postlink">'.str_replace('&quot;','"',$attributes['author']??'').'</a>';elseif(isset($attributes['profile_url']))$html.='<a href="'.$attributes['profile_url'].'">'.str_replace('&quot;','"',$attributes['author']??'').'</a>';else$html.=str_replace('&quot;','"',$attributes['author']??'');$html.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if(isset($attributes['post_url']))$html.=' <a href="'.$attributes['post_url'].'" data-post-id="'.$attributes['post_id'].'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if(isset($attributes['msg_url']))$html.=' <a href="'.$attributes['msg_url'].'" data-msg-id="'.$attributes['msg_id'].'">↑</a>';if(isset($attributes['date']))$html.='<span class="responsive-hide">'.str_replace('&quot;','"',$attributes['date']??'').'</span>';$html.='</cite>';}break;case'REDDIT':$attributes+=['id'=>null,'path'=>null];$html.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.$attributes['id'].$attributes['path'].'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'REPORTERRE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" loading="lazy" id="ausha-r1JH" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId='.htmlspecialchars($textContent,2).'&amp;v=3&amp;playerId=ausha-r1JH"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'RTE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://eco2mix.rte-france.com/pluginWeb/data?key='.htmlspecialchars($textContent,2).'" width="350" height="370"></iframe>';break;case'RTL':case'RTLBE':$textContent=$this->getQuickTextContent($xml);$html.='<div style="width:600px;height:338px"><script async="async" type="text/javascript" src="//www.rtl.be/videos/player/vp_embed.js" videoid="'.htmlspecialchars($textContent,2).'"></script></div>';break;case'RTS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="560" height="315" src="https://www.rts.ch/play/embed?urn=urn:rts:video:'.htmlspecialchars($textContent,2).'&amp;subdivisions=false" allowfullscreen="" allow="geolocation *; autoplay; encrypted-media"></iframe>';break;case'RUTUBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="720" height="405" src="//rutube.ru/video/embed/'.htmlspecialchars($textContent,2).'" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'SAPIENS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="450" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/859584016&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe><div style="font-size:10px;color:#ccc;line-break:anywhere;word-break:normal;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight:100"><a href="https://soundcloud.com/user-702632852" title="Institut Sapiens" target="_blank" style="color:#ccc;text-decoration:none" rel="noreferrer">Institut Sapiens</a> · <a href="https://soundcloud.com/user-702632852/'.htmlspecialchars($textContent,2).'"></a></div>';break;case'SCRIB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe class="scribd_iframe_embed" src="https://www.scribd.com/embeds/'.htmlspecialchars($textContent,2).'/content?start_page=1&amp;view_mode=scroll&amp;access_key=key-2imc0qq0kxk41ryg1wrd&amp;show_recommendations=false" data-auto-height="false" data-aspect-ratio="0.7729220222793488" scrolling="no" id="doc_25852" width="600" height="800" frameborder="0"></iframe>';break;case'SENAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'" width="640" height="430" frameborder="0" allowfullscreen="true" scrolling="no"></iframe>';break;case'SLIDE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.slideshare.net/slideshow/embed_code/key/'.htmlspecialchars($textContent,2).'" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'SOUNDCLOUD':case'UNO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($textContent,2).'&amp;color=ff5500"></iframe>';break;case'SPOTIFY':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://open.spotify.com/embed/show/'.htmlspecialchars($textContent,2).'" width="100%" height="232" frameborder="0" allowtransparency="true" allow="encrypted-media"></iframe>';break;case'STATIC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'" width="480" height="270" frameborder="0" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'TED':case'TED2':case'TED3':$textContent=$this->getQuickTextContent($xml);$html.='<div style="max-width:854px"><div style="position:relative;height:0;padding-bottom:56.25%"><iframe src="https://embed.ted.com/talks/lang/fr/'.htmlspecialchars($textContent,2).'" width="854" height="480" style="position:absolute;left:0;top:0;width:100%;height:100%" frameborder="0" scrolling="no" allowfullscreen=""></iframe></div></div>';break;case'TELEGRAMME':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.letelegramme.fr/static/ftp/dossier/data/dataviz/iframe/iframe.php?id='.htmlspecialchars($textContent,2).'" width="100%" height="400&quot;" style="max-width:100%" frameborder="0"></iframe>';break;case'TF1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.tf1.fr/embedframe/'.htmlspecialchars($textContent,2).'" frameborder="0" style="width:640px;height:360px"></iframe>';break;case'TLG':$textContent=$this->getQuickTextContent($xml);$html.='<script async="" src="https://telegram.org/js/telegram-widget.js?19" data-telegram-post="'.htmlspecialchars($textContent,2).'" data-width="100%"></script>';break;case'TWENTYFOURSEVENSPORTS':$attributes+=['player_id'=>null];if(isset($attributes['video_id']))$html.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.$attributes['video_id'].'%26channel%3Dmobilevideo%26pcid%3D'.$attributes['video_id'].'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$html.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.$attributes['player_id'].'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITTER':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars(htmlspecialchars_decode($attributes['id']??'').$this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:250px;max-width:550px;width:100%"></iframe>';break;case'ULTI':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01946947/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="470" height="300" allow="autoplay; fullscreen"></iframe>';break;case'UNIGE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url=https://mediaserver.unige.ch/media/'.htmlspecialchars($textContent,2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'UNIV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe class="player" frameborder="0" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="'.htmlspecialchars($textContent,2).'" width="576" height="324"> </iframe>';break;case'USTREAM':$attributes+=['cid'=>null];$html.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if(isset($attributes['vid']))$html.='recorded/'.$attributes['vid'];else$html.=($attributes['cid']??'');$html.='?html5ui"></iframe></span></span>';break;case'VIDEOFIG':$textContent=$this->getQuickTextContent($xml);$html.='<object id="flashObj" width="800" height="450" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=4500912462001&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId='.htmlspecialchars($textContent,2).'&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="800" height="450" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'VIMEO':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.$attributes['id'];if(isset($attributes['t']))$html.='#t='.$attributes['t'];$html.='"></iframe></span></span>';break;case'VMO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//player.vimeo.com/video/'.htmlspecialchars($textContent,2).'" width="640" height="470" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'VOCAROO':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="vocaroo"';if((strpos($attributes['id']??'','s0')===0)||(strpos($attributes['id']??'','s1')===0))$html.=' style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID='.$attributes['id'].'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span>';else$html.=' style="display:inline-block;width:100%;max-width:300px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:20%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'WAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.wat.tv/embedframe/'.htmlspecialchars($textContent,2).'" frameborder="0" style="width:620px;height:350px"></iframe>';break;case'WID':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=latest&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'WPVIDEO':$textContent=$this->getQuickTextContent($xml);$html.='<embed type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" width="400" height="224" wmode="direct" seamlesstabbing="true" allowfullscreen="true" allowscriptaccess="always" overstretch="true" flashvars="guid='.htmlspecialchars($textContent,2).'&amp;isDynamicSeeking=true">';break;case'WSJ':$textContent=$this->getQuickTextContent($xml);$html.='<iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" width="512" height="288" src="https://video-api.wsj.com/api-video/player/v3/iframe.html?guid='.htmlspecialchars($textContent,2).'"></iframe>';break;case'YOUSCRIBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.youscribe.com/BookReader/IframeEmbed?productId='.htmlspecialchars($textContent,2).'&amp;token=&amp;width=620&amp;height=917&amp;startPage=1&amp;displayMode=scroll&amp;fullscreen=0" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" frameborder="0" scrolling="no" width="620px" height="917px" marginwidth="0" marginheight="0" style="border:1px solid #44444a;width:620px;height:917px;margin:0;padding:0"></iframe>';break;case'YOUTUBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="360" src="//www.youtube.com/embed/'.htmlspecialchars($textContent,2).'" frameborder="0" allowfullscreen=""></iframe>';break;case'ZAD1':$textContent=$this->getQuickTextContent($xml);$html.='<object id="flashObj" width="480" height="270" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID=1321210711001&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID='.htmlspecialchars($textContent,2).'&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="480" height="270" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';}

		return $html;
	}
}