<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2021 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function aa(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var d=[""],e=[256],f=["","t"],p=["","id"],ba=["","vid"],r=["","type"],t=["","width"],u={flags:3089},v=["","height"],ca=["","show_id"],w=["","track_id"],da=["","album_id"],ea=[[/(?:)/,d]],fa=["","video_id"],ha=["","user","id"],ia=["","type","id"],ja=["","id","type"],ka=["","name","id"],la=["","fid","eid"],ma=["","episode_id"],na=["","user","slug"],oa=["","playlist_id"],pa=/"id"\\s*:\\s*"(\\w+)"/,qa=["","oid","vid","hash"],ra=["","channel","clip_id"],sa=["","athlete","highlight"],ta=["","account_id","event_id"],
z={d:[],s:!1},B={d:[],s:!0},ua=["","show_id","episode_id","t"],va=[[/globalnews\\.ca\\/video\\/(\\d+)/,p]],wa=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,p],xa=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,p],ya=[[/([-\\w]+)\\.castos\\.com\\/player\\/(\\d+)/,["","host","id"]]],za=[[/247sports\\.com\\/PlayerSport\\/[-\\w]*(\\d+)\\/Embed/,["","player_id"]]],Aa=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,sa],Ba=[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|i18n\\/share\\/video)\\/(\\d+)/,p]],Ca=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,
p]],Da=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],E=[function(a,b){var c={},g;for(g in b.b){var n=b.b[g],h=!1;if(g in a.b){h=n.d;var l=g,q=a.b[g];C.l=l;for(var k=0;k<h.length&&(q=h[k](q,l),!1!==q);++k);delete C.l;h=q}!1!==h?c[g]=h:"undefined"!==typeof n.y?c[g]=n.y:n.s&&D(a)}Ea(a,c)}],Fa={d:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],s:!1},Ga={y:360,d:Da,s:!1},Ha={y:640,d:Da,s:!1},
F={e:e,b:{id:z},j:1,d:E,f:10,k:u,g:5E3},Ia={e:e,b:{id:z,user:z},j:1,d:E,f:10,k:u,g:5E3},Ja={e:e,b:{height:Ga,id:z,width:Ha},j:1,d:E,f:10,k:u,g:5E3},Ka=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$uAMAZON_ASSOCIATE_TAG"/><xsl:param$uAMAZON_ASSOCIATE_TAG_CA"/><xsl:param$uAMAZON_ASSOCIATE_TAG_DE"/><xsl:param$uAMAZON_ASSOCIATE_TAG_ES"/><xsl:param$uAMAZON_ASSOCIATE_TAG_FR"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IN"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IT"/><xsl:param$uAMAZON_ASSOCIATE_TAG_JP"/><xsl:param$uAMAZON_ASSOCIATE_TAG_UK"/><xsl:param$uMEDIAEMBED_THEME"/>$eABCNEWS"><$r$dabcnews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//abcnews.go.com/video/embed?id={@id}"$h$b/></$r></$r>$i$eACAST"><$n$dacast"$f"$l$p$kno"$ohttps://embed.acast.com/{@show_id}/{@episode_id}?seek={@t}"$hborder:0;height:188px;max-width:900px;width:100%"/>$i$eAMAZON"><$r$damazon"$h$c120px"><$r$h$a200%"><$n$f"$l$p$kno"$hbackground:url(https://www.amazon.com/favicon.ico) center no-repeat;$b><$m$usrc">//ws-<$w><$v$s@tld=\\\'jp\\\'">fe</$v><$v$s@tld and contains(\\\'desfrinituk\\\',@tld)">eu</$v><$q>na</$q></$w>.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=<$w><$v$s@tld=\\\'ca\\\'">15&amp;t=$g$AMAZON_ASSOCIATE_TAG_CA"/></$v><$v$s@tld=\\\'de\\\'">3&amp;t=$g$AMAZON_ASSOCIATE_TAG_DE"/></$v><$v$s@tld=\\\'es\\\'">30&amp;t=$g$AMAZON_ASSOCIATE_TAG_ES"/></$v><$v$s@tld=\\\'fr\\\'">8&amp;t=$g$AMAZON_ASSOCIATE_TAG_FR"/></$v><$v$s@tld=\\\'in\\\'">31&amp;t=$g$AMAZON_ASSOCIATE_TAG_IN"/></$v><$v$s@tld=\\\'it\\\'">29&amp;t=$g$AMAZON_ASSOCIATE_TAG_IT"/></$v><$v$s@tld=\\\'jp\\\'">9&amp;t=$g$AMAZON_ASSOCIATE_TAG_JP"/></$v><$v$s@tld=\\\'uk\\\'">2&amp;t=$g$AMAZON_ASSOCIATE_TAG_UK"/></$v><$q>1&amp;t=$g$AMAZON_ASSOCIATE_TAG"/></$q></$w>&amp;asins=$g@id"/></$m></$n></$r></$r>$i$eANCHOR"><$n$danchor"$f"$l$p$kno"$o//anchor.fm/x/embed/episodes/x-{@id}"$hborder:0;height:102px;max-width:768px;width:100%"/>$i$eAPPLEPODCASTS"><$n$dapplepodcasts" allow="autoplay *;encrypted-media *"$f"$l$p$kno"><$w><$v$s@episode_id"><$m$usrc">https://embed.podcasts.apple.com/$g@country"/>/podcast/episode/id$g@podcast_id"/>?theme=$g$MEDIAEMBED_THEME"/>&amp;i=$g@episode_id"/></$m><$m$u$x>border:0;height:175px;max-width:900px;width:100%</$m></$v><$q><$m$usrc">https://embed.podcasts.apple.com/$g@country"/>/podcast/episode/id$g@podcast_id"/>?theme=$g$MEDIAEMBED_THEME"/></$m><$m$u$x>border:0;height:450px;max-width:900px;width:100%</$m></$q></$w></$n>$i$eAUDIOBOOM"><$n$daudioboom"$f"$l$p$kno"$o//audioboom.com/posts/{@id}/embed/v3"$hborder:0;height:150px;max-width:700px;width:100%"/>$i$eAUDIOMACK"><$n$daudiomack"$f"$l$p$kno"><$w><$v$s@mode=\\\'album\\\'"><$m$usrc">https://www.audiomack.com/embed/album/<$w><$v$s@id">$g@id"/></$v><$q>$g@artist"/>/$g@title"/></$q></$w></$m><$m$u$x>border:0;height:400px;max-width:900px;width:100%</$m></$v><$q><$m$usrc">https://www.audiomack.com/embed/song/<$w><$v$s@id">$g@id"/></$v><$q>$g@artist"/>/$g@title"/></$q></$w></$m><$m$u$x>border:0;height:252px;max-width:900px;width:100%</$m></$q></$w></$n>$i$eAUDIUS"><$n$daudius"$f"$l$p$kno"><$m$usrc">https://audius.co/embed/<$w><$v$s@track_id">track/$g@track_id"/>?flavor=compact</$v><$v$s@album_id">album/$g@album_id"/>?flavor=card</$v><$q>playlist/$g@playlist_id"/>?flavor=card</$q></$w></$m><$m$u$x>border:0;height:<$w><$v$s@track_id">12</$v><$q>48</$q></$w>0px;max-width:<$w><$v$s@track_id">9</$v><$q>4</$q></$w>00px;width:100%</$m></$n>$i$eBANDCAMP"><$r$dbandcamp"$h$c400px"><$r$h$a100%"><$n$f"$l$p$kno"$h$b><$m$usrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$w><$v$s@album_id">album=$g@album_id"/><xsl:if$s@track_num">/t=$g@track_num"/></xsl:if></$v><$q>track=$g@track_id"/></$q></$w><xsl:if$s$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</xsl:if></$m></$n></$r></$r>$i$eBBCNEWS"><$r$dbbcnews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//www.bbc.com/news/av-embeds/<$w><$v$sstarts-with(@playlist,\\\'/news/\\\')"><$w><$v$scontains(@playlist,\\\'-\\\')">$gsubstring-after(substring-after(translate(@playlist,\\\'A\\\',\\\'#\\\'),\\\'news/\\\'),\\\'-\\\')"/></$v><$q>$gsubstring-after(translate(@playlist,\\\'A\\\',\\\'/\\\'),\\\'/news/\\\')"/></$q></$w></$v><$v$scontains(@id,\\\'/\\\')">$gsubstring-after(@id,\\\'/\\\')"/></$v><$q>$g@id"/></$q></$w></$m></$n></$r></$r>$i$eBITCHUTE"><$r$dbitchute"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://www.bitchute.com/embed/{@id}/"$h$b/></$r></$r>$i$eBLEACHERREPORT"><$r$dbleacherreport"$h$c320px"><$r$h$a100%"><$n$f"$l$p$kno"$o//bleacherreport.com/video_embed?id={@id}&amp;library=video-cms"$h$b/></$r></$r>$i$eBRIGHTCOVE"><$r$dbrightcove"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">https://<$w><$v$s@bckey">link.brightcove.com/services/player/bcpid$g@bcpid"/>?bckey=$g@bckey"/>&amp;bctid=$g@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$v><$q>players.brightcove.net/$g@bcpid"/>/default_default/index.html?videoId=$g@bctid"/></$q></$w></$m></$n></$r></$r>$i$eCASTOS"><$n$dcastos"$f"$l$p$kno"$ohttps://player.castos.com/player/{@id}"$h$y/>$i$eCBSNEWS"><$r$dcbsnews"$h$c640px"><$r><$w><$v$scontains(@id,\\\'-\\\')"><$m$u$x>$a56.25%</$m><$n$f"$l$p$kno"$ohttps://www.cbsnews.com/embed/videos/{@id}/"$h$b/></$v><$v$s@pid"><$m$u$x>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$m><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$h$z type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/><param$uflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$v><$q><$m$u$x>$a62.5%;padding-bottom:calc(56.25% + 40px)</$m><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$h$z type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/><param$uflashvars" value="si=254&amp;contentValue={@id}"/></object></$q></$w></$r></$r>$i$eCLYP"><$n$dclyp"$f"$l$p$kno"$ohttps://clyp.it/{@id}/widget"$hborder:0;height:265px;max-width:900px;width:100%"/>$i$eCNBC"><$r$dcnbc"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$h$b/></$r></$r>$i$eCNN"><$r$dcnn"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$h$b/></$r></$r>$i$eCNNMONEY"><$r$dcnnmoney"$h$c560px"><$r$h$a64.285714%"><$n$f"$l$p$kno"$o//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$h$b/></$r></$r>$i$eCODEPEN"><$n$dcodepen"$f"$l$p$kno"$ohttps://codepen.io/{@user}/embed/{@id}?height=400&amp;default-tab=html,result"$hborder:0;height:400px;width:100%"/>$i$eCOMEDYCENTRAL"><$r$dcomedycentral"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//media.mtvnservices.com/embed/{@id}"$h$b/></$r></$r>$i$eCOUB"><$r$dcoub"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//coub.com/embed/{@id}"$h$b/></$r></$r>$i$eDAILYMOTION"><$r$ddailymotion"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//www.dailymotion.com/embed/video/$g@id"/><xsl:if$s@t">?start=$g@t"/></xsl:if></$m></$n></$r></$r>$i$eDEMOCRACYNOW"><$r$ddemocracynow"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//www.democracynow.org/embed/<$w><$v$scontains(@id,\\\'/headlines\\\')">headlines/$gsubstring-before(@id,\\\'/headlines\\\')"/></$v><$v$sstarts-with(@id,\\\'2\\\')">story/$g@id"/></$v><$v$sstarts-with(@id,\\\'shows/\\\')">show/$gsubstring-after(@id,\\\'/\\\')"/></$v><$q>$g@id"/></$q></$w></$m></$n></$r></$r>$i$eDUMPERT"><$r$ddumpert"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.dumpert.nl/embed/{translate(@id,\\\'/\\\',\\\'_\\\')}"$h$b/></$r></$r>$i$eEIGHTTRACKS"><$r$deighttracks"$h$c400px"><$r$h$a100%"><$n$f"$l$p$kno"$o//8tracks.com/mixes/{@id}/player_v3_universal"$h$b/></$r></$r>$i$eESPN"><$r$despn"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.espn.com/core/video/$n?id={@id}"$h$b/></$r></$r>$i$eFACEBOOK"><$n$dfacebook"$f"$t$x$l$p onload="$j$kno"$ohttps://s9e.github.io/$n/2/facebook.min.html#{@type}{@id}"$hborder:0;height:360px;max-width:640px;width:100%"/>$i$eFALSTAD"><$n$dfalstad"$f"$l$p$kno"$hborder:0;height:500px;max-height:90vh;width:100%"><$m$usrc">https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c<$w><$v$s@cct">ct=$g@cct"/></$v><$q>tz=$g@ctz"/></$q></$w></$m></$n>$i$eFLICKR"><$r$dflickr"$h$c500px"><$r$h$a100%"><$n$f"$l$p$kno"$ohttps://www.flickr.com/photos/_/{@id}/player/"$h$b/></$r></$r>$i$eFOXNEWS"><$r$dfoxnews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//video.foxnews.com/v/video-embed.html?video_id={@id}"$h$b/></$r></$r>$i$eFUNNYORDIE"><$r$dfunnyordie"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.funnyordie.com/embed/{@id}"$h$b/></$r></$r>$i$eGAMESPOT"><$r$dgamespot"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.gamespot.com/videos/embed/{@id}/"$h$b/></$r></$r>$i$eGETTY"><$r$dgetty"$h$c{@width}px"><$r><$m$u$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</xsl:if></$m><$n$f"$l$p$kno"$o//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$h$b/></$r></$r>$i$eGFYCAT"><$r$dgfycat"$h$c{@width}px"><$r><$m$u$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$g100*(@height+44)div@width"/>%;padding-bottom:calc($g100*@height div@width"/>% + 44px)</xsl:if></$m><$n$f"$l$p$kno"$o//gfycat.com/ifr/{@id}?hd=1"$h$b/></$r></$r>$i$eGIFS"><$r$dgifs"$h$c{@width}px"><$r><$m$u$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</xsl:if></$m><$n$f"$l$p$kno"$o//gifs.com/embed/{@id}"$h$b/></$r></$r>$i$eGIPHY"><$r$dgiphy"$h$c{@width}px"><$r><$m$u$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</xsl:if></$m><$n$f"$l$p$kno"$h$b><$m$usrc">//giphy.com/embed/$g@id"/><xsl:if$s@type=\\\'video\\\'">/video</xsl:if></$m></$n></$r></$r>$i$eGIST"><$n$dgist"$f"$t$x$l$p onload="$j$k"$ohttps://s9e.github.io/$n/2/gist.min.html#{@id}"$hborder:0;height:180px;width:100%"/>$i$eGLOBALNEWS"><$r$dglobalnews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//globalnews.ca/video/embed/{@id}/"$h$b/></$r></$r>$i$eGOFUNDME"><$r$dgofundme"$h$c349px"><$r$h$a118.911175%;padding-bottom:calc(59.312321% + 208px)"><$n$f"$l$p$kno"$o//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$h$b/></$r></$r>$i$eGOOGLEDRIVE"><$r$dgoogledrive"$h$c640px"><$r$h$a75%"><$n$f"$l$p$kno"$o//drive.google.com/file/d/{@id}/preview"$h$b/></$r></$r>$i$eGOOGLEPLUS"><$n$dgoogleplus"$f"$t$x$l$p onload="$j$kno"$hborder:0;height:240px;max-width:450px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/googleplus.min.html#<$w><$v$s@oid">$g@oid"/></$v><$q>+$g@name"/></$q></$w>/posts/$g@pid"/></$m></$n>$i$eGOOGLESHEETS"><$w><$v$s@type=\\\'chart\\\'"><$r$dgooglesheets"$h$c600px"><$r$h$a62%"><$n$f"$l$p$kno"$ohttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$h$b/></$r></$r></$v><$q><$n$dgooglesheets"$f"$l$p$kno"$hborder:0;height:500px;resize:vertical;width:100%"><$m$usrc">https://docs.google.com/spreadsheets/d/$g@id"/>/p<$w><$v$sstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$v><$q>review</$q></$w>#gid=$g@gid"/></$m></$n></$q></$w>$i$eHUDL"><$r$dhudl"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//www.hudl.com/embed/<$w><$v$s@id">video/$g@id"/></$v><$q>athlete/$g@athlete"/>/highlights/$g@highlight"/></$q></$w></$m></$n></$r></$r>$i$eHULU"><$r$dhulu"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://secure.hulu.com/embed/{@id}"$h$b/></$r></$r>$i$eIGN"><$r$dign"$h$c468px"><$r$h$a56.196581%"><$n$f"$l$p$kno"$o//widgets.ign.com/video/embed/content.html?url={@id}"$h$b/></$r></$r>$i$eIMDB"><$r$dimdb"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&amp;width=640"$h$b/></$r></$r>$i$eIMGUR"><$n$dimgur"$f"$t$x$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{var d=e.data.split(\\\' \\\');style.height=d[0]+\\\'px\\\';style.width=d[1]+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$kno"$hborder:0;height:400px;max-width:100%;width:542px"><$m$usrc">https://s9e.github.io/$n/2/imgur.min.html#<xsl:if$s@type=\\\'album\\\'">a/</xsl:if>$g@id"/></$m></$n>$i$eINDIEGOGO"><$r$dindiegogo"$h$c222px"><$r$h$a200.45045%"><$n$f"$l$p$kno"$o//www.indiegogo.com/project/{@id}/embedded"$h$b/></$r></$r>$i$eINSTAGRAM"><$n$dinstagram"$f"$t$x$l$p onload="$j$kno"$hborder:0;height:540px;max-width:540px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/instagram.min.html#$g@id"/><xsl:if$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</xsl:if></$m></$n>$i$eINTERNETARCHIVE"><$w><$v$scontains(@id,\\\'playlist=1\\\')"><$n$dinternetarchive"$f"$l$p$kno"$ohttps://archive.org/embed/{@id}&amp;list_height=150"$hborder:0;height:170px;max-width:640px;width:100%"/></$v><$q><$r$dinternetarchive"$h$c{@width}px"><$r><$m$u$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</xsl:if></$m><$n$f"$l$p$kno"$ohttps://archive.org/embed/{@id}"$h$b/></$r></$r></$q></$w>$i$eIZLESENE"><$r$dizlesene"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.izlesene.com/embedplayer/{@id}?autoplay=0"$h$b/></$r></$r>$i$eJSFIDDLE"><$n$djsfiddle"$f"$l$p$kno"$o//jsfiddle.net/{@id}/{@revision}/embedded/{$MEDIAEMBED_THEME}/"$hborder:0;height:400px;width:100%"/>$i$eJWPLATFORM"><$r$djwplatform"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//content.jwplatform.com/players/{@id}.html"$h$b/></$r></$r>$i$eKALTURA"><$r$dkaltura"$h$c640px"><$r$h$a61.875%;padding-bottom:calc(56.25% + 36px)"><$n$f"$l$p$kno"$h$b><$m$usrc">https://cdnapisec.kaltura.com/p/$g@partner_id"/>/sp/<$w><$v$s@sp">$g@sp"/></$v><$q>$g@partner_id"/>00</$q></$w>/embedIframeJs/uiconf_id/$g@uiconf_id"/>/partner_id/$g@partner_id"/>?$nembed=true&amp;entry_id=$g@entry_id"/></$m></$n></$r></$r>$i$eKHL"><$r$dkhl"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//video.khl.ru/$n/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$h$b/></$r></$r>$i$eKICKSTARTER"><$r$dkickstarter"><$w><$v$s@video"><$m$u$x>$c640px</$m><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/video.html"$h$b/></$r></$v><$q><$m$u$x>$c220px</$m><$r$h$a190.909091%"><$n$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/card.html"$h$b/></$r></$q></$w></$r>$i$eLIBSYN"><$n$dlibsyn"$f"$l$p$kno"$o//html5-player.libsyn.com/embed/episode/id/{@id}/thumbnail/no"$hborder:0;height:90px;max-width:900px;width:100%"/>$i$eLIVELEAK"><$r$dliveleak"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.liveleak.com/e/{@id}"$h$b/></$r></$r>$i$eLIVESTREAM"><$r$dlivestream"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//<$w><$v$s@clip_id">cdn.livestream.com/embed/$g@channel"/>?layout=4&amp;autoplay=false&amp;clip=$g@clip_id"/></$v><$q>livestream.com/accounts/$g@account_id"/>/events/$g@event_id"/><xsl:if$s@video_id">/videos/$g@video_id"/></xsl:if>/player?autoPlay=false</$q></$w></$m></$n></$r></$r>$i$eMAILRU"><$r$dmailru"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://my.mail.ru/video/embed/{@id}"$h$b/></$r></$r>$i$eMEDIUM"><$n$dmedium"$f"$t$x$l$p onload="$j$kno"$ohttps://s9e.github.io/$n/2/medium.min.html#{@id}"$hborder:0;height:316px;max-width:900px;width:100%"/>$i$eMEGAPHONE"><$n$dmegaphone"$f"$l$p$kno"$hborder:0;height:200px;max-width:900px;width:100%"><$m$usrc">https://player.megaphone.fm/$g@id"/><xsl:if$s$MEDIAEMBED_THEME=\\\'light\\\'">?light=true</xsl:if></$m></$n>$i$eMETACAFE"><$r$dmetacafe"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.metacafe.com/embed/{@id}/"$h$b/></$r></$r>$i$eMIXCLOUD"><$r$dmixcloud"$h$c400px"><$r$h$a100%"><$n$f"$l$p$kno"$o//www.mixcloud.com/widget/$n/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&amp;embed_type=widget_standard"$h$b/></$r></$r>$i$eMLB"><$r$dmlb"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://www.mlb.com/video/share/c-{@id}"$h$b/></$r></$r>$i$eMRCTV"><$r$dmrctv"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://www.mrctv.org/embed/{@id}"$h$b/></$r></$r>$i$eMSNBC"><$r$dmsnbc"$h$c640px"><$r><$w><$v$scontains(@id,\\\'_\\\')"><$m$u$x>$a68.75%;padding-bottom:calc(56.25% + 80px)</$m><$n$f"$l$p$kno"$o//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$h$b/></$v><$q><$m$u$x>$a56.25%</$m><$n$f"$l$p$kno"$ohttps://www.msnbc.com/msnbc/embedded-video/{@id}"$h$b/></$q></$w></$r></$r>$i$eNATGEOCHANNEL"><$r$dnatgeochannel"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//channel.nationalgeographic.com/{@id}/embed/"$h$b/></$r></$r>$i$eNATGEOVIDEO"><$r$dnatgeovideo"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$h$b/></$r></$r>$i$eNBCNEWS"><$r$dnbcnews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.nbcnews.com/widget/video-embed/{@id}"$h$b/></$r></$r>$i$eNBCSPORTS"><$r$dnbcsports"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl="$h$b/></$r></$r>$i$eNHL"><$r$dnhl"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">https://www.nhl.com/video/embed<xsl:if$s@t">/t-$g@t"/></xsl:if><xsl:if$s@c">/c-$g@c"/></xsl:if>?autostart=false</$m></$n></$r></$r>$i$eNPR"><$n$dnpr"$f"$l$p$kno"$o//www.npr.org/player/embed/{@i}/{@m}"$hborder:0;height:228px;max-width:800px;width:100%"/>$i$eNYTIMES"><$r$dnytimes"$h$c585px"><$r$h$a68.376068%"><$n$f"$l$p$kno"$o//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$h$b/></$r></$r>$i$eODYSEE"><$r$dodysee"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">https://odysee.com/$/embed/<$w><$v$s@name">$g@name"/></$v><$q>-</$q></$w>/$g@id"/></$m></$n></$r></$r>$i$eORFIUM"><$n$dorfium"$f"$l$p$kno"><$m$usrc">https://www.orfium.com/embedded/<$w><$v$s@album_id">album/$g@album_id"/></$v><$v$s@playlist_id">playlist/$g@playlist_id"/></$v><$v$s@set_id">live-set/$g@set_id"/></$v><$q>track/$g@track_id"/></$q></$w></$m><$m$u$x>border:0;height:<$w><$v$s@album_id">550</$v><$q>275</$q></$w>px;max-width:900px;width:100%</$m></$n>$i$ePASTEBIN"><$n$dpastebin"$f"$l$p$k"$o//pastebin.com/embed_$n.php?i={@id}"$hborder:0;height:300px;resize:vertical;width:100%"/>$i$ePINTEREST"><$n$dpinterest"$f"$t$x$l$p onload="$j$kno"$ohttps://s9e.github.io/$n/2/pinterest.min.html#{@id}"><$m$u$x>border:0;height:360px;max-width:<$w><$v$scontains(@id,\\\'/\\\')">730</$v><$q>345</$q></$w>px;width:100%</$m></$n>$i$ePODBEAN"><$n$dpodbean"$f"$l$p$kno"$ohttps://www.podbean.com/player-v2/?i={@id}"$h$y/>$i$ePREZI"><$r$dprezi"$h$c550px"><$r$h$a72.727273%"><$n$f"$l$p$kno"$o//prezi.com/embed/{@id}/"$h$b/></$r></$r>$i$eREDDIT"><$n$dreddit"$f"$t$x$l$p onload="$j$kno"$ohttps://s9e.github.io/$n/2/reddit.min.html#{@id}{@path}#theme={$MEDIAEMBED_THEME}"$hborder:0;height:165px;max-width:800px;width:100%"/>$i$eRUMBLE"><$r$drumble"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://rumble.com/embed/{@id}/"$h$b/></$r></$r>$i$eRUTUBE"><$r$drutube"$h$c720px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//rutube.ru/play/embed/{@id}"$h$b/></$r></$r>$i$eSCRIBD"><$n$dscribd"$f"$l$p$kno"$ohttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$hborder:0;height:500px;resize:vertical;width:100%"/>$i$eSENDVID"><$r$dsendvid"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//sendvid.com/embed/{@id}"$h$b/></$r></$r>$i$eSLIDESHARE"><$r$dslideshare"$h$c427px"><$r$h$a83.372365%"><$n$f"$l$p$kno"$o//www.slideshare.net/slideshow/embed_code/{@id}"$h$b/></$r></$r>$i$eSOUNDCLOUD"><$n$dsoundcloud"$f"$l$p$kno"><$m$usrc">https://w.soundcloud.com/player/?url=<$w><$v$s@playlist_id">https%3A//api.soundcloud.com/playlists/$g@playlist_id"/></$v><$v$s@track_id">https%3A//api.soundcloud.com/tracks/$g@track_id"/>&amp;secret_token=$g@secret_token"/></$v><$q><xsl:if$snot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</xsl:if>$g@id"/></$q></$w></$m><$m$u$x>border:0;height:<$w><$v$s@playlist_id or contains(@id,\\\'/sets/\\\')">450</$v><$q>166</$q></$w>px;max-width:900px;width:100%</$m></$n>$i$eSPORCLE"><$n$dsporcle"$f"$t$x$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$kno"$ohttps://s9e.github.io/$n/2/sporcle.min.html#{@id}"$hborder:0;height:535px;max-width:820px;width:100%"/>$i$eSPORTSNET"><$r$dsportsnet"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId={@id}"$h$b/></$r></$r>$i$eSPOTIFY"><$w><$v$sstarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$n$dspotify" allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{@id}"$hborder:0;height:152px;max-width:900px;width:100%"/></$v><$q><$r$dspotify"$h$c320px"><$r$h$a125%;padding-bottom:calc(100% + 80px)"><$n allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$h$b/></$r></$r></$q></$w>$i$eSPREAKER"><$n$dspreaker"$f"$l$p$kno"$ohttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}&amp;theme={$MEDIAEMBED_THEME}"$hborder:0;height:{400-200*boolean(@episode_id)}px;max-width:900px;width:100%"/>$i$eSTEAMSTORE"><$n$dsteamstore"$f"$l$p$kno"$o//store.steampowered.com/widget/{@id}"$hborder:0;height:190px;max-width:900px;width:100%"/>$i$eSTITCHER"><$n$dstitcher"$f"$l$p$kno"$ohttps://www.stitcher.com/embed/{@fid}/{@eid}"$h$y/>$i$eSTRAWPOLL"><$r$dstrawpoll"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$k"$o//www.strawpoll.me/embed_1/{@id}"$h$b/></$r></$r>$i$eSTREAMABLE"><$r$dstreamable"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//streamable.com/e/{@id}"$h$b/></$r></$r>$i$eSTREAMJA"><$r$dstreamja"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://streamja.com/embed/{@id}"$h$b/></$r></$r>$i$eTEAMCOCO"><$r$dteamcoco"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//teamcoco.com/embed/v/{@id}"$h$b/></$r></$r>$i$eTED"><$r$dted"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//embed.ted.com/$g@id"/><xsl:if$snot(contains(@id,\\\'.html\\\'))">.html</xsl:if></$m></$n></$r></$r>$i$eTELEGRAM"><$n$dtelegram"$f"$t$x$l$p onload="$j$kno"$hborder:0;height:96px;max-width:500px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/telegram.min.html#$g@id"/><xsl:if$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</xsl:if></$m></$n>$i$eTHEATLANTIC"><$r$dtheatlantic"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.theatlantic.com/video/$n/{@id}/"$h$b/></$r></$r>$i$eTHEGUARDIAN"><$r$dtheguardian"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//embed.theguardian.com/embed/video/{@id}"$h$b/></$r></$r>$i$eTHEONION"><$r$dtheonion"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.theonion.com/video_embed/?id={@id}"$h$b/></$r></$r>$i$eTIKTOK"><$r$dtiktok"$h$c340px"><$r$h$a205.882353%"><$n$f"$l$p$kno"$o//www.tiktok.com/embed/{@id}"$h$b/></$r></$r>$i$eTMZ"><$r$dtmz"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$h$b/></$r></$r>$i$eTRADINGVIEW"><$n$dtradingview"$f"$l$p$kno"$hborder:0;height:400px;width:100%"><$m$usrc">https://s.tradingview.com/<$w><$v$s@symbol">widgetembed/?interval=D&amp;symbol=$gtranslate(@symbol,\\\'-\\\',\\\':\\\')"/></$v><$q>embed/$g@chart"/></$q></$w></$m></$n>$i$eTRAILERADDICT"><$r$dtraileraddict"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//v.traileraddict.com/{@id}"$h$b/></$r></$r>$i$eTRENDINGVIEWS"><$r$dtrendingviews"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://mydailyfreedom.com/tv/embed/{@id}"$h$b/></$r></$r>$i$eTUMBLR"><$n$dtumblr"$f"$t$x$l$p onload="$j$kno"$ohttps://s9e.github.io/$n/2/tumblr.min.html#{@key}/{@id}"$hborder:0;height:300px;max-width:520px;width:100%"/>$i$eTWENTYFOURSEVENSPORTS"><$w><$v$s@video_id"><$r$dtwentyfoursevensports"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://www.cbssports.com/video/player/embed?args=player_id%3D{@video_id}%26channel%3Dmobilevideo%26pcid%3D{@video_id}%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue"$h$b/></$r></$r></$v><$q><$n$dtwentyfoursevensports"$f"$l$p onload="window.addEventListener(\\\'message\\\',function(e){{if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}})"$kno"$ohttps://247sports.com/PlayerSport/{@player_id}/Embed/"$hborder:0;height:200px;max-width:600px;width:100%"/></$q></$w>$i$eTWITCH"><$r$dtwitch"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p onload="contentWindow.postMessage(\\\'\\\',\\\'https://s9e.github.io\\\')"$kno"$ohttps://s9e.github.io/$n/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$h$b/></$r></$r>$i$eTWITTER"><$n$dtwitter" allow="autoplay *"$f"$t$x$l$p onload="$j$kno"$hborder:0;height:273px;max-width:550px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/twitter.min.html#$g@id"/><xsl:if$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</xsl:if></$m></$n>$i$eUSTREAM"><$r$dustream"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//www.ustream.tv/embed/<$w><$v$s@vid">recorded/$g@vid"/></$v><$q>$g@cid"/></$q></$w>?html5ui</$m></$n></$r></$r>$i$eVBOX7"><$r$dvbox7"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//vbox7.com/emb/external.php?vid={@id}"$h$b/></$r></$r>$i$eVEOH"><$r$dveoh"$h$c640px"><$r$h$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$h$z type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/></object></$r></$r>$i$eVEVO"><$r$dvevo"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://embed.vevo.com/?isrc={@id}"$h$b/></$r></$r>$i$eVIDEODETECTIVE"><$r$dvideodetective"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$h$b/></$r></$r>$i$eVIMEO"><$r$dvimeo"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$h$b><$m$usrc">//player.vimeo.com/video/$g@id"/><xsl:if$s@h">?h=$g@h"/></xsl:if><xsl:if$s@t">#t=$g@t"/></xsl:if></$m></$n></$r></$r>$i$eVINE"><$r$dvine"$h$c480px"><$r$h$a100%"><$n$f"$l$p$kno"$ohttps://vine.co/v/{@id}/embed/simple?audio=1"$h$b/></$r></$r>$i$eVK"><$r$dvk"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$h$b/></$r></$r>$i$eVOCAROO"><$n$dvocaroo"$f"$l$p$kno"$ohttps://vocaroo.com/embed/{@id}"$hborder:0;height:80px;max-width:900px;width:100%"/>$i$eVOX"><$r$dvox"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//player.ooyala.com/$n.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$h$b/></$r></$r>$i$eWASHINGTONPOST"><$r$dwashingtonpost"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//www.washingtonpost.com/video/c/embed/{@id}"$h$b/></$r></$r>$i$eWISTIA"><$w><$v$s@type=\\\'audio\\\'"><$n$dwistia"$f"$l$p$kno"$ohttps://fast.wistia.net/embed/$n/{@id}"$hborder:0;height:218px;max-width:900px;width:100%"/></$v><$q><$r$dwistia"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://fast.wistia.net/embed/$n/{@id}"$h$b/></$r></$r></$q></$w>$i$eWSHH"><$r$dwshh"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//worldstarhiphop.com/embed/{@id}"$h$b/></$r></$r>$i$eWSJ"><$r$dwsj"$h$c512px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//video-api.wsj.com/api-video/player/$n.html?guid={@id}"$h$b/></$r></$r>$i$eXBOXCLIPS"><$r$dxboxclips"$h$c560px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//gameclips.io/{@user}/{@id}/embed"$h$b/></$r></$r>$i$eXBOXDVR"><$r$dxboxdvr"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$h$b/></$r></$r>$i$eYOUKU"><$r$dyouku"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$o//player.youku.com/embed/{@id}"$h$b/></$r></$r>$i$eYOUMAKER"><$r$dyoumaker"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$ohttps://www.youmaker.com/embed/{@id}"$h$b/></$r></$r>$i$eYOUTUBE"><$r$dyoutube"$h$c640px"><$r$h$a56.25%"><$n$f"$l$p$kno"$hbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$m$usrc">https://www.youtube.com/embed/$g@id"/><xsl:if$s@list">?list=$g@list"/></xsl:if><xsl:if$s@t"><$w><$v$s@list">&amp;</$v><$q>?</$q></$w>start=$g@t"/></xsl:if></$m></$n></$r></$r>$i$ebr"><br/>$i$ee|i|s"/>$ep"><p><xsl:apply-templates/></p>$i</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\' data-s9e-mediaembed="\',$e:\'<xsl:template match="\',$f:\' allowfullscreen="\',$g:\'<xsl:value-of select="\',$h:\' style="\',$i:"</xsl:template>",$j:"var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\'px\'}};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])\\"",
$k:\' scrolling="\',$l:\' loading="\',$m:"xsl:attribute",$n:"iframe",$o:\' src="\',$p:\'lazy"\',$q:"xsl:otherwise",$r:"span",$s:\' test="\',$t:\' data-s9e-livepreview-ignore-attrs="\',$u:\' name="\',$v:"xsl:when",$w:"xsl:choose",$x:\'style"\',$y:\'border:0;height:150px;max-width:900px;width:100%"\',$z:\'height:100%;left:0;position:absolute;width:100%"\'}[a]});
function La(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(g,n){c[g]=""<b[n+1]?b[n+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function Ma(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=Na(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+Na(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(g){return g.toUpperCase()},c);b+=Oa(c);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));return b}
function Oa(a){return a.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,function(b){return"%"+b[0].charCodeAt(0).toString(16).toUpperCase()})}
function Pa(a,b){if(""!==b.scheme&&!a.F.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var g=4,n=c.split(".");0<=--g;){if("0"===n[g][0]||255<n[g]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.G&&
a.G.test(b.host)||a.J&&!a.J.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function Qa(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}function Ra(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function Na(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}
function Sa(){this.p={};this.u=[]}Sa.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.l||(c.attrName=this.l);"tag"in c||!this.n||(c.tag=this.n);this.p[a]&&this.p[a].forEach(function(g){g(b,c)});this.u.push([a,b,c])};Sa.prototype.getLogs=function(){return this.u};Sa.prototype.on=function(a,b){this.p[a].push(b)};function Ta(a,b){C.add("debug",a,b)}function H(a,b,c,g,n){this.q=+a;this.name=b;this.l=+c;this.n=+g;this.x=+n||0;this.b={};this.z=[];isNaN(a+c+g)&&D(this)}H.prototype.p=!1;
function D(a){a.p||(a.p=!0,a.z.forEach(function(b){D(b)}))}function Ua(a,b){Va(a,b)?(a.v=b,b.u=a,a.z.push(b),a.p&&D(b)):Va(b,a)&&(a.u=b,b.v=a)}function Va(a,b){return a.name===b.name&&1===a.q&&2===b.q&&a.l<=a.l}function Wa(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function Xa(a,b){return a.p||!Va(b,a)||a.u&&a.u!==b||b.v&&b.v!==a?!1:!0}function Ea(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var J,Ya,K,L,M,Za,C=new Sa,N,O,Q={MediaEmbed:{I:function(a,b){b.forEach(function(c){var g=c[0][0];P(3,"MEDIA",c[0][1],g.length,-10).b.url=g})},B:"://",C:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,D:5E4}},R,S={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","acast.com":"acast","amazon.ca":"amazon","amazon.co.jp":"amazon","amazon.co.uk":"amazon","amazon.com":"amazon","amazon.de":"amazon","amazon.es":"amazon","amazon.fr":"amazon","amazon.in":"amazon",
"amazon.it":"amazon","anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","audius.co":"audius","bandcamp.com":"bandcamp","bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","bleacherreport.com":"bleacherreport","castos.com":"castos","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel","clyp.it":"clyp","cnbc.com":"cnbc","cnn.com":"cnn","codepen.io":"codepen",
"comedycentral.com":"comedycentral","coub.com":"coub","dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive","dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","falstad.com":"falstad","fb.watch":"facebook","flic.kr":"flickr","flickr.com":"flickr","funnyordie.com":"funnyordie","gameclips.io":"xboxclips","gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gettyimages.be":"getty",
"gettyimages.cn":"getty","gettyimages.co.jp":"getty","gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty","gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gfycat.com":"gfycat","gifs.com":"gifs","giphy.com":"giphy","github.com":"gist","globalnews.ca":"globalnews","gofundme.com":"gofundme","gty.im":"getty",
"hudl.com":"hudl","hulu.com":"hulu","ign.com":"ign","imdb.com":"imdb","imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene","jsfiddle.net":"jsfiddle","jwplatform.com":"jwplatform","kaltura.com":"kaltura","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","link.tospotify.com":"spotify","liveleak.com":"liveleak","livestre.am":"livestream","livestream.com":"livestream","medium.com":"medium","megaphone.fm":"megaphone",
"megaphone.link":"megaphone","metacafe.com":"metacafe","mixcloud.com":"mixcloud","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv","msnbc.com":"msnbc","my.mail.ru":"mailru","mydailyfreedom.com":"trendingviews","n.pr":"npr","nbcnews.com":"nbcnews","nbcsports.com":"nbcsports","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","odysee.com":"odysee","open.spotify.com":"spotify","orfium.com":"orfium","pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","players.brightcove.net":"brightcove",
"plus.google.com":"googleplus","podbean.com":"podbean","podcasts.apple.com":"applepodcasts","prezi.com":"prezi","reddit.com":"reddit","rumble.com":"rumble","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare","soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spreaker.com":"spreaker","stitcher.com":"stitcher","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","streamja.com":"streamja",
"t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic","theguardian.com":"theguardian","theonion.com":"theonion","tiktok.com":"tiktok","tmz.com":"tmz","tradingview.com":"tradingview","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews","tumblr.com":"tumblr","twitch.tv":"twitch","twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo",
"videodetective.com":"videodetective","vimeo.com":"vimeo","vine.co":"vine","vk.com":"vk","vkontakte.ru":"vk","voca.ro":"vocaroo","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","wistia.com":"wistia","worldstar.com":"wshh","worldstarhiphop.com":"wshh","wsj.com":"wsj","xboxclips.com":"xboxclips","xboxdvr.com":"xboxdvr","youku.com":"youku","youmaker.com":"youmaker","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,
p]],[]],acast:[[[/play\\.acast\\.com\\/s\\/([-.\\w]+)\\/([-.\\w]+)(?:\\?seek=(\\d+))?/,ua],[/shows\\.acast\\.com\\/([-.\\w]+)\\/(?:episodes\\/)?([-.\\w]+)(?:\\?seek=(\\d+))?/,ua]],[{a:[[/"showId":"([-0-9a-f]+)/,ca],[/"id":"([-0-9a-f]+)/,ma]],match:[[/play\\.acast\\.com\\/s\\/[-.\\w]+\\/./,d],[/shows\\.acast\\.com\\/[-.\\w]+\\/./,d]],o:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}"}]],amazon:[[[/\\/(?:dp|gp\\/product)\\/([A-Z0-9]+)/,p],[/amazon\\.(?:co\\.)?(ca|de|es|fr|in|it|jp|uk)/,["","tld"]]],[]],anchor:[[[/anchor.fm\\/(?:[-\\w]+\\/)*episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,
p]],[]],applepodcasts:[[[/podcasts\\.apple\\.com\\/(\\w+)\\/podcast\\/[-\\w]*\\/id(\\d+)(?:\\?i=(\\d+))?/,["","country","podcast_id","episode_id"]]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,p]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+)\\/([-\\w]+)/,["","mode","artist","title"]],[/audiomack\\.com\\/([-\\w]+)\\/(album|song)\\/([-\\w]+)/,["","artist","mode","title"]]],[]],audius:[[],[{a:[[pa,w]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/(?!album\\/|playlist\\/)([%\\-.\\w]+)/,na]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}"},
{a:[[pa,da]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/album\\/([%\\-.\\w]+)/,na]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}"},{a:[[pa,oa]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/playlist\\/([%\\-.\\w]+)/,na]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}"}]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,da]],match:[[/bandcamp\\.com\\/album\\/./,d]]},{a:[[/"album_id":(\\d+)/,da],[/"track_num":(\\d+)/,
["","track_num"]],[/\\/track=(\\d+)/,w]],match:[[/bandcamp\\.com\\/track\\/./,d]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/(?:\\w+-)+(\\d+)/,p],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/embed\\/(\\w+\\/\\d+)/,p],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/\\w+\\/(\\d+)/,p],[/bbc\\.co(?:m|\\.uk)\\/news\\/av-embeds\\/(\\d+)/,p]],[]],bitchute:[[[/bitchute\\.com\\/(?:embed|video)\\/([-\\w]+)/,p]],[]],bleacherreport:[[],[{a:[[/id="video-([-\\w]+)/,p],[/video_embed\\?id=([-\\w]+)/,p]],match:[[/\\/articles\\/./,
d]]}]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],castos:[ya,[{a:ya,match:[[/castos\\.com\\/(?:podcasts\\/[^\\/]*\\/)?episodes\\/./,d]]}]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,p],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,p]],[]],clyp:[[[/clyp\\.it\\/(?!user\\/)(\\w+)/,p]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,p]],
[{a:[[/byGuid=(\\d+)/,p]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,d]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,p],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,p]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,p]],[]],codepen:[[[/codepen\\.io\\/([-\\w]+)\\/(?:details|embed|full|live|pen)\\/(\\w+)/,ha]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,p]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,d]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,
p]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,p],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,p],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,p]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,p]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,d]]}]],dumpert:[[[/dumpert\\.nl\\/(?:item|mediabase)\\/(\\d+[\\/_]\\w+)/,p]],[]],eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,
p]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,p]],match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,d]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,p]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,p],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,r],[/facebook\\.com\\/watch\\/\\?([pv])=/,r],[/facebook.com\\/groups\\/[^\\/]*\\/(p)osts\\/(\\d+)/,
ia]],[{a:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,ia],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,["","user","type","id"]]],r:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,d]]}]],falstad:[[[/falstad\\.com\\/circuit\\/circuitjs\\.html\\?c(?:ct=([^&]+)|tz=([-+=\\w]+))/,["","cct","ctz"]]],[]],flickr:[[xa,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,p]],[{a:[xa],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],o:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,p]],
[]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,p]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,p]],[]],getty:[[],[{a:[[/\\/embed\\/(\\d+)/,p],[/"height":[ "]*(\\d+)/,v],[/"width":[ "]*(\\d+)/,t],[/\\?et=([-=\\w]+)/,["","et"]],[/\\\\u0026sig=([-=\\w]+)/,["","sig"]]],match:[[/(?:gty\\.im|gettyimages\\.[.\\w]+\\/detail(?=\\/).*?)\\/(\\d+)/,p]],o:"https://embed.gettyimages.com/preview/{@id}"}]],gfycat:[[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?(\\w+)/,
p]],[{a:[[/\\/ifr\\/(\\w+)/,p]],match:[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?[a-z]/,d]],o:"https://gfycat.com/ifr/{@id}"},{a:[[/"height":(\\d+)/,v],[/"width":(\\d+)/,t]],match:ea,o:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}"}]],gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,p]],[{a:[[/meta property="og:image:width" content="(\\d+)/,t],[/meta property="og:image:height" content="(\\d+)/,v]],match:ea,o:"https://gifs.com/gif/{@id}"}]],giphy:[[[/giphy\\.com\\/(gif|video|webp)\\w+\\/(?:[-\\w]+-)*(\\w+)/,
ia],[/giphy\\.com\\/media\\/(\\w+)\\/\\w+\\.(gif|webp)/,ja],[/i\\.giphy\\.com\\/(\\w+)\\.(gif|webp)/,ja]],[{a:[[/"height"\\s*:\\s*(\\d+)/,v],[/"width"\\s*:\\s*(\\d+)/,t]],match:ea,o:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif"}]],gist:[[[/gist\\.github\\.com\\/((?:[-\\w]+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?\\b(?!\\/archive))/,p]],[]],globalnews:[va,[{a:va,match:[[/globalnews\\.ca\\/video\\/rd\\//,d]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,p]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,
p]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,p],[/oid=(\\d+)/,["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,r]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,sa],Aa,wa],[{a:[Aa,wa],match:[[/hudl\\.com\\/v\\//,d]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,p]],match:[[/hulu\\.com\\/watch\\//,d]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,
p]],[]],imdb:[[],[{a:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)\\/[\\/\\w]*embed/,p]],match:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,p]],o:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed"}]],imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,p],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,p],[/imgur\\.com\\/(\\w+)(?![\\w.\\/])/,p]],[{a:[[/data-id="([\\w\\/]+)"/,p]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,["","path"]]],o:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,p]],
[]],instagram:[[[/instagram\\.com\\/(?:p|reel|tv)\\/([-\\w]+)/,p]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,p],[/meta property="og:video:width" content="(\\d+)/,t],[/meta property="og:video:height" content="(\\d+)/,v]],match:[[/archive\\.org\\/(?:details|embed)\\//,d]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,p]],[]],jsfiddle:[[[/jsfiddle.net\\/(?:(\\w+)\\/)?(?!\\d+\\b|embedded\\b|show\\b)(\\w+)\\b(?:\\/(\\d+)\\b)?/,["","user","id","revision"]]],
[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,p]],[]],kaltura:[[[/\\/p(?:artner_id)?\\/(\\d+)\\//,["","partner_id"]],[/\\/sp\\/(\\d+)\\//,["","sp"]],[/\\/uiconf_id\\/(\\d+)\\//,["","uiconf_id"]],[/\\bentry_id[=\\/](\\w+)/,["","entry_id"]]],[{a:[[/kaltura\\.com\\/+p\\/(\\d+)\\/sp\\/(\\d+)\\/\\w*\\/uiconf_id\\/(\\d+)\\/.*?\\bentry_id=(\\w+)/,["","partner_id","sp","uiconf_id","entry_id"]]],match:[[/kaltura\\.com\\/(?:media\\/t|tiny)\\/./,d]]}]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,p]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,
d]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,p]],match:[[/(?!\\.mp3)....$/,d]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,p]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,p]],match:[[/liveleak\\.com\\/view\\?t=/,d]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,ta],[/\\/videos\\/(\\d+)/,fa],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,ra]],
[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,ta]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,d]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,ra]],match:[[/livestre.am/,d]]}]],mailru:[[],[{a:[[/"itemId": ?"?(\\d+)/,p]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,d]]}]],medium:[[[/medium\\.com\\/(?:s\\/\\w+\\/|@?[-\\w]+\\/)?(?:\\w+-)*([0-9a-f]+)(?!\\w)/,p]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,p],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,p],[/megaphone\\.link\\/(\\w+)/,
p]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,p]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,p]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,p]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,p]],match:[[/mrctv\\.org\\/videos\\/./,d]]}]],msnbc:[[],[{a:[[/embedded-video\\/(?!undefined)(\\w+)/,p]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,d],[/on\\.msnbc\\.com\\/./,d]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,p]],
[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,p]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,d]]}]],nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,p]],[]],nbcsports:[[],[{a:[[/select\\/media\\/(\\w+)/,p]],match:[[/nbcsports\\.com\\/video\\/./,d]]}]],nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],r:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,
d],[/n\\.pr\\/\\w/,d]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,p],[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,p]],[{a:[[/\\/video\\/movies\\/(\\d+)/,p]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],o:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],odysee:[[[/odysee\\.com\\/(?:\\$\\/\\w+\\/)?([^:\\/]+)[:\\/](\\w{40})/,ka]],[{a:[[/odysee\\.com\\/\\$\\/embed\\/([^:\\/]+)\\/(\\w{40})/,ka]],match:[[/odysee\\.com\\/@[^\\/:]+:\\w+\\/./,
d]]}]],orfium:[[[/album\\/(\\d+)/,da],[/playlist\\/(\\d+)/,oa],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,w]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,p]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,p],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,p]],[]],podbean:[[[/podbean\\.com\\/(?:[-\\w]+\\/)*(?:player[-\\w]*\\/|\\w+\\/pb-)([-\\w]+)/,p]],[{a:[[/podbean\\.com\\/player[^\\/]*\\/\\?i=([-\\w]+)/,p]],match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,
d]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,p]],[]],reddit:[[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,p]],[]],rumble:[[[/rumble\\.com\\/embed\\/(\\w+)/,p]],[{a:[[/video"?:"(\\w+)/,p]],match:[[/rumble\\.com\\/(?!embed\\/)./,d]]}]],rutube:[[[/rutube\\.ru\\/(?:play\\/embed|tracks)\\/(\\d+)/,p]],[{a:[[/rutube\\.ru\\/play\\/embed\\/(\\d+)/,
p]],r:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.0.0 Safari/537.36",match:[[/rutube\\.ru\\/video\\/([0-9a-f]{32})/,ba]],o:"https://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/"}]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,p]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,p]],[]],slideshare:[[[/slideshare\\.net\\/[^\\/]+\\/[-\\w]+-(\\d{6,})$/,p]],[{a:[[/"presentationId":(\\d+)/,p]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,
d]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,p],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,oa],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud:tracks:(\\d+)/,w]],r:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,d]]},{a:[[/soundcloud:\\/\\/playlists:(\\d+)/,
oa]],r:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/[-\\w]+\\/sets\\//,d]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,p]],[{a:[[/encodedGameID\\W+(\\w+)/,p]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,d]]}]],sportsnet:[[],[{a:[[/bc_videos\\s*:\\s*(\\d+)/,p]],match:ea}]],spotify:[Ca,[{a:Ca,r:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,d]]}]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,ma]],[{a:[[/episode_id=(\\d+)/,ma],[/show_id=(\\d+)/,ca]],match:[[/(.+\\/(?:show\\/|user\\/.+\\/).+)/,
["","url"]]],o:"https://api.spreaker.com/oembed?format=json&url={@url}"}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,p]],[]],stitcher:[[[/\\/(?:embed|splayer\\/f)\\/(\\d+)\\/(\\d+)/,la]],[{a:[[/\\/embed\\/(\\d+)\\/(\\d+)/,la]],match:[[/\\/(?:podcast\\/|show\\/|s\\?)/,d]]}]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,p]],[]],streamable:[[[/streamable\\.com\\/(?:e\\/)?(\\w+)/,p]],[]],streamja:[[[/streamja\\.com\\/(?!login|signup|terms|videos)(\\w+)/,p]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,p]],[{a:[[/embed\\/v\\/(\\d+)/,
p]],match:[[/teamcoco\\.com\\/video\\/\\D/,d]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,p]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(\\w+\\/\\d+)/,p]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,p]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,p]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,p]],[]],tiktok:[Ba,[{a:Ba,match:[[/\\/\\/vm\\.tiktok\\.com\\/./,d]]}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,
p]],[]],tradingview:[[[/tradingview\\.com\\/(?:chart\\/[^\\/]+|i)\\/(\\w+)/,["","chart"]],[/tradingview\\.com\\/symbols\\/([-:\\w]+)/,["","symbol"]]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,p]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,d]]}]],trendingviews:[[[/(?:mydailyfreedom\\.com|trendingviews\\.co)\\/(?:tv\\/)?(?:embed|video)\\/(?:[^\\/]+-)?(\\d+)/,p]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,ka]],[{a:[[/did=\\\\u0022([-\\w]+)/,["","did"]],[/embed\\\\\\/post\\\\\\/([-\\w]+)/,["","key"]]],
r:"User-agent: curl",match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,d]],o:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[za,[{a:za,r:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/,d]]},{a:[[/embedVideoContainer_(\\d+)/,fa]],r:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",
match:[[/247sports\\.com\\/Video\\/./,d]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,fa],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,ra],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,ra]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,p]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,ba]],[{a:[[/embed\\/(\\d+)/,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,
d]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,p]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,p]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,p]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)(?:\\/(\\w+))?\\b/,["","id","h"]],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,p]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,
qa],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,qa]],[{a:[[/meta property="og:video" content=".*?oid=(-?\\d+).*?id=(\\d+).*?hash=([0-9a-f]+)/,qa]],r:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/^(?!.*?hash=)/,d]]}]],vocaroo:[[[/voca(?:\\.ro|roo\\.com)\\/(?:i\\/)?(\\w+)/,p]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,p]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,p],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,
p]],[]],wistia:[[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)(\\w+)/,p]],[{a:[[/"type":"(?:\\w+_)?(audio)/,r]],match:[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)\\w/,d]],o:"https://fast.wistia.net/embed/iframe/{@id}"}]],wshh:[[[/worldstar(?:hiphop)?\\.com\\/(?:emb|featur)ed\\/(\\d+)/,p]],[{a:[[/(?:v: ?"?|worldstar(?:hiphop)?\\.com\\/embed\\/)(\\d+)/,p]],match:[[/worldstar(?:hiphop)?\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,d]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,p],[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,
p]],[{a:[[/guid=([-0-9A-F]{36})/,p]],match:[[/on\\.wsj\\.com\\/\\w/,d]]}]],xboxclips:[[[/(?:gameclips\\.io|xboxclips\\.com)\\/(?!game\\/)([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,ha]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,ha]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,p]],[]],youmaker:[[[/youmaker\\.com\\/(?:embed|v(?:ideo)?)\\/([-a-z0-9]+)/i,p]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|shorts\\/|v\\/|attribution_link.*?v%3D)([-\\w]+)/,p],[/youtu\\.be\\/([-\\w]+)/,p],
[/[#&?]t=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[]]},urlConfig:{F:/^https?$/i}},$a={e:[771],flags:0},T={ABCNEWS:F,ACAST:{e:e,b:{episode_id:z,show_id:z,t:z},j:1,d:E,f:10,k:u,g:5E3},AMAZON:{e:e,b:{id:B,tld:z},j:1,d:E,f:10,k:u,g:5E3},ANCHOR:F,APPLEPODCASTS:{e:e,b:{country:z,episode_id:z,podcast_id:z},j:1,d:E,f:10,k:u,g:5E3},AUDIOBOOM:F,AUDIOMACK:{e:e,b:{artist:z,mode:z,title:z},j:1,d:E,f:10,k:u,g:5E3},AUDIUS:{e:e,b:{album_id:z,playlist_id:z,track_id:z},j:1,d:E,f:10,k:u,g:5E3},BANDCAMP:{e:e,
b:{album_id:z,track_id:z,track_num:z},j:1,d:E,f:10,k:u,g:5E3},BBCNEWS:F,BITCHUTE:F,BLEACHERREPORT:F,BRIGHTCOVE:{e:e,b:{bckey:z,bcpid:z,bctid:z},j:1,d:E,f:10,k:u,g:5E3},CASTOS:{e:e,b:{host:z,id:z},j:1,d:E,f:10,k:u,g:5E3},CBSNEWS:F,CLYP:F,CNBC:F,CNN:F,CNNMONEY:F,CODEPEN:Ia,COMEDYCENTRAL:F,COUB:F,DAILYMOTION:{e:e,b:{id:z,t:z},j:1,d:E,f:10,k:u,g:5E3},DEMOCRACYNOW:F,DUMPERT:F,EIGHTTRACKS:F,ESPN:F,FACEBOOK:{e:e,b:{id:z,type:z,user:z},j:1,d:E,f:10,k:u,g:5E3},FALSTAD:{e:e,b:{cct:z,ctz:z},j:1,d:E,f:10,k:u,
g:5E3},FLICKR:F,FOXNEWS:F,FUNNYORDIE:F,GAMESPOT:F,GETTY:{e:e,b:{et:B,height:Ga,id:z,sig:B,width:Ha},j:1,d:E,f:10,k:u,g:5E3},GFYCAT:Ja,GIFS:Ja,GIPHY:{e:e,b:{height:Ga,id:z,type:z,width:Ha},j:1,d:E,f:10,k:u,g:5E3},GIST:F,GLOBALNEWS:F,GOFUNDME:F,GOOGLEDRIVE:F,GOOGLEPLUS:{e:e,b:{name:{d:[function(a){return decodeURIComponent(""+a)}],s:!1},oid:z,pid:z},j:1,d:E,f:10,k:u,g:5E3},GOOGLESHEETS:{e:e,b:{gid:z,id:z,oid:z,type:z},j:1,d:E,f:10,k:u,g:5E3},HUDL:{e:e,b:{athlete:z,highlight:z,id:z},j:1,d:E,f:10,k:u,
g:5E3},HULU:F,IGN:F,IMDB:F,IMGUR:F,INDIEGOGO:F,INSTAGRAM:F,INTERNETARCHIVE:{e:e,b:{height:Ga,id:{d:[function(){return!1}],s:!1},width:Ha},j:1,d:E,f:10,k:u,g:5E3},IZLESENE:F,JSFIDDLE:{e:e,b:{id:z,revision:z,user:z},j:1,d:E,f:10,k:u,g:5E3},JWPLATFORM:F,KALTURA:{e:e,b:{entry_id:B,partner_id:B,sp:z,uiconf_id:B},j:1,d:E,f:10,k:u,g:5E3},KHL:F,KICKSTARTER:{e:e,b:{card:z,id:z,video:z},j:1,d:E,f:10,k:u,g:5E3},LIBSYN:F,LIVELEAK:F,LIVESTREAM:{e:e,b:{account_id:z,channel:z,clip_id:z,event_id:z,video_id:z},j:1,
d:E,f:10,k:u,g:5E3},MAILRU:F,MEDIA:{e:[770],b:{},j:0,d:[function(a){return function(b,c,g){function n(h,l,q){var k=!1;q.forEach(function(m){var x=m[1],A=m[0].exec(l);A&&(k=!0,x.forEach(function(I,y){""<A[y]&&""<I&&(h[I]=A[y])}))});return k}(function(h,l,q){D(h);if("url"in h.b){var k=h.b.url,m;a:{for(m=/^https?:\\/\\/([^\\/]+)/.exec(k.toLowerCase())[1]||"";""<m;){if(l[m]){m=l[m];break a}m=m.replace(/^[^.]*./,"")}m=""}if(q[m]){l={};n(l,k,q[m][0]);a:{for(var x in l){q=!1;break a}q=!0}if(!q){q=h.l;x=h.v;
if(x){var A=h.n;k=x.l;x=x.n}else A=0,k=h.l+h.n,x=0;m=m.toUpperCase();h=h.x;k=P(2,m,k,x,-h||0);h=P(1,m,q,A,h||0);Ua(h,k);Ea(h,l)}}}})(b,c,g)}(a,S["MediaEmbed.hosts"],S["MediaEmbed.sites"],S.cacheDir)}],f:10,k:{flags:513},g:5E3},MEDIUM:F,MEGAPHONE:F,METACAFE:F,MIXCLOUD:F,MLB:F,MRCTV:F,MSNBC:F,NATGEOCHANNEL:F,NATGEOVIDEO:F,NBCNEWS:F,NBCSPORTS:F,NHL:{e:e,b:{c:z,t:z},j:1,d:E,f:10,k:u,g:5E3},NPR:{e:e,b:{i:z,m:z},j:1,d:E,f:10,k:u,g:5E3},NYTIMES:F,ODYSEE:{e:e,b:{id:z,name:{d:[function(a){var b=S.urlConfig,
c=C,g=La(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Pa(b,g))?(c&&(g.attrValue=a,c.add("err",b,g)),a=!1):a=Ma(g);return a}],s:!1}},j:1,d:E,f:10,k:u,g:5E3},ORFIUM:{e:e,b:{album_id:z,playlist_id:z,set_id:z,track_id:z},j:1,d:E,f:10,k:u,g:5E3},PASTEBIN:F,PINTEREST:F,PODBEAN:F,PREZI:F,REDDIT:F,RUMBLE:F,RUTUBE:F,SCRIBD:F,SENDVID:F,SLIDESHARE:F,SOUNDCLOUD:{e:e,b:{id:z,playlist_id:z,secret_token:z,track_id:z},j:1,d:E,f:10,k:u,g:5E3},SPORCLE:F,SPORTSNET:F,SPOTIFY:F,SPREAKER:{e:e,b:{episode_id:z,show_id:z},
j:1,d:E,f:10,k:u,g:5E3},STEAMSTORE:F,STITCHER:{e:e,b:{eid:z,fid:z},j:1,d:E,f:10,k:u,g:5E3},STRAWPOLL:F,STREAMABLE:F,STREAMJA:F,TEAMCOCO:F,TED:F,TELEGRAM:F,THEATLANTIC:F,THEGUARDIAN:F,THEONION:F,TIKTOK:F,TMZ:F,TRADINGVIEW:{e:e,b:{chart:z,symbol:z},j:1,d:E,f:10,k:u,g:5E3},TRAILERADDICT:F,TRENDINGVIEWS:F,TUMBLR:{e:e,b:{did:z,id:z,key:z,name:z},j:1,d:E,f:10,k:u,g:5E3},TWENTYFOURSEVENSPORTS:{e:e,b:{player_id:z,video_id:z},j:1,d:E,f:10,k:u,g:5E3},TWITCH:{e:e,b:{channel:z,clip_id:z,t:z,video_id:z},j:1,d:E,
f:10,k:u,g:5E3},TWITTER:F,USTREAM:{e:e,b:{cid:z,vid:z},j:1,d:E,f:10,k:u,g:5E3},VBOX7:F,VEOH:F,VEVO:F,VIDEODETECTIVE:F,VIMEO:{e:e,b:{h:z,id:z,t:Fa},j:1,d:E,f:10,k:u,g:5E3},VINE:F,VK:{e:e,b:{hash:z,oid:z,vid:z},j:1,d:E,f:10,k:u,g:5E3},VOCAROO:F,VOX:F,WASHINGTONPOST:F,WISTIA:{e:e,b:{id:z,type:z},j:1,d:E,f:10,k:u,g:5E3},WSHH:F,WSJ:F,XBOXCLIPS:Ia,XBOXDVR:Ia,YOUKU:F,YOUMAKER:F,YOUTUBE:{e:e,b:{id:{d:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?a:!1}],s:!1},list:z,t:Fa},j:1,d:E,f:10,k:u,g:5E3}},U,ab,V,W,
bb=0,X;
function cb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=C;b.u=[];delete b.l;delete b.n;J={};Ya={};L=0;M=null;Za=!1;N=[];O="";R=0;U=[];ab=!1;V=a;W=V.length;X=0;K=$a;K.A=!1;++bb;a=bb;for(var c in Q)if(!Q[c].w)a:{b=c;var g=Q[b];if(!(g.B&&0>V.indexOf(g.B))){var n=[];if("undefined"!==typeof g.C&&"undefined"!==typeof g.D){n=void 0;var h=g.C;g=g.D;h.lastIndex=0;for(var l=[],q=0;++q<=g&&(n=h.exec(V));){for(var k=n.index,m=[[n[0],k]],x=0;++x<n.length;){var A=n[x];void 0===
A?m.push(["",-1]):(m.push([A,V.indexOf(A,k)]),k+=A.length)}l.push(m)}n=l;if(!n.length)break a}(0,Q[b].I)(V,n)}}db();Y(W,!0);do c=O,O=O.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(O!==c);O=O.replace(/<\\/i><i>/g,"");O=O.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");O=O.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,eb);c=Za?"r":"t";O="<"+c+">"+O+"</"+c+">";if(bb!==a)throw"The parser has been reset during execution";1E4<L&&C.add("warn","Fixing cost limit exceeded",void 0);return O}
function fb(a){var b={},c;for(c in T[a])b[c]=T[a][c];return T[a]=b}function eb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function gb(a){Za=!0;var b=a.name,c=a.l,g=a.n,n=0;Y(c,!(a.q&1));var h=g?Ra(V.substring(c,c+g)):"";if(a.q&1){O+="<"+b;var l=Wa(a),q=[],k;for(k in l)q.push(k);q.sort(function(m,x){return m>x?1:-1});q.forEach(function(m){O+=" "+m+\'="\'+Qa(l[m].toString()).replace(/\\n/g,"&#10;")+\'"\'});O=3===a.q?g?O+(">"+h+"</"+b+">"):O+"/>":g?O+("><s>"+h+"</s>"):O+">"}else g&&(O+="<e>"+h+"</e>"),O+="</"+b+">";for(X=R=c+g;n&&X<W&&"\\n"===V[X];)--n,++X}
function Y(a,b){var c=0;b&&(K.flags&8?c=-1:b=!1);R>=a&&b&&hb();if(X>R){var g=Math.min(a,X);O+=V.substring(R,g);R=g;R>=a&&b&&hb()}var n=a;for(g=0;c&&--n>=R;){var h=V[n];if(" "!==h&&"\\n"!==h&&"\\t"!==h)break;"\\n"===h&&--c;++g}a-=g;a>R&&(c=Ra(V.substring(R,a)),O+=c);b&&hb();g&&(O+=V.substring(a,a+g));R=a+g}function ib(a){var b=a.l;a=a.n;var c=V.substring(b,b+a);Y(b,!1);O+="<i>"+Ra(c)+"</i>";Za=!0;R=b+a}function hb(){K.A&&(O+="</p>",K.A=!1)}
function db(){if(U.length){for(var a in T)J[a]=0,Ya[a]=0;do{for(;U.length;)ab||jb(),M=U.pop(),kb();N.forEach(function(b){var c=P(2,b.name,W,0,0);Ua(c,b)})}while(U.length)}}
function kb(){K.flags&64&&!Xa(M,N[N.length-1])&&!(-1<"br i pb v".indexOf(M.name))&&D(M);var a=M.l,b=M.n;if(R>a&&!M.p){var c;if((c=M.u)&&0<=N.indexOf(c)){Ua(P(2,c.name,R,Math.max(0,a+b-R),0),c);return}if("i"===M.name&&(a=a+b-R,0<a)){b=R;P(3,"i",b,Math.min(a,W-b),0);return}D(M)}if(!M.p)if("i"===M.name)ib(M);else if("br"===M.name)K.flags&1024||(Y(M.l,!1),O+="<br/>");else if("pb"===M.name)Y(M.l,!0);else if("v"===M.name)a=K.flags,K.flags=M.flags,Y(M.l+M.n,!1),K.flags=a;else if(M.q&1)if(a=M,b=a.name,c=
T[b],Ya[b]>=c.g)C.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.g}),D(a);else{var g=a,n=T[g.name];C.n=g;for(var h=0;h<n.d.length&&!g.p;++h)n.d[h](g,n);delete C.n;a.p||(J[b]>=c.f?(C.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.f}),D(a)):(c=T[b].j,K.e[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.q)||a.v||U.length&&Xa(U[U.length-1],a)||(b=new H(3,b,a.l,a.n),Ea(b,Wa(a)),b.flags=a.flags,a=b),gb(a),lb(a)):(b={tag:a,tagName:b},0<a.n?C.add("warn","Tag is not allowed in this context",
b):Ta("Tag is not allowed in this context",b),D(a))))}else mb()}
function mb(){var a=M;if(J[a.name]){for(var b=[],c=N.length;0<=--c;){var g=N[c];if(Xa(a,g))break;b.push(g);++L}if(0>c)Ta("Skipping end tag with no start tag",{tag:a});else{b.forEach(function(){});var n=0,h=[];b.forEach(function(k){var m=k.name;n&&(k.flags&2?h.push(k):n=!1);m=new H(2,m,a.l,0);m.flags=k.flags;gb(m);nb()});gb(a);nb();if(b.length&&1E4>L){g=R;for(c=U.length;0<=--c&&1E4>++L;){var l=U[c];if(l.l>g||l.q&1)break;for(var q=b.length;0<=--q&&1E4>++L;)if(Xa(l,b[q])){b.splice(q,1);h[q]&&h.splice(q,
1);g=Math.max(g,l.l+l.n);break}}g>R&&ib(new H(3,"i",R,g-R))}h.forEach(function(k){var m=P(k.q,k.name,R,0,k.x);Ea(m,Wa(k));(k=k.v)&&Ua(m,k)})}}}function nb(){var a=N.pop();--J[a.name];K=K.H}function lb(a){var b=a.name,c=a.flags,g=T[b];++Ya[b];if(3!==a.q){var n=[];K.e.forEach(function(l,q){c&512||(l=l&65280|l>>8);n.push(g.e[q]&l)});var h=c|K.flags&32;h&16&&(h&=-33);++J[b];N.push(a);K={H:K};K.e=n;K.flags=h}}
function P(a,b,c,g,n){a=new H(a,b,c,g,n||0);T[b]&&(a.flags=T[b].k.flags);if(!(T[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>c||c+g>W||/[\\uDC00-\\uDFFF]/.test(V.substring(c,c+1)+V.substring(c+g,c+g+1)))D(a);else if(T[b]&&T[b].w)C.add("warn","Tag is disabled",{tag:a,tagName:b}),D(a);else if(ab){b=U.length;for(c=ob(a);0<b&&c>ob(U[b-1]);)U[b]=U[b-1],--b;U[b]=a}else U.push(a);return a}
function jb(){for(var a={},b=[],c=U.length;0<=--c;){var g=U[c],n=ob(g,c);b.push(n);a[n]=g}b.sort();c=b.length;for(U=[];0<=--c;)U.push(a[b[c]]);ab=!0}function ob(a,b){var c=0<=a.x,g=a.x;c||(g+=1073741824);var n=0<a.n,h;n?h=W-a.n:h={2:0,3:1,1:2}[a.q];return pb(a.l)+ +c+pb(g)+ +n+pb(h)+pb(b||0)}function pb(a){a=a.toString(16);return"        ".substring(a.length)+a}var qb="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function rb(a){if(qb){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function sb(a,b){if(qb){var c=b.createElement("div");b=b.createDocumentFragment();Z.input=rb(a);Z.transform();for(c.innerHTML=Z.output;c.firstChild;)b.appendChild(c.firstChild);return b}return Z.transformToFragment(rb(a),b)}var Z,tb=rb(Ka);
if(qb){var ub=new ActiveXObject("MSXML2.XSLTemplate.6.0");ub.stylesheet=tb;Z=ub.createProcessor()}else Z=new XSLTProcessor,Z.importStylesheet(tb);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){Q[a]&&(Q[a].w=!0)},disableTag:function(a){T[a]&&(fb(a).w=!0)},enablePlugin:function(a){Q[a]&&(Q[a].w=!1)},enableTag:function(a){T[a]&&(fb(a).w=!1)},getLogger:function(){return C},parse:cb,preview:function(a,b){function c(l,q){var k=l.childNodes;q=q.childNodes;for(var m=k.length,x=q.length,A,I,y=0,G=0;y<m&&y<x;){A=k[y];I=q[y];if(!g(A,I))break;++y}for(var vb=Math.min(m-y,x-y);G<vb;){A=k[m-(G+1)];I=q[x-(G+1)];if(!g(A,I))break;++G}for(m-=G;--m>=y;)l.removeChild(k[m]),
h=l;k=x-G;if(!(y>=k)){x=n.createDocumentFragment();m=y;do I=q[m],h=x.appendChild(I);while(m<--k);G?l.insertBefore(x,l.childNodes[y]):l.appendChild(x)}}function g(l,q){if(l.nodeName!==q.nodeName||l.nodeType!==q.nodeType)return!1;if(l instanceof HTMLElement&&q instanceof HTMLElement){if(!l.isEqualNode(q)){for(var k=l.attributes,m=q.attributes,x=m.length,A=k.length,I=" "+l.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--A;){var y=k[A],G=y.namespaceURI;y=y.name;-1<I.indexOf(" "+y+" ")||q.hasAttributeNS(G,
y)||(l.removeAttributeNS(G,y),h=l)}for(A=x;0<=--A;)k=m[A],G=k.namespaceURI,y=k.name,k=k.value,-1<I.indexOf(" "+y+" ")||k===l.getAttributeNS(G,y)||(l.setAttributeNS(G,y,k),h=l);c(l,q)}}else 3!==l.nodeType&&8!==l.nodeType||l.nodeValue===q.nodeValue||(l.nodeValue=q.nodeValue,h=l);return!0}var n=b.ownerDocument;if(!n)throw"Target does not have a ownerDocument";a=sb(cb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),n);var h=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(l){var q=
document.createElement("script");var k=l.attributes;var m="undefined"!=typeof Symbol&&Symbol.iterator&&k[Symbol.iterator];k=m?m.call(k):{next:aa(k)};for(m=k.next();!m.done;m=k.next())m=m.value,q.setAttribute(m.name,m.value);q.textContent=l.textContent;l.parentNode.replaceChild(q,l)});c(b,a);return h},registeredVars:S,setNestingLimit:function(a,b){T[a]&&(fb(a).f=b)},setParameter:function(a,b){qb?Z.addParameter(a,b,""):Z.setParameter(null,a,b)},setTagLimit:function(a,b){T[a]&&(fb(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:174:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"acast.com";s:5:"acast";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.in";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:9:"anchor.fm";s:6:"anchor";s:18:"podcasts.apple.com";s:13:"applepodcasts";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:9:"audius.co";s:6:"audius";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:18:"bleacherreport.com";s:14:"bleacherreport";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:10:"castos.com";s:6:"castos";s:11:"cbsnews.com";s:7:"cbsnews";s:7:"clyp.it";s:4:"clyp";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:10:"codepen.io";s:7:"codepen";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:11:"falstad.com";s:7:"falstad";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:9:"giphy.com";s:5:"giphy";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:12:"jsfiddle.net";s:8:"jsfiddle";s:14:"jwplatform.com";s:10:"jwplatform";s:11:"kaltura.com";s:7:"kaltura";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"odysee.com";s:6:"odysee";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:10:"rumble.com";s:6:"rumble";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"streamja.com";s:8:"streamja";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:15:"tradingview.com";s:11:"tradingview";s:17:"traileraddict.com";s:13:"traileraddict";s:18:"mydailyfreedom.com";s:13:"trendingviews";s:16:"trendingviews.co";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:7:"voca.ro";s:7:"vocaroo";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:10:"wistia.com";s:6:"wistia";s:13:"worldstar.com";s:4:"wshh";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:12:"gameclips.io";s:9:"xboxclips";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:12:"youmaker.com";s:8:"youmaker";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:131:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:5:"acast";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:84:"@play\\.acast\\.com/s/(?\'show_id\'[-.\\w]+)/(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"show_id";i:2;s:10:"episode_id";i:3;s:1:"t";}}i:1;a:2:{i:0;s:97:"@shows\\.acast\\.com/(?\'show_id\'[-.\\w]+)/(?:episodes/)?(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;R:199;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:34:"@"showId":"(?\'show_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}i:1;a:2:{i:0;s:33:"@"id":"(?\'episode_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}s:5:"match";a:2:{i:0;a:2:{i:0;s:30:"@play\\.acast\\.com/s/[-.\\w]+/.@";i:1;a:1:{i:0;s:0:"";}}i:1;a:2:{i:0;s:29:"@shows\\.acast\\.com/[-.\\w]+/.@";i:1;R:222;}}s:3:"url";s:71:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}";}}}s:6:"amazon";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;R:191;}i:1;a:2:{i:0;s:50:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#";i:1;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}}i:1;R:194;}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@anchor.fm/(?:[-\\w]+/)*?episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:191;}}i:1;R:194;}s:13:"applepodcasts";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:101:"@podcasts\\.apple\\.com/(?\'country\'\\w+)/podcast/[-\\w]*/id(?\'podcast_id\'\\d+)(?:\\?i=(?\'episode_id\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"country";i:2;s:10:"podcast_id";i:3;s:10:"episode_id";}}}i:1;R:194;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:9:"audiomack";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:71:"!audiomack\\.com/(?\'mode\'album|song)/(?\'artist\'[-\\w]+)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:6:"artist";i:3;s:5:"title";}}i:1;a:2:{i:0;s:71:"!audiomack\\.com/(?\'artist\'[-\\w]+)/(?\'mode\'album|song)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:6:"artist";i:2;s:4:"mode";i:3;s:5:"title";}}}i:1;R:194;}s:6:"audius";a:2:{i:0;R:194;i:1;a:3:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'track_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:75:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/(?!album/|playlist/)(?\'slug\'[%\\-.\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"slug";}}}s:3:"url";s:94:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}";}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'album_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:61:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/album/(?\'slug\'[%\\-.\\w]+)@";i:1;R:281;}}s:3:"url";s:100:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}";}i:2;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!"id"\\s*:\\s*"(?\'playlist_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:64:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/playlist/(?\'slug\'[%\\-.\\w]+)@";i:1;R:281;}}s:3:"url";s:103:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}";}}}s:8:"bandcamp";a:2:{i:0;R:194;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;R:290;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;R:222;}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:290;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;R:275;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:222;}}}}}s:7:"bbcnews";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:67:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/(?:\\w+-)+(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:68:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/embed/(?\'id\'\\w+/\\d+)@";i:1;R:191;}i:2;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/\\w+/(?\'id\'\\d+)@";i:1;R:191;}i:3;a:2:{i:0;s:45:"@bbc\\.co(?:m|\\.uk)/news/av-embeds/(?\'id\'\\d+)@";i:1;R:191;}}i:1;R:194;}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"@bitchute\\.com/(?:embed|video)/(?\'id\'[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:14:"bleacherreport";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:1;R:191;}i:1;a:2:{i:0;s:31:"!video_embed\\?id=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!/articles/.!";i:1;R:222;}}}}}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:194;}s:6:"castos";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:48:"@(?\'host\'[-\\w]+)\\.castos\\.com/player/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"host";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:372;s:5:"match";a:1:{i:0;a:2:{i:0;s:45:"@castos\\.com/(?:podcasts/[^/]*+/)?episodes/.@";i:1;R:222;}}}}}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:191;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:4:"clyp";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"@clyp\\.it/(?!user/)(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:222;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:191;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:191;}}i:1;R:194;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:191;}}i:1;R:194;}s:7:"codepen";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"!codepen\\.io/(?\'user\'[-\\w]+)/(?:details|embed|full|live|pen)/(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:194;}s:13:"comedycentral";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:222;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:191;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:191;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:194;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:222;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!dumpert\\.nl/(?:item|mediabase)/(?\'id\'\\d+[/_]\\w+)!";i:1;R:191;}}i:1;R:194;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:222;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:8:"facebook";a:2:{i:0;a:5:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:191;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:492;}i:4;a:2:{i:0;s:53:"@facebook.com/groups/[^/]*/(?\'type\'p)osts/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;R:499;}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:222;}}}}}s:7:"falstad";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:81:"!falstad\\.com/circuit/circuitjs\\.html\\?c(?:ct=(?\'cct\'[^&]+)|tz=(?\'ctz\'[-+=\\w]+))!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"cct";i:2;s:3:"ctz";}}}i:1;R:194;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:529;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:191;}}i:1;R:194;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:191;}}i:1;R:194;}s:5:"getty";a:2:{i:0;R:194;i:1;a:1:{i:0;a:3:{s:7:"extract";a:5:{i:0;a:2:{i:0;s:19:"!/embed/(?\'id\'\\d+)!";i:1;R:191;}i:1;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:2;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:3;a:2:{i:0;s:21:"!\\?et=(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:4;a:2:{i:0;s:28:"!\\\\u0026sig=(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:59:"!(?:gty\\.im|gettyimages\\.[.\\w]+/detail(?=/).*?)/(?\'id\'\\d+)!";i:1;R:191;}}s:3:"url";s:43:"https://embed.gettyimages.com/preview/{@id}";}}}s:6:"gfycat";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?(?\'id\'\\w+)#";i:1;R:191;}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:17:"!/ifr/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:87:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?[a-z]#";i:1;R:222;}}s:3:"url";s:28:"https://gfycat.com/ifr/{@id}";}i:1;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!"height":(?\'height\'\\d+)!";i:1;R:563;}i:1;a:2:{i:0;s:23:"!"width":(?\'width\'\\d+)!";i:1;R:568;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:222;}}s:3:"url";s:61:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:568;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:563;}}s:5:"match";R:604;s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:5:"giphy";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:62:"!giphy\\.com/(?\'type\'gif|video|webp)\\w+/(?:[-\\w]+-)*(?\'id\'\\w+)!";i:1;R:499;}i:1;a:2:{i:0;s:52:"!giphy\\.com/media/(?\'id\'\\w+)/\\w+\\.(?\'type\'gif|webp)!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"type";}}i:2;a:2:{i:0;s:45:"!i\\.giphy\\.com/(?\'id\'\\w+)\\.(?\'type\'gif|webp)!";i:1;R:626;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!"height"\\s*:\\s*(?\'height\'\\d+)!";i:1;R:563;}i:1;a:2:{i:0;s:29:"!"width"\\s*:\\s*(?\'width\'\\d+)!";i:1;R:568;}}s:5:"match";R:604;s:3:"url";s:83:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:75:"@gist\\.github\\.com/(?\'id\'(?:[-\\w]+/)?[\\da-f]+(?:/[\\da-f]+)?\\b(?!/archive))@";i:1;R:191;}}i:1;R:194;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:645;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:222;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:191;}}i:1;R:194;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:194;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:191;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:492;}}i:1;R:194;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:690;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:694;i:1;R:696;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:222;}}}}}s:4:"hulu";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:222;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:191;}}i:1;R:194;}s:4:"imdb";a:2:{i:0;R:194;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:45:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)/[/\\w]*?embed!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:32:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)!";i:1;R:191;}}s:3:"url";s:50:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed";}}}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:191;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:191;}i:2;a:2:{i:0;s:33:"@imgur\\.com/(?\'id\'\\w+)(?![\\w./])@";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!instagram\\.com/(?:p|reel|tv)/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:15:"internetarchive";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:191;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:568;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:563;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:222;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"jsfiddle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:96:"@jsfiddle.net/(?:(?\'user\'\\w+)/)?(?!\\d+\\b|embedded\\b|show\\b)(?\'id\'\\w+)\\b(?:/(?\'revision\'\\d+)\\b)?@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";i:3;s:8:"revision";}}}i:1;R:194;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:7:"kaltura";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:38:"@/p(?:artner_id)?/(?\'partner_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"partner_id";}}i:1;a:2:{i:0;s:17:"@/sp/(?\'sp\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:2:"sp";}}i:2;a:2:{i:0;s:31:"@/uiconf_id/(?\'uiconf_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:9:"uiconf_id";}}i:3;a:2:{i:0;s:32:"@\\bentry_id[=/](?\'entry_id\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:8:"entry_id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:113:"@kaltura\\.com/+p/(?\'partner_id\'\\d+)/sp/(?\'sp\'\\d+)/\\w*/uiconf_id/(?\'uiconf_id\'\\d+)/.*?\\bentry_id=(?\'entry_id\'\\w+)@";i:1;a:5:{i:0;s:0:"";i:1;s:10:"partner_id";i:2;s:2:"sp";i:3;s:9:"uiconf_id";i:4;s:8:"entry_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"@kaltura\\.com/(?:media/t|tiny)/.@";i:1;R:222;}}}}}s:3:"khl";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:222;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:194;}s:6:"libsyn";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:222;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:222;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:864;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:222;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:875;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:222;}}}}}s:6:"mailru";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:222;}}}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"#medium\\.com/(?:s/\\w+/|@?[-\\w]+/)?(?:\\w+-)*(?\'id\'[0-9a-f]+)(?!\\w)#";i:1;R:191;}}i:1;R:194;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:191;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:191;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:191;}}i:1;R:194;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:5:"mrctv";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:222;}}}}}s:5:"msnbc";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:40:"@embedded-video/(?!undefined)(?\'id\'\\w+)@";i:1;R:191;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:222;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:222;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:11:"natgeovideo";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:222;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:9:"nbcsports";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!select/media/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;R:222;}}}}}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:194;}s:3:"npr";a:2:{i:0;R:194;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:222;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:222;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:191;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"odysee";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"#odysee\\.com/(?:\\$/\\w+/)?(?\'name\'[^:/]+)[:/](?\'id\'\\w{40})#";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:52:"#odysee\\.com/\\$/embed/(?\'name\'[^:/]+)/(?\'id\'\\w{40})#";i:1;R:1019;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"#odysee\\.com/@[^/:]+:\\w+/.#";i:1;R:222;}}}}}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:290;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;R:301;}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:275;}}i:1;R:194;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"!podbean\\.com/(?:[-\\w]+/)*(?:player[-\\w]*/|\\w+/pb-)(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"!podbean\\.com/player[^/]*/\\?i=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:222;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:191;}}i:1;R:194;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:191;}}i:1;R:194;}s:6:"rumble";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rumble\\.com/embed/(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:21:"!video"?:"(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"#rumble\\.com/(?!embed/).#";i:1;R:222;}}}}}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!rutube\\.ru/(?:play/embed|tracks)/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";i:1;R:191;}}s:6:"header";s:110:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.0.0 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"!rutube\\.ru/video/(?\'vid\'[0-9a-f]{32})!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}s:3:"url";s:65:"https://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/";}}}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!"presentationId":(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:222;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:191;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:301;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:275;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:222;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:301;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:30:"@soundcloud\\.com/[-\\w]+/sets/@";i:1;R:222;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:222;}}}}}s:9:"sportsnet";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"@bc_videos\\s*:\\s*(?\'id\'\\d+)@";i:1;R:191;}}s:5:"match";R:604;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1176;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:222;}}}}}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;R:216;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:216;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;R:211;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!(?\'url\'.+/(?:show/|user/.+/).+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"url";}}}s:3:"url";s:54:"https://api.spreaker.com/oembed?format=json&url={@url}";}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"stitcher";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!/(?:embed|splayer/f)/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"fid";i:2;s:3:"eid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:32:"!/embed/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;R:1211;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!/(?:podcast/|show/|s\\?)!";i:1;R:222;}}}}}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!streamable\\.com/(?:e/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:8:"streamja";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@streamja\\.com/(?!login|signup|terms|videos)(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:222;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:191;}}i:1;R:194;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"@//t.me/(?!addstickers/|joinchat/)(?\'id\'\\w+/\\d+)@";i:1;R:191;}}i:1;R:194;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:191;}}i:1;R:194;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:61:"#tiktok\\.com/(?:@[.\\w]+/video|v|i18n/share/video)/(?\'id\'\\d+)#";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:1268;s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"#//vm\\.tiktok\\.com/.#";i:1;R:222;}}}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:11:"tradingview";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!tradingview\\.com/(?:chart/[^/]+|i)/(?\'chart\'\\w+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"chart";}}i:1;a:2:{i:0;s:45:"!tradingview\\.com/symbols/(?\'symbol\'[-:\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"symbol";}}}i:1;R:194;}s:13:"traileraddict";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:222;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:89:"!(?:mydailyfreedom\\.com|trendingviews\\.co)/(?:tv/)?(?:embed|video)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:6:"tumblr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;R:1019;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:27:"!did=\\\\u0022(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:31:"!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}s:6:"header";s:16:"User-agent: curl";s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:222;}}s:3:"url";s:75:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!247sports\\.com/PlayerSport/[-\\w]*?(?\'player_id\'\\d+)/Embed!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";R:1328;s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!247sports\\.com/Player/[-\\w]*?\\d!";i:1;R:222;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:38:"!embedVideoContainer_(?\'video_id\'\\d+)!";i:1;R:870;}}s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!247sports\\.com/Video/.!";i:1;R:222;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:870;}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;R:875;}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:445;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:875;}}i:1;R:194;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:191;}}i:1;R:194;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;R:1099;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:222;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:191;}}i:1;R:194;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:194;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:67:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)(?:/(?\'h\'\\w+))?\\b!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"h";}}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:445;}}i:1;R:194;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:191;}}i:1;R:194;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1415;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:99:"#meta property="og:video" content=".*?oid=(?\'oid\'-?\\d+).*?id=(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)#";i:1;R:1415;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:15:"#^(?!.*?hash=)#";i:1;R:222;}}}}}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!voca(?:\\.ro|roo\\.com)/(?:i/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:191;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:191;}}i:1;R:194;}s:6:"wistia";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:33:"!"type":"(?:\\w+_)?(?\'type\'audio)!";i:1;R:492;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:55:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)\\w!";i:1;R:222;}}s:3:"url";s:42:"https://fast.wistia.net/embed/iframe/{@id}";}}}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!worldstar(?:hiphop)?\\.com/(?:emb|featur)ed/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:55:"!(?:v: ?"?|worldstar(?:hiphop)?\\.com/embed/)(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:54:"!worldstar(?:hiphop)?\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:222;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:222;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"@(?:gameclips\\.io|xboxclips\\.com)/(?!game/)(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;R:420;}}i:1;R:194;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:420;}}i:1;R:194;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:191;}}i:1;R:194;}s:8:"youmaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!youmaker\\.com/(?:embed|v(?:ideo)?)/(?\'id\'[-a-z0-9]+)!i";i:1;R:191;}}i:1;R:194;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:77:"!youtube\\.com/(?:watch.*?v=|shorts/|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:191;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:191;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:445;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;R:194;}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:132:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:194;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:5:"ACAST";a:7:{s:10:"attributes";a:3:{s:10:"episode_id";R:1520;s:7:"show_id";R:1520;s:1:"t";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"AMAZON";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:8:"required";b:1;s:11:"filterChain";R:194;}s:3:"tld";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"ANCHOR";R:1518;s:13:"APPLEPODCASTS";a:7:{s:10:"attributes";a:3:{s:7:"country";R:1520;s:10:"episode_id";R:1520;s:10:"podcast_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:9:"AUDIOBOOM";R:1518;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:3:{s:6:"artist";R:1520;s:4:"mode";R:1520;s:5:"title";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"AUDIUS";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1520;s:11:"playlist_id";R:1520;s:8:"track_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1520;s:8:"track_id";R:1520;s:9:"track_num";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"BBCNEWS";R:1518;s:8:"BITCHUTE";R:1518;s:14:"BLEACHERREPORT";R:1518;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1520;s:5:"bcpid";R:1520;s:5:"bctid";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"CASTOS";a:7:{s:10:"attributes";a:2:{s:4:"host";R:1520;s:2:"id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"CBSNEWS";R:1518;s:4:"CLYP";R:1518;s:4:"CNBC";R:1518;s:3:"CNN";R:1518;s:8:"CNNMONEY";R:1518;s:7:"CODEPEN";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1520;s:4:"user";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:13:"COMEDYCENTRAL";R:1518;s:4:"COUB";R:1518;s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1520;s:1:"t";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:12:"DEMOCRACYNOW";R:1518;s:7:"DUMPERT";R:1518;s:11:"EIGHTTRACKS";R:1518;s:4:"ESPN";R:1518;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1520;s:4:"type";R:1520;s:4:"user";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"FALSTAD";a:7:{s:10:"attributes";a:2:{s:3:"cct";R:1520;s:3:"ctz";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"FLICKR";R:1518;s:7:"FOXNEWS";R:1518;s:10:"FUNNYORDIE";R:1518;s:8:"GAMESPOT";R:1518;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";R:1544;s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:2:"id";R:1520;s:3:"sig";R:1544;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1603;s:8:"required";b:0;}}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"GFYCAT";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1601;s:2:"id";R:1520;s:5:"width";R:1609;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"GIFS";R:1615;s:5:"GIPHY";a:7:{s:10:"attributes";a:4:{s:6:"height";R:1601;s:2:"id";R:1520;s:4:"type";R:1520;s:5:"width";R:1609;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"GIST";R:1518;s:10:"GLOBALNEWS";R:1518;s:8:"GOFUNDME";R:1518;s:11:"GOOGLEDRIVE";R:1518;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1606;}}s:8:"required";b:0;}s:3:"oid";R:1520;s:3:"pid";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1520;s:2:"id";R:1520;s:3:"oid";R:1520;s:4:"type";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1520;s:9:"highlight";R:1520;s:2:"id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"HULU";R:1518;s:3:"IGN";R:1518;s:4:"IMDB";R:1518;s:5:"IMGUR";R:1518;s:9:"INDIEGOGO";R:1518;s:9:"INSTAGRAM";R:1518;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1601;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1606;}}s:8:"required";b:0;}s:5:"width";R:1609;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:8:"IZLESENE";R:1518;s:8:"JSFIDDLE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1520;s:8:"revision";R:1520;s:4:"user";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:10:"JWPLATFORM";R:1518;s:7:"KALTURA";a:7:{s:10:"attributes";a:4:{s:8:"entry_id";R:1544;s:10:"partner_id";R:1544;s:2:"sp";R:1520;s:9:"uiconf_id";R:1544;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:3:"KHL";R:1518;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1520;s:2:"id";R:1520;s:5:"video";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"LIBSYN";R:1518;s:8:"LIVELEAK";R:1518;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1520;s:7:"channel";R:1520;s:7:"clip_id";R:1520;s:8:"event_id";R:1520;s:8:"video_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"MAILRU";R:1518;s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:194;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1518;s:9:"MEGAPHONE";R:1518;s:8:"METACAFE";R:1518;s:8:"MIXCLOUD";R:1518;s:3:"MLB";R:1518;s:5:"MRCTV";R:1518;s:5:"MSNBC";R:1518;s:13:"NATGEOCHANNEL";R:1518;s:11:"NATGEOVIDEO";R:1518;s:7:"NBCNEWS";R:1518;s:9:"NBCSPORTS";R:1518;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1520;s:1:"t";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1520;s:1:"m";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"NYTIMES";R:1518;s:6:"ODYSEE";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1520;s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:0;}}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1520;s:11:"playlist_id";R:1520;s:6:"set_id";R:1520;s:8:"track_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:8:"PASTEBIN";R:1518;s:9:"PINTEREST";R:1518;s:7:"PODBEAN";R:1518;s:5:"PREZI";R:1518;s:6:"REDDIT";R:1518;s:6:"RUMBLE";R:1518;s:6:"RUTUBE";R:1518;s:6:"SCRIBD";R:1518;s:7:"SENDVID";R:1518;s:10:"SLIDESHARE";R:1518;s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1520;s:11:"playlist_id";R:1520;s:12:"secret_token";R:1520;s:8:"track_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"SPORCLE";R:1518;s:9:"SPORTSNET";R:1518;s:7:"SPOTIFY";R:1518;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1520;s:7:"show_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:10:"STEAMSTORE";R:1518;s:8:"STITCHER";a:7:{s:10:"attributes";a:2:{s:3:"eid";R:1520;s:3:"fid";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:9:"STRAWPOLL";R:1518;s:10:"STREAMABLE";R:1518;s:8:"STREAMJA";R:1518;s:8:"TEAMCOCO";R:1518;s:3:"TED";R:1518;s:8:"TELEGRAM";R:1518;s:11:"THEATLANTIC";R:1518;s:11:"THEGUARDIAN";R:1518;s:8:"THEONION";R:1518;s:6:"TIKTOK";R:1518;s:3:"TMZ";R:1518;s:11:"TRADINGVIEW";a:7:{s:10:"attributes";a:2:{s:5:"chart";R:1520;s:6:"symbol";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:13:"TRAILERADDICT";R:1518;s:13:"TRENDINGVIEWS";R:1518;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1520;s:2:"id";R:1520;s:3:"key";R:1520;s:4:"name";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:2:{s:9:"player_id";R:1520;s:8:"video_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1520;s:7:"clip_id";R:1520;s:1:"t";R:1520;s:8:"video_id";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"TWITTER";R:1518;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1520;s:3:"vid";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:5:"VBOX7";R:1518;s:4:"VEOH";R:1518;s:4:"VEVO";R:1518;s:14:"VIDEODETECTIVE";R:1518;s:5:"VIMEO";a:7:{s:10:"attributes";a:3:{s:1:"h";R:1520;s:2:"id";R:1520;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1606;}}s:8:"required";b:0;}}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"VINE";R:1518;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1520;s:3:"oid";R:1520;s:3:"vid";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:7:"VOCAROO";R:1518;s:3:"VOX";R:1518;s:14:"WASHINGTONPOST";R:1518;s:6:"WISTIA";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1520;s:4:"type";R:1520;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}s:4:"WSHH";R:1518;s:3:"WSJ";R:1518;s:9:"XBOXCLIPS";R:1579;s:7:"XBOXDVR";R:1579;s:5:"YOUKU";R:1518;s:8:"YOUMAKER";R:1518;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:1520;s:1:"t";R:1763;}s:11:"filterChain";R:1522;s:12:"nestingLimit";i:10;s:5:"rules";R:1531;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1535;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:10:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IN";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";s:16:"MEDIAEMBED_THEME";s:0:"";}}');
	}
}