<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2022 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
class s9e_renderer_544e1b2c8a1e5ccc5f89365591ae1d5dfbc0b189 extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['L_CODE'=>'','L_COLON'=>'','L_IMAGE'=>'','L_SELECT_ALL_CODE'=>'','L_WROTE'=>'','S_VIEWFLASH'=>'','S_VIEWIMG'=>'','S_VIEWSMILIES'=>'','T_SMILIES_PATH'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ACAD':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'&amp;autostart=false" width="400" height="300" frameborder="0" scrolling="no" class="float_left_webcast"></iframe>';break;case'ACAST':$this->out.='<iframe title="Embed Player" width="100%" height="188px" src="https://embed.acast.com/'.htmlspecialchars($node->textContent,2).'" scrolling="no" frameborder="0" style="border:none;overflow:hidden"></iframe>';break;case'AKAD':$this->out.='<iframe width="560" height="315" src="//embedftv-a.akamaihd.net/%7BTEXT%5D" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'ALTER':$this->out.='<iframe width="684" height="667" frameborder="0" src="https://www.alternatives-economiques.fr/embed/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'API':$this->out.='<iframe frameborder="0" width="640" height="360" src="'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'APO':case'FR3':case'SOIR3':case'TVINFO':$this->out.='<iframe frameborder="0" width="640" height="360" src="http://api.dmcloud.net/player/embed/'.htmlspecialchars($node->textContent,2).'?exported=1"></iframe>';break;case'ARD':$this->out.='<iframe src="https://www.ardmediathek.de/embed/'.htmlspecialchars($node->textContent,2).'" width="640" height="420" allowfullscreen="" frameborder="0" scrolling="no"></iframe>';break;case'ARTE':$this->out.='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" id="playerArte" allowscriptaccess="always" width="450" height="303"><param name="allowFullScreen" value="true"><param name="allowScriptAccess" value="always"><param name="quality" value="high"><param name="movie" value="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl='.htmlspecialchars($node->textContent,2).'&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false"><embed src="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Ffr%2Fdo%5Fdelegate%2Fvideos%2Fray%2Dkurzweil%2Dqu%2Dest%2Dce%2Dque%2Dla%2Dsingularite%2D%2D4157746%2Cview%2CasPlayerXml%2Exml&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false" width="450" height="303" allowfullscreen="true" name="playerArte" quality="high" allowscriptaccess="always" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></object>';break;case'ARTE7':$this->out.='<script type="text/javascript" src="https://www-secure.arte.tv/arte_vp/embed.php?json_url=http%3A%2F%2Fconcert.arte.tv%2Ffr%2Fplayer%2F'.htmlspecialchars($node->textContent,2).'&amp;lang=fr_FR&amp;config=arte_concert&amp;width=720&amp;height=406"></script>';break;case'ATTACHMENT':$this->out.='<div class="inline-attachment"><!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' -->'.htmlspecialchars($node->getAttribute('filename'),0).'<!-- ia'.htmlspecialchars($node->getAttribute('index'),0).' --></div>';break;case'ATTV':$this->out.='<iframe src="https://vp.telvue.com/player?id=T03105&amp;video='.htmlspecialchars($node->textContent,2).'&amp;mini=true" width="400" height="300" marginwidth="0" marginheight="0" hpsace="0" vspace="0" frameborder="1" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'AUSHA':$this->out.='<iframe frameborder="0" loading="lazy" id="'.htmlspecialchars($node->textContent,2).'" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId=bzPxksVdjQnD&amp;v=3&amp;playerId=ausha-WWk4"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'B':$this->out.='<strong class="text-strong">';$this->at($node);$this->out.='</strong>';break;case'BBC':$this->out.='<iframe width="400" height="500" frameborder="0" src="https://www.bbc.com/news/av/embed/p080qwnv/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'BBC4':$this->out.='<iframe width="400" height="500" frameborder="0" src="http://www.bbc.co.uk/programmes/'.htmlspecialchars($node->textContent,2).'/player"></iframe>';break;case'BCOVE':$this->out.='<iframe src="https://players.brightcove.net/45228659001/rkPdEdoaW_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFIG':$this->out.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFM':$this->out.='<div style="display:block;position:relative"><div style="padding-top:56.25%"><iframe src="'.htmlspecialchars($node->textContent,2).'" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" style="width:100%;height:100%;position:absolute;top:0;bottom:0;right:0;left:0;border:none"></iframe></div></div>';break;case'BM':$this->out.='<iframe src="http://donnees.banquemondiale.org/share/widget?indicators='.htmlspecialchars($node->textContent,2).'" width="450" height="300" frameborder="0" scrolling="no"></iframe>';break;case'CALAMEO':$this->out.='<iframe src="//v.calameo.com/?bkcode='.htmlspecialchars($node->textContent,2).'" width="900" height="582" frameborder="0" scrolling="no" allowtransparency="" allowfullscreen="" style="margin:0 auto"></iframe>';break;case'CANAL':$this->out.='<div><iframe width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=cplus&amp;vid='.htmlspecialchars($node->textContent,2).'"></iframe></div>';break;case'CANAL-U':$this->out.='<div style="position:relative;padding-bottom:56.25%;padding-top:10px;height:0;overflow:hidden"><iframe src="https://www.canal-u.tv/video/cerimes/embed.1/'.htmlspecialchars($node->textContent,2).'?width=100%25&amp;height=100%25" style="position:absolute;top:0;left:0;width:100%;height:100%" width="550" height="306" frameborder="0" allowfullscreen="" scrolling="no"></iframe></div>';break;case'CDF':$this->out.='<embed src="http://www.mariamagdalenakaczor.eu/mediaplayer/player.swf" height="560" width="745" allowscriptaccess="always" allowfullscreen="true" flashvars="&amp;controlbar=over&amp;item='.htmlspecialchars($node->textContent,2).'&amp;playlistfile=http%3A%2F%2Fwww.mariamagdalenakaczor.eu%2Fmediapayer%2Fplaylist.xml&amp;plugins=viral-2d">';break;case'CDN':$this->out.='<iframe src="//cdn.jwplayer.com/players/'.htmlspecialchars($node->textContent,2).'" width="640" height="360" frameborder="0" scrolling="auto"></iframe>';break;case'CHART':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART1':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART2':$this->out.='<iframe src="https://ourworldindata.org/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=2020-12-20..latest&amp;country=USA~DEU~GBR~FRA~ISR~ITA~ESP&amp;region=World&amp;vaccinationsMetric=true&amp;interval=total&amp;perCapita=true&amp;smoothing=0&amp;pickerMetric=total_vaccinations_per_hundred&amp;pickerSort=desc" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART3':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-12-20..latest&amp;pickerSort=asc&amp;pickerMetric=location&amp;Metric=Vaccine+doses&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTCO2':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;country=FRA~DEU~NLD~POL~EU-27&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNDL':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=earliest..latest&amp;country=~NLD&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNEWDEATHS':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=GBR~FRA~USA~BRA~IND~MEX~RUS~ITA&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTTOTALDEATH':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~GBR~FRA~BRA~HUN" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CODE':$this->out.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';$this->at($node);$this->out.='</code></pre></div>';break;case'COLOR':$this->out.='<span style="color:'.htmlspecialchars($node->getAttribute('color'),2).'">';$this->at($node);$this->out.='</span>';break;case'CULT':$this->out.='<iframe src="http://www.franceculture.fr/player/export-reecouter?content='.htmlspecialchars($node->textContent,2).'" width="481" frameborder="0" scrolling="no" height="139"></iframe>';break;case'DATA':$this->out.='<div class="flourish-embed flourish-bar-chart-race" data-src="visualisation/'.htmlspecialchars($node->textContent,2).'" data-url="https://flo.uri.sh/visualisation/'.htmlspecialchars($node->textContent,2).'/embed"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'DC':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DD':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DDC':$this->out.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Color+by+test+positivity=false&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DEB':$this->out.='<iframe width="480" height="270" style="width:480px;height:270px" src="http://mediaspip.ptitdeb.infini.fr/spip.php?page=embed_code&amp;id_objet='.htmlspecialchars($node->textContent,2).'&amp;objet=document&amp;largeur=480&amp;hauteur=270" frameborder="0" allowfullscreen=""></iframe>';break;case'DEW':$this->out.='<audio controls=""><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/ogg"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/mpeg"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="audio/wav"></audio>';break;case'DH':$this->out.='<iframe src="https://ourworldindata.org/grapher/weekly-hospital-admissions-covid?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DMOTION':$this->out.='<iframe frameborder="0" width="480" height="270" src="https://www.dailymotion.com/embed/video/'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'DOCGOOGLE':$this->out.='<iframe src="https://docs.google.com/file/d/'.htmlspecialchars($node->textContent,2).'/preview" width="640" height="480"></iframe>';break;case'DOCPLAYER':$this->out.='<div><div><a target="_blank" href="'.htmlspecialchars($node->textContent,2).'" rel="noreferrer"></a></div><div><iframe frameborder="0" style="border-bottom:2px solid #eee;border-top:0" scrolling="no" src="http://docplayer.fr/docview/112/202650701/" width="728" height="1040" allowfullscreen=""></iframe></div></div>';break;case'DR':$this->out.='<iframe src="https://ourworldindata.org/grapher/current-covid-patients-icu?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'E':if($this->params['S_VIEWSMILIES']==='')$this->out.=htmlspecialchars($node->textContent,0);else{switch($node->textContent){case'8-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="17" alt="8-)" title="Cool">';break;case':!:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_exclaim.gif" width="15" height="17" alt=":!:" title="Exclamation">';break;case':(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":(" title="Triste">';break;case':)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":)" title="Sourire">';break;case':-(':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":-(" title="Triste">';break;case':-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":-)" title="Sourire">';break;case':-?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":-?" title="Confus">';break;case':-D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":-D" title="Très content">';break;case':-P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":-P" title="Tire la langue">';break;case':-o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":-o" title="Surprise">';break;case':-x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":-x" title="Fou">';break;case':-|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="17" alt=":-|" title="Neutre">';break;case':?':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":?" title="Confus">';break;case':?:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_question.gif" width="15" height="17" alt=":?:" title="Question">';break;case':???:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_confused.gif" width="15" height="17" alt=":???:" title="Confus">';break;case':D':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":D" title="Très content">';break;case':P':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":P" title="Tire la langue">';break;case':arrow:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_arrow.gif" width="15" height="17" alt=":arrow:" title="Flèche">';break;case':cool:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cool.gif" width="15" height="17" alt=":cool:" title="Cool">';break;case':cry:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_cry.gif" width="15" height="17" alt=":cry:" title="Très triste, en pleurs">';break;case':eek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":eek:" title="Surprise">';break;case':evil:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_evil.gif" width="15" height="17" alt=":evil:" title="Diable">';break;case':geek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_geek.gif" width="17" height="17" alt=":geek:" title="Geek">';break;case':grin:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_biggrin.gif" width="15" height="17" alt=":grin:" title="Très content">';break;case':idea:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_idea.gif" width="15" height="17" alt=":idea:" title="Idée">';break;case':lol:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_lol.gif" width="15" height="17" alt=":lol:" title="Rire">';break;case':mad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":mad:" title="Fou">';break;case':mrgreen:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mrgreen.gif" width="15" height="17" alt=":mrgreen:" title="M. Vert">';break;case':o':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_surprised.gif" width="15" height="17" alt=":o" title="Surprise">';break;case':oops:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_redface.gif" width="15" height="17" alt=":oops:" title="Embarrassé">';break;case':razz:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_razz.gif" width="15" height="17" alt=":razz:" title="Tire la langue">';break;case':roll:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_rolleyes.gif" width="15" height="17" alt=":roll:" title="Yeux tournants">';break;case':sad:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_sad.gif" width="15" height="17" alt=":sad:" title="Triste">';break;case':shock:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_eek.gif" width="15" height="17" alt=":shock:" title="Choqué">';break;case':smile:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_smile.gif" width="15" height="17" alt=":smile:" title="Sourire">';break;case':twisted:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_twisted.gif" width="15" height="17" alt=":twisted:" title="Diable rieur">';break;case':ugeek:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_ugeek.gif" width="17" height="18" alt=":ugeek:" title="Geek barbu">';break;case':wink:':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=":wink:" title="Clin d’œil">';break;case':x':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_mad.gif" width="15" height="17" alt=":x" title="Fou">';break;case':|':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_neutral.gif" width="15" height="17" alt=":|" title="Neutre">';break;case';)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=";)" title="Clin d’œil">';break;case';-)':$this->out.='<img class="smilies" src="'.htmlspecialchars($this->params['T_SMILIES_PATH'],2).'/icon_e_wink.gif" width="15" height="17" alt=";-)" title="Clin d’œil">';break;default:$this->out.=htmlspecialchars($node->textContent,0);}}break;case'ECHOS':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01578907/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="480" height="400" allow="autoplay; fullscreen"></iframe>';break;case'ED':$this->out.='<iframe src="https://ourworldindata.org/grapher/excess-deaths-cumulative-economist-who?country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EDV':$this->out.='<iframe src="https://ourworldindata.org/grapher/life-expectancy?tab=chart&amp;time=earliest..2019&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EMAIL':$this->out.='<a href="mailto:'.htmlspecialchars($node->getAttribute('email'),2);if($node->hasAttribute('subject')||$node->hasAttribute('body')){$this->out.='?';if($node->hasAttribute('subject'))$this->out.='subject='.htmlspecialchars($node->getAttribute('subject'),2);if($node->hasAttribute('body')){if($node->hasAttribute('subject'))$this->out.='&amp;';$this->out.='body='.htmlspecialchars($node->getAttribute('body'),2);}}$this->out.='">';$this->at($node);$this->out.='</a>';break;case'EMOJI':if($this->params['S_VIEWSMILIES']!==''){$this->out.='<img alt="'.htmlspecialchars($node->textContent,2).'" class="emoji smilies" draggable="false" src="//cdn.jsdelivr.net/gh/twitter/twemoji@latest/assets/svg/';if($node->hasAttribute('tseq'))$this->out.=htmlspecialchars($node->getAttribute('tseq'),2);else$this->out.=htmlspecialchars($node->getAttribute('seq'),2);$this->out.='.svg">';}else$this->out.=htmlspecialchars($node->textContent,0);break;case'ENS':$this->out.='<div id="jwplayer">Loading the player...</div><script type="text/javascript">
	        jwplayer("jwplayer").setup({
	        playlist: [{
	        		poster: "http://savoirs.ens.fr/images/accueil_video_savoirs.jpg",
	                image: "http://savoirs.ens.fr/images/accueil_video_savoirs.jpg",
	                sources: [{ 
	                    file: "rtmp://91.121.116.112:1935/vod/mp4:/diffusion/';$this->at($node);$this->out.='"
	                },{
	                    file: "./uploads/videos//diffusion/';$this->at($node);$this->out.='",
	                }]
	         }],
	        height: 360,
	        primary: "flash",
	        width: 640
	        });
		</script>';break;case'EUR1':$this->out.='<iframe src="https://www.europe1.fr/videos/embed/'.htmlspecialchars($node->textContent,2).'" width="734px" height="406px"></iframe>';break;case'EUROSTAT':$this->out.='<iframe width="964" height="462" src="https://ec.europa.eu/eurostat/statistics-explained/index.php?'.htmlspecialchars($node->textContent,2).'" scrolling="no" frameborder="0"></iframe>';break;case'EXPLORER':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER2':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER3':$this->out.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($node->textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~European+Union&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'FB':$this->out.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href='.htmlspecialchars($node->textContent,2).'&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FBBRUT':$this->out.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href=https%3A%2F%2Fwww.facebook.com%2Fbrutofficiel%2Fvideos%2F'.htmlspecialchars($node->textContent,2).'%2F&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FIG':$this->out.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;autoplay=true" allowfullscreen="" width="640" height="360"></iframe>';break;case'FLASH':if($this->params['S_VIEWFLASH']!=='')$this->out.='<object classid="clsid:D27CDB6E-AE6D-11CF-96B8-444553540000" codebase="http://active.macromedia.com/flash2/cabs/swflash.cab#version=5,0,0,0" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'"><param name="movie" value="'.htmlspecialchars($node->getAttribute('url'),2).'"><param name="play" value="false"><param name="loop" value="false"><param name="quality" value="high"><param name="allowScriptAccess" value="never"><param name="allowNetworking" value="internal"><embed src="'.htmlspecialchars($node->getAttribute('url'),2).'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" width="'.htmlspecialchars($node->getAttribute('width'),2).'" height="'.htmlspecialchars($node->getAttribute('height'),2).'" play="false" loop="false" quality="high" allowscriptaccess="never" allownetworking="internal"></object>';else$this->at($node);break;case'FLO':$this->out.='<div class="flourish-embed flourish-table" data-src="'.htmlspecialchars($node->textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLOURISH':$this->out.='<div class="flourish-embed flourish-chart" data-src="visualisation/'.htmlspecialchars($node->textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLV':$this->out.='<embed src="http://yourserver.com/player.swf" width="450" height="360" allowscriptaccess="always" allowfullscreen="true" flashvars="width=450&amp;volume=50&amp;displayclick=none&amp;fullscreen=true&amp;file='.htmlspecialchars($node->getAttribute('content'),2).'">';break;case'FM':$this->out.='<iframe src="http://www.francemusique.fr/player/export-reecouter?content='.htmlspecialchars($node->textContent,2).'" width="481" frameborder="0" scrolling="no" height="137"></iframe>';break;case'FRANCEINFO':$this->out.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe><br>';break;case'FREEMP3':$this->out.='<table><tr><td><a href="http://www.freemp3go.org/track.php?id='.htmlspecialchars($node->textContent,2).'="></a></td></tr><tr><td><script type="text/javascript" src="http://jwpsrv.com/library/lNwD_IqdEeKinyIACp8kUw.js"></script><div id="playAround_wrapper">Loading the player...</div><script type="text/javascript">/**/jwplayer.key=&quot;7VoWoDgr0Gmogb5TdwF7v2lsIYKG8SZUo1ztUg==&quot;;jwplayer(&quot;playAround_wrapper&quot;).setup({&quot;width&quot;:340,&quot;height&quot;:26,&quot;autostart&quot;:true,&quot;playlist&quot;:[{&quot;image&quot;:&quot;http:\\/\\/www.freemp3go.org\\/images\\/logo.jpg&quot;,&quot;sources&quot;:[{&quot;type&quot;:&quot;flv&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=flv&quot;,&quot;default&quot;:true},{&quot;type&quot;:&quot;mp4&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=mp4&quot;}]}]});/**/</script></td></tr><tr></tr></table>';break;case'FTV':$this->out.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'GBOOK':$this->out.='<iframe frameborder="0" scrolling="no" style="border:0" src="https://books.google.fr/books?id='.htmlspecialchars($node->textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;output=embed" width="500" height="500"></iframe>';break;case'GBOOK155':$this->out.='<iframe frameborder="0" scrolling="no" style="border:0" src="http://books.google.fr/books?id='.htmlspecialchars($node->textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;pg=PA155&amp;output=embed" width="500" height="500"></iframe>';break;case'GEND':$this->out.='<iframe src="http://players.brightcove.net/610043537001/B1c7CqZH_default/index.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'GIPHY':$this->out.='<iframe src="https://giphy.com/embed/'.htmlspecialchars($node->textContent,2).'" width="480" height="384" frameborder="0" class="giphy-embed" allowfullscreen=""></iframe><p><a href="https://giphy.com/gifs/harvardmed-LmCsBMgBeXBY4yUWWq">via GIPHY</a></p>';break;case'GRAPH':$this->out.='<iframe width="45%" height="500" src="'.htmlspecialchars($node->textContent,2).'" frameborder="0" scrolling="no"></iframe>';break;case'GVIEW':$this->out.='<iframe src="https://docs.google.com/viewerng/viewer?url='.htmlspecialchars($node->getAttribute('content'),2).'" width="100%"></iframe>';break;case'I':$this->out.='<em class="text-italics">';$this->at($node);$this->out.='</em>';break;case'IFRAP':$this->out.='<iframe src="http://www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($node->textContent,2).'" width="670" height="715" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px 1px 0;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'IMG':if($this->params['S_VIEWIMG']!=='')$this->out.='<img src="'.htmlspecialchars($node->getAttribute('src'),2).'" class="postimage" alt="'.htmlspecialchars($this->params['L_IMAGE'],2).'">';else$this->at($node);break;case'INA':$this->out.='<iframe width="620" height="349" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="http://player.ina.fr/player/embed/'.htmlspecialchars($node->textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/620/349/0/148db8"></iframe>';break;case'INA1':$this->out.='<iframe width="100%" height="100%" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://player.ina.fr/player/embed/'.htmlspecialchars($node->textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/wide/1" allow="fullscreen,autoplay"></iframe>';break;case'INA2':$this->out.='<iframe frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://fresques.ina.fr/de-gaulle/export/player/'.htmlspecialchars($node->textContent,2).'/wide?isAmalia=1" width="620" height="465" allowfullscreen=""></iframe>';break;case'INTER':$this->out.='<iframe src="https://www.franceinter.fr/embed/player/aod/'.htmlspecialchars($node->textContent,2).'" width="100%" height="64" frameborder="0" scrolling="no"></iframe>';break;case'IRSEM':$this->out.='<iframe width="100%" height="300" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->textContent,2).'&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe>';break;case'IRSN':$this->out.='<iframe frameborder="0" width="240" height="210" title="" src="https://barometre.irsn.fr/'.htmlspecialchars($node->textContent,2).'/" type="text/html" allowfullscreen="true" scrolling="no" marginwidth="0" marginheight="0"></iframe>';break;case'ITELE':$this->out.='<div><iframe webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen="" width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=itele_vod&amp;vid='.htmlspecialchars($node->textContent,2).'"></iframe></div>';break;case'KNOEMA':$this->out.='<iframe src="https://knoema.fr/atlas/embed/topics/'.htmlspecialchars($node->textContent,2).'?type=maps" allowtransparency="true" frameborder="0" width="920" min-width="560" height="700" scrolling="no"></iframe>';break;case'LB':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/'.htmlspecialchars($node->textContent,2).'/src/qx5kszf/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="620" height="349" allow="autoplay; fullscreen"></iframe>';break;case'LC':$this->out.='<iframe src="https://ourworldindata.org/grapher/low-carbon-share-energy?tab=chart&amp;country='.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'LESOIR':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01613302/src/'.htmlspecialchars($node->textContent,2).'/zone/34/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="646" height="363" allow="autoplay; fullscreen"></iframe>';break;case'LI':$this->out.='<li>';$this->at($node);$this->out.='</li>';break;case'LINKEDIN':$this->out.='<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:'.htmlspecialchars($node->textContent,2).'" height="541" width="504" frameborder="0" allowfullscreen="" title="Post intégré"></iframe>';break;case'LINK_TEXT':$this->out.=htmlspecialchars($node->getAttribute('text'),0);break;case'LIST':if(!$node->hasAttribute('type')){$this->out.='<ul>';$this->at($node);$this->out.='</ul>';}elseif((strpos('upperlowerdecim',mb_substr($node->getAttribute('type'),0,5,'utf-8'))!==false)){$this->out.='<ol style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ol>';}else{$this->out.='<ul style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ul>';}break;case'LUMNI':$this->out.='<iframe allow="autoplay" title="" src="https://enseignants.lumni.fr/export/player/'.htmlspecialchars($node->textContent,2).'" width="100%" height="100%" allowfullscreen=""></iframe>';break;case'MAP':$this->out.='<div class="cpi-node" data-embed="map"></div><script src="'.htmlspecialchars($node->textContent,2).'"></script>';break;case'MEDIA':$this->out.='plus tard';break;case'MP3':$this->out.='<p style="color:rgb(0,0,0);font-family:Arial,sans-serif;font-size:11px;font-weight:normal;text-align:center;text-decoration:none"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" id="dewplayer" align="middle" height="30" width="300"><param name="allowScriptAccess" value="sameDomain"><param name="movie" value="http://forum.frequencebonheur.fr//dewplayer.swf?son='.htmlspecialchars($node->getAttribute('content'),2).'&amp;autostart=0&amp;bgcolor=FFFFFF"><param name="quality" value="high"><param name="bgcolor" value="FFFFFF"><embed src="http://forum.frequencebonheur.fr//dewplayer.swf?son='.htmlspecialchars($node->getAttribute('content'),2).'&amp;autostart=0&amp;bgcolor=FFFFFF" quality="high" bgcolor="FFFFFF" name="dewplayer" allowscriptaccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" align="middle" height="30" width="300"></object> <a href="'.htmlspecialchars($node->getAttribute('content'),2).'"><img style="border:medium none;text-decoration:none" src="http://img159.imageshack.us/img159/7397/f7943d41oy2.jpg" title="Podcast" alt="Podcast" align="absbottom"></a><br></p>';break;case'MP4':$this->out.='<video width="600" controls="controls"><source src="'.htmlspecialchars($node->getAttribute('content'),2).'" type="video/mp4"></video>';break;case'NFR':$this->out.='<embed src="http://www.npr.org/v2/?i='.htmlspecialchars($node->textContent,2).'&amp;m=259646821&amp;t=audio" height="386" wmode="opaque" allowfullscreen="true" width="400" base="http://www.npr.org" type="application/x-shockwave-flash">';break;case'NYT':$this->out.='<iframe width="480" height="373" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" id="nyt_video_player" title="New York Times Video - Embed Player" src="http://graphics8.nytimes.com/bcvideo/1.0/iframe/embed.html?videoId='.htmlspecialchars($node->textContent,2).'&amp;playerType=embed"></iframe>';break;case'OCDE':$this->out.='<embed src="http://www.pearsonfoundation.org/media/player-licensed.swf" width="640" height="376" allowscriptaccess="always" allowfullscreen="false" flashvars="file=http://www.pearsonfoundation.org/oecd/media/'.htmlspecialchars($node->textContent,2).'.mp4&amp;skin=http://www.pearsonfoundation.org/media/pf.swf">';break;case'ODYSEE':$this->out.='<iframe id="lbry-iframe" width="560" height="315" src="https://odysee.com/$/embed/'.htmlspecialchars($node->textContent,2).'" allowfullscreen=""></iframe>';break;case'OF':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01124706/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="640" height="360"></iframe>';break;case'OOYALA':$this->out.='<iframe width="640" height="480" frameborder="0" allowfullscreen="" src="//player.ooyala.com/static/v4/candidate/latest/skin-plugin/iframe.html?'.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'OWID':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'OWIDEX':case'e':case'i':case's':break;case'PDF':$this->out.='<embed src="'.htmlspecialchars($node->getAttribute('content'),2).'" width="100%" height="500px">';break;case'POLLSTER':$this->out.='<script src="http://elections.huffingtonpost.com/pollster/'.htmlspecialchars($node->textContent,2).'/embed.js"></script>';break;case'QUOTE':$this->out.='<blockquote';if($node->hasAttribute('post_url'))$this->out.=' cite="'.htmlspecialchars($node->getAttribute('post_url'),2).'"';if(!$node->hasAttribute('author'))$this->out.=' class="uncited"';$this->out.='><div>';if($node->hasAttribute('author')){$this->out.='<cite>';if($node->hasAttribute('url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';elseif($node->hasAttribute('profile_url'))$this->out.='<a href="'.htmlspecialchars($node->getAttribute('profile_url'),2).'">'.htmlspecialchars($node->getAttribute('author'),0).'</a>';else$this->out.=htmlspecialchars($node->getAttribute('author'),0);$this->out.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if($node->hasAttribute('post_url'))$this->out.=' <a href="'.htmlspecialchars($node->getAttribute('post_url'),2).'" data-post-id="'.htmlspecialchars($node->getAttribute('post_id'),2).'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if($node->hasAttribute('msg_url'))$this->out.=' <a href="'.htmlspecialchars($node->getAttribute('msg_url'),2).'" data-msg-id="'.htmlspecialchars($node->getAttribute('msg_id'),2).'">↑</a>';if($node->hasAttribute('date'))$this->out.='<span class="responsive-hide">'.htmlspecialchars($node->getAttribute('date'),0).'</span>';$this->out.='</cite>';}$this->at($node);$this->out.='</div></blockquote>';break;case'REPORTERRE':$this->out.='<iframe frameborder="0" loading="lazy" id="ausha-r1JH" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId='.htmlspecialchars($node->textContent,2).'&amp;v=3&amp;playerId=ausha-r1JH"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'RESIZE':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('content'),2).'"><img style="max-width:800px;max-height;800px" src="'.htmlspecialchars($node->getAttribute('content'),2).'" alt="Image"></a>';break;case'RTE':$this->out.='<iframe src="https://eco2mix.rte-france.com/pluginWeb/data?key='.htmlspecialchars($node->textContent,2).'" width="350" height="370"></iframe>';break;case'RTL':case'RTLBE':$this->out.='<div style="width:600px;height:338px"><script async="async" type="text/javascript" src="//www.rtl.be/videos/player/vp_embed.js" videoid="'.htmlspecialchars($node->textContent,2).'"></script></div>';break;case'RTS':$this->out.='<iframe width="560" height="315" src="https://www.rts.ch/play/embed?urn=urn:rts:video:'.htmlspecialchars($node->textContent,2).'&amp;subdivisions=false" allowfullscreen="" allow="geolocation *; autoplay; encrypted-media"></iframe>';break;case'RUTUBE':$this->out.='<iframe width="720" height="405" src="//rutube.ru/video/embed/'.htmlspecialchars($node->textContent,2).'" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'SAPIENS':$this->out.='<iframe width="100%" height="450" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/859584016&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe><div style="font-size:10px;color:#ccc;line-break:anywhere;word-break:normal;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight:100"><a href="https://soundcloud.com/user-702632852" title="Institut Sapiens" target="_blank" style="color:#ccc;text-decoration:none" rel="noreferrer">Institut Sapiens</a> · <a href="https://soundcloud.com/user-702632852/'.htmlspecialchars($node->textContent,2).'"></a></div>';break;case'SCRIB':$this->out.='<iframe class="scribd_iframe_embed" src="https://www.scribd.com/embeds/'.htmlspecialchars($node->textContent,2).'/content?start_page=1&amp;view_mode=scroll&amp;access_key=key-2imc0qq0kxk41ryg1wrd&amp;show_recommendations=false" data-auto-height="false" data-aspect-ratio="0.7729220222793488" scrolling="no" id="doc_25852" width="600" height="800" frameborder="0"></iframe>';break;case'SENAT':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'" width="640" height="430" frameborder="0" allowfullscreen="true" scrolling="no"></iframe>';break;case'SIZE':$this->out.='<span style="font-size:'.htmlspecialchars($node->getAttribute('size'),2).'%;line-height:116%">';$this->at($node);$this->out.='</span>';break;case'SLIDE':$this->out.='<iframe src="//www.slideshare.net/slideshow/embed_code/key/'.htmlspecialchars($node->textContent,2).'" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'SOUNDCLOUD':case'UNO':$this->out.='<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->textContent,2).'&amp;color=ff5500"></iframe>';break;case'SPOTIFY':$this->out.='<iframe src="https://open.spotify.com/embed/show/'.htmlspecialchars($node->textContent,2).'" width="100%" height="232" frameborder="0" allowtransparency="true" allow="encrypted-media"></iframe>';break;case'STATIC':$this->out.='<iframe src="'.htmlspecialchars($node->textContent,2).'" width="480" height="270" frameborder="0" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'TABLE':$this->out.='<table style="width:100%;display:inline-table;border:#333 solid 1px;background:#f2f2f2">';$this->at($node);$this->out.='</table>';break;case'TD':$this->out.='<td valign="top" style="border-top:1px solid #808080;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">';$this->at($node);$this->out.='</td>';break;case'TED':case'TED2':case'TED3':$this->out.='<div style="max-width:854px"><div style="position:relative;height:0;padding-bottom:56.25%"><iframe src="https://embed.ted.com/talks/lang/fr/'.htmlspecialchars($node->textContent,2).'" width="854" height="480" style="position:absolute;left:0;top:0;width:100%;height:100%" frameborder="0" scrolling="no" allowfullscreen=""></iframe></div></div>';break;case'TELEGRAMME':$this->out.='<iframe src="https://www.letelegramme.fr/static/ftp/dossier/data/dataviz/iframe/iframe.php?id='.htmlspecialchars($node->textContent,2).'" width="100%" height="400&quot;" style="max-width:100%" frameborder="0"></iframe>';break;case'TF1':$this->out.='<iframe src="//www.tf1.fr/embedframe/'.htmlspecialchars($node->textContent,2).'" frameborder="0" style="width:640px;height:360px"></iframe>';break;case'TH':$this->out.='<td valign="top" style="border-top:1px solid #808080;font-weight:bold;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">';$this->at($node);$this->out.='</td>';break;case'TLG':$this->out.='<script async="" src="https://telegram.org/js/telegram-widget.js?19" data-telegram-post="'.htmlspecialchars($node->textContent,2).'" data-width="100%"></script>';break;case'TR':$this->out.='<tr>';$this->at($node);$this->out.='</tr>';break;case'TWT':$this->out.='<script type="text/javascript"> function loadx(data) { document.write(data.html); } </script> <script type="text/javascript" src="https://api.twitter.com/1/statuses/oembed.json?id='.htmlspecialchars($node->getAttribute('content2'),2).'&amp;callback=loadx"></script> <div class="twitter" onload="loadx().html"></div>';break;case'U':$this->out.='<span style="text-decoration:underline">';$this->at($node);$this->out.='</span>';break;case'ULTI':$this->out.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01946947/src/'.htmlspecialchars($node->textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="470" height="300" allow="autoplay; fullscreen"></iframe>';break;case'UNIGE':$this->out.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url=https://mediaserver.unige.ch/media/'.htmlspecialchars($node->textContent,2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'UNIV':$this->out.='<iframe class="player" frameborder="0" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="'.htmlspecialchars($node->textContent,2).'" width="576" height="324"> </iframe>';break;case'URL':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'" class="postlink">';$this->at($node);$this->out.='</a>';break;case'VIDEO':$this->out.='<div class="bbvideo" data-url="'.htmlspecialchars($node->getAttribute('content'),2).'" style="width:640px;height:390px;margin:2px 0;display:inline-block;background:#000;color:#fff;overflow:hidden;vertical-align:bottom"><div style="height:100%"><script>if (typeof bbmedia == \'undefined\') { bbmedia = true; var e = document.createElement(\'script\'); e.async = true; e.src = \'http://phpbbex.com/api/bbmedia.js\'; var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(e, s); }</script></div><div style="text-align:right;height:14px;margin-top:-14px;padding-right:2px;font:10px/10px Verdana;color:#555"><a style="color:#105289;text-decoration:none" href="http://phpbbex.com/" target="_blank" rel="noreferrer">phpBB</a> [video]</div></div>';break;case'VIDEOFIG':$this->out.='<object id="flashObj" width="800" height="450" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=4500912462001&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId='.htmlspecialchars($node->textContent,2).'&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="800" height="450" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'VK':$this->out.='<iframe src="'.htmlspecialchars($node->getAttribute('content'),2).'" width="640" height="360" frameborder="0" allowfullscreen="1" allow="autoplay; encrypted-media; fullscreen; picture-in-picture"></iframe>';break;case'VMO':$this->out.='<iframe src="//player.vimeo.com/video/'.htmlspecialchars($node->textContent,2).'" width="640" height="470" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'WAT':$this->out.='<iframe src="http://www.wat.tv/embedframe/'.htmlspecialchars($node->textContent,2).'" frameborder="0" style="width:620px;height:350px"></iframe>';break;case'WID':$this->out.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($node->textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=latest&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'WMP':$this->out.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url='.htmlspecialchars($node->getAttribute('content'),2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'WPVIDEO':$this->out.='<embed type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" width="400" height="224" wmode="direct" seamlesstabbing="true" allowfullscreen="true" allowscriptaccess="always" overstretch="true" flashvars="guid='.htmlspecialchars($node->textContent,2).'&amp;isDynamicSeeking=true">';break;case'WSJ':$this->out.='<iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" width="512" height="288" src="https://video-api.wsj.com/api-video/player/v3/iframe.html?guid='.htmlspecialchars($node->textContent,2).'"></iframe>';break;case'YOUSCRIBE':$this->out.='<iframe src="//www.youscribe.com/BookReader/IframeEmbed?productId='.htmlspecialchars($node->textContent,2).'&amp;token=&amp;width=620&amp;height=917&amp;startPage=1&amp;displayMode=scroll&amp;fullscreen=0" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" frameborder="0" scrolling="no" width="620px" height="917px" marginwidth="0" marginheight="0" style="border:1px solid #44444a;width:620px;height:917px;margin:0;padding:0"></iframe>';break;case'YOUTUBE':$this->out.='<iframe width="480" height="360" src="//www.youtube.com/embed/'.htmlspecialchars($node->textContent,2).'" frameborder="0" allowfullscreen=""></iframe>';break;case'ZAD1':$this->out.='<object id="flashObj" width="480" height="270" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID=1321210711001&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID='.htmlspecialchars($node->textContent,2).'&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="480" height="270" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'br':$this->out.='<br>';break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	/** {@inheritdoc} */
	public $enableQuickRenderer=true;
	/** {@inheritdoc} */
	protected $static=['/B'=>'</strong>','/CODE'=>'</code></pre></div>','/COLOR'=>'</span>','/EMAIL'=>'</a>','/I'=>'</em>','/LI'=>'</li>','/QUOTE'=>'</div></blockquote>','/SIZE'=>'</span>','/TABLE'=>'</table>','/TD'=>'</td>','/TH'=>'</td>','/TR'=>'</tr>','/U'=>'</span>','/URL'=>'</a>','AKAD'=>'<iframe width="560" height="315" src="//embedftv-a.akamaihd.net/%7BTEXT%5D" frameborder="0" scrolling="no" allowfullscreen=""></iframe>','B'=>'<strong class="text-strong">','I'=>'<em class="text-italics">','LI'=>'<li>','MEDIA'=>'plus tard','OWIDEX'=>'','TABLE'=>'<table style="width:100%;display:inline-table;border:#333 solid 1px;background:#f2f2f2">','TD'=>'<td valign="top" style="border-top:1px solid #808080;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">','TH'=>'<td valign="top" style="border-top:1px solid #808080;font-weight:bold;border-right:1px solid #808080;border-left:1px solid #808080;padding:1px;margin:1px;border-radius:5px">','TR'=>'<tr>','U'=>'<span style="text-decoration:underline">'];
	/** {@inheritdoc} */
	protected $dynamic=['COLOR'=>['(^[^ ]+(?> (?!color=)[^=]+="[^"]*")*(?> color="([^"]*)")?.*)s','<span style="color:$1">'],'DEW'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<audio controls=""><source src="$1" type="audio/ogg"><source src="$1" type="audio/mpeg"><source src="$1" type="audio/wav"></audio>'],'FLV'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<embed src="http://yourserver.com/player.swf" width="450" height="360" allowscriptaccess="always" allowfullscreen="true" flashvars="width=450&amp;volume=50&amp;displayclick=none&amp;fullscreen=true&amp;file=$1">'],'GVIEW'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="https://docs.google.com/viewerng/viewer?url=$1" width="100%"></iframe>'],'MP3'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<p style="color:rgb(0,0,0);font-family:Arial,sans-serif;font-size:11px;font-weight:normal;text-align:center;text-decoration:none"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" id="dewplayer" align="middle" height="30" width="300"><param name="allowScriptAccess" value="sameDomain"><param name="movie" value="http://forum.frequencebonheur.fr//dewplayer.swf?son=$1&amp;autostart=0&amp;bgcolor=FFFFFF"><param name="quality" value="high"><param name="bgcolor" value="FFFFFF"><embed src="http://forum.frequencebonheur.fr//dewplayer.swf?son=$1&amp;autostart=0&amp;bgcolor=FFFFFF" quality="high" bgcolor="FFFFFF" name="dewplayer" allowscriptaccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" align="middle" height="30" width="300"></object> <a href="$1"><img style="border:medium none;text-decoration:none" src="http://img159.imageshack.us/img159/7397/f7943d41oy2.jpg" title="Podcast" alt="Podcast" align="absbottom"></a><br></p>'],'MP4'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<video width="600" controls="controls"><source src="$1" type="video/mp4"></video>'],'PDF'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<embed src="$1" width="100%" height="500px">'],'RESIZE'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<a href="$1"><img style="max-width:800px;max-height;800px" src="$1" alt="Image"></a>'],'SIZE'=>['(^[^ ]+(?> (?!size=)[^=]+="[^"]*")*(?> size="([^"]*)")?.*)s','<span style="font-size:$1%;line-height:116%">'],'TWT'=>['(^[^ ]+(?> (?!content2=)[^=]+="[^"]*")*(?> content2="([^"]*)")?.*)s','<script type="text/javascript"> function loadx(data) { document.write(data.html); } </script> <script type="text/javascript" src="https://api.twitter.com/1/statuses/oembed.json?id=$1&amp;callback=loadx"></script> <div class="twitter" onload="loadx().html"></div>'],'URL'=>['(^[^ ]+(?> (?!url=)[^=]+="[^"]*")*(?> url="([^"]*)")?.*)s','<a href="$1" class="postlink">'],'VIDEO'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<div class="bbvideo" data-url="$1" style="width:640px;height:390px;margin:2px 0;display:inline-block;background:#000;color:#fff;overflow:hidden;vertical-align:bottom"><div style="height:100%"><script>if (typeof bbmedia == \'undefined\') { bbmedia = true; var e = document.createElement(\'script\'); e.async = true; e.src = \'http://phpbbex.com/api/bbmedia.js\'; var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(e, s); }</script></div><div style="text-align:right;height:14px;margin-top:-14px;padding-right:2px;font:10px/10px Verdana;color:#555"><a style="color:#105289;text-decoration:none" href="http://phpbbex.com/" target="_blank" rel="noreferrer">phpBB</a> [video]</div></div>'],'VK'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="$1" width="640" height="360" frameborder="0" allowfullscreen="1" allow="autoplay; encrypted-media; fullscreen; picture-in-picture"></iframe>'],'WMP'=>['(^[^ ]+(?> (?!content=)[^=]+="[^"]*")*(?> content="([^"]*)")?.*)s','<iframe src="http://elearn-services.unige.ch/medias/share/video?url=$1&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>']];
	/** {@inheritdoc} */
	protected $quickRegexp='(<(?:(?!/)((?:A(?:CA(?:D|ST)|KAD|LTER|P[IO]|R(?:D|TE7?)|TT(?:ACHMENT|V)|USHA)|B(?:BC4?|COVE|F(?:IG|M)|M)|C(?:A(?:LAMEO|NAL(?:-U)?)|D[FN]|HART(?:[1-3]|CO2|N(?:DL|EWDEATHS)|TOTALDEATH)?|ULT)|D(?:[CHR]|ATA|DC?|E[BW]|MOTION|OC(?:GOOGLE|PLAYER))|E(?:CHOS|DV?|MOJI|UR(?:1|OSTAT)|XPLORER[23]?)|F(?:B(?:BRUT)?|IG|L(?:O(?:URISH)?|V)|M|R(?:3|ANCEINFO|EEMP3)|TV)|G(?:BOOK(?:155)?|END|IPHY|RAPH|VIEW)|I(?:FRAP|N(?:A[12]?|TER)|RS(?:EM|N)|TELE)|KNOEMA|L(?:[BC]|ESOIR|INK(?:EDIN|_TEXT)|UMNI)|M(?:AP|EDIA|P[34])|N(?:FR|YT)|O(?:CDE|DYSEE|F|OYALA|WID(?:EX)?)|P(?:DF|OLLSTER)|R(?:E(?:PORTERR|SIZ)E|T(?:[ES]|L(?:BE)?)|UTUBE)|S(?:APIENS|CRIB|ENAT|LIDE|O(?:IR3|UNDCLOUD)|POTIFY|TATIC)|T(?:E(?:D[23]?|LEGRAMME)|F1|LG|VINFO|WT)|U(?:LTI|N(?:I(?:GE|V)|O))|V(?:IDEO(?:FIG)?|K|MO)|W(?:AT|ID|MP|PVIDEO|SJ)|YOU(?:SCRI|TU)BE|ZAD1))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	/** {@inheritdoc} */
	protected $quickRenderingTest='((?<=<)(?:[!?]|(?:E(?:NS)?|FLASH|IMG)[ />]))';
	/** {@inheritdoc} */
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'/LIST':$attributes=array_pop($this->attributes);if(!isset($attributes['type']))$html.='</ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']??''),0,5,'utf-8'))!==false))$html.='</ol>';else$html.='</ul>';break;case'ACAD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'&amp;autostart=false" width="400" height="300" frameborder="0" scrolling="no" class="float_left_webcast"></iframe>';break;case'ACAST':$textContent=$this->getQuickTextContent($xml);$html.='<iframe title="Embed Player" width="100%" height="188px" src="https://embed.acast.com/'.htmlspecialchars($textContent,2).'" scrolling="no" frameborder="0" style="border:none;overflow:hidden"></iframe>';break;case'ALTER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="684" height="667" frameborder="0" src="https://www.alternatives-economiques.fr/embed/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'API':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="640" height="360" src="'.htmlspecialchars($textContent,2).'"></iframe>';break;case'APO':case'FR3':case'SOIR3':case'TVINFO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="640" height="360" src="http://api.dmcloud.net/player/embed/'.htmlspecialchars($textContent,2).'?exported=1"></iframe>';break;case'ARD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.ardmediathek.de/embed/'.htmlspecialchars($textContent,2).'" width="640" height="420" allowfullscreen="" frameborder="0" scrolling="no"></iframe>';break;case'ARTE':$textContent=$this->getQuickTextContent($xml);$html.='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" id="playerArte" allowscriptaccess="always" width="450" height="303"><param name="allowFullScreen" value="true"><param name="allowScriptAccess" value="always"><param name="quality" value="high"><param name="movie" value="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl='.htmlspecialchars($textContent,2).'&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false"><embed src="http://videos.arte.tv/videoplayer.swf?videoId=4157746&amp;mode=prod&amp;videorefFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Ffr%2Fdo%5Fdelegate%2Fvideos%2Fray%2Dkurzweil%2Dqu%2Dest%2Dce%2Dque%2Dla%2Dsingularite%2D%2D4157746%2Cview%2CasPlayerXml%2Exml&amp;autoPlay=false&amp;lang=fr&amp;configFileUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2Fconfig%2Exml&amp;admin=false&amp;localizedPathUrl=http%3A%2F%2Fvideos%2Earte%2Etv%2Fcae%2Fstatic%2Fflash%2Fplayer%2F&amp;embed=true&amp;autoPlay=false" width="450" height="303" allowfullscreen="true" name="playerArte" quality="high" allowscriptaccess="always" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></object>';break;case'ARTE7':$textContent=$this->getQuickTextContent($xml);$html.='<script type="text/javascript" src="https://www-secure.arte.tv/arte_vp/embed.php?json_url=http%3A%2F%2Fconcert.arte.tv%2Ffr%2Fplayer%2F'.htmlspecialchars($textContent,2).'&amp;lang=fr_FR&amp;config=arte_concert&amp;width=720&amp;height=406"></script>';break;case'ATTACHMENT':$attributes+=['index'=>null,'filename'=>null];$html.='<div class="inline-attachment"><!-- ia'.str_replace('&quot;','"',$attributes['index']??'').' -->'.str_replace('&quot;','"',$attributes['filename']??'').'<!-- ia'.str_replace('&quot;','"',$attributes['index']??'').' --></div>';break;case'ATTV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://vp.telvue.com/player?id=T03105&amp;video='.htmlspecialchars($textContent,2).'&amp;mini=true" width="400" height="300" marginwidth="0" marginheight="0" hpsace="0" vspace="0" frameborder="1" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'AUSHA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" loading="lazy" id="'.htmlspecialchars($textContent,2).'" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId=bzPxksVdjQnD&amp;v=3&amp;playerId=ausha-WWk4"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'BBC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="400" height="500" frameborder="0" src="https://www.bbc.com/news/av/embed/p080qwnv/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'BBC4':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="400" height="500" frameborder="0" src="http://www.bbc.co.uk/programmes/'.htmlspecialchars($textContent,2).'/player"></iframe>';break;case'BCOVE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/45228659001/rkPdEdoaW_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFIG':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'BFM':$textContent=$this->getQuickTextContent($xml);$html.='<div style="display:block;position:relative"><div style="padding-top:56.25%"><iframe src="'.htmlspecialchars($textContent,2).'" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" style="width:100%;height:100%;position:absolute;top:0;bottom:0;right:0;left:0;border:none"></iframe></div></div>';break;case'BM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://donnees.banquemondiale.org/share/widget?indicators='.htmlspecialchars($textContent,2).'" width="450" height="300" frameborder="0" scrolling="no"></iframe>';break;case'CALAMEO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//v.calameo.com/?bkcode='.htmlspecialchars($textContent,2).'" width="900" height="582" frameborder="0" scrolling="no" allowtransparency="" allowfullscreen="" style="margin:0 auto"></iframe>';break;case'CANAL':$textContent=$this->getQuickTextContent($xml);$html.='<div><iframe width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=cplus&amp;vid='.htmlspecialchars($textContent,2).'"></iframe></div>';break;case'CANAL-U':$textContent=$this->getQuickTextContent($xml);$html.='<div style="position:relative;padding-bottom:56.25%;padding-top:10px;height:0;overflow:hidden"><iframe src="https://www.canal-u.tv/video/cerimes/embed.1/'.htmlspecialchars($textContent,2).'?width=100%25&amp;height=100%25" style="position:absolute;top:0;left:0;width:100%;height:100%" width="550" height="306" frameborder="0" allowfullscreen="" scrolling="no"></iframe></div>';break;case'CDF':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.mariamagdalenakaczor.eu/mediaplayer/player.swf" height="560" width="745" allowscriptaccess="always" allowfullscreen="true" flashvars="&amp;controlbar=over&amp;item='.htmlspecialchars($textContent,2).'&amp;playlistfile=http%3A%2F%2Fwww.mariamagdalenakaczor.eu%2Fmediapayer%2Fplaylist.xml&amp;plugins=viral-2d">';break;case'CDN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//cdn.jwplayer.com/players/'.htmlspecialchars($textContent,2).'" width="640" height="360" frameborder="0" scrolling="auto"></iframe>';break;case'CHART':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=2020-12-20..latest&amp;country=USA~DEU~GBR~FRA~ISR~ITA~ESP&amp;region=World&amp;vaccinationsMetric=true&amp;interval=total&amp;perCapita=true&amp;smoothing=0&amp;pickerMetric=total_vaccinations_per_hundred&amp;pickerSort=desc" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHART3':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-12-20..latest&amp;pickerSort=asc&amp;pickerMetric=location&amp;Metric=Vaccine+doses&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTCO2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;country=FRA~DEU~NLD~POL~EU-27&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNDL':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=earliest..latest&amp;country=~NLD&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTNEWDEATHS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=2020-03-01..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=GBR~FRA~USA~BRA~IND~MEX~RUS~ITA&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CHARTTOTALDEATH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~GBR~FRA~BRA~HUN" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'CODE':$html.='<div class="codebox"><p>'.htmlspecialchars($this->params['L_CODE'].$this->params['L_COLON'],0).' <a href="#" onclick="selectCode(this); return false;">'.htmlspecialchars($this->params['L_SELECT_ALL_CODE'],0).'</a></p><pre><code>';break;case'CULT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.franceculture.fr/player/export-reecouter?content='.htmlspecialchars($textContent,2).'" width="481" frameborder="0" scrolling="no" height="139"></iframe>';break;case'DATA':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-bar-chart-race" data-src="visualisation/'.htmlspecialchars($textContent,2).'" data-url="https://flo.uri.sh/visualisation/'.htmlspecialchars($textContent,2).'/embed"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'DC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DD':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;time=2020-03-01..latest&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DDC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/coronavirus-data-explorer?zoomToSelection=true&amp;facet=none&amp;pickerSort=desc&amp;pickerMetric=total_cases&amp;hideControls=true&amp;Metric=Confirmed+deaths&amp;Interval=Cumulative&amp;Relative+to+Population=true&amp;Color+by+test+positivity=false&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DEB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="270" style="width:480px;height:270px" src="http://mediaspip.ptitdeb.infini.fr/spip.php?page=embed_code&amp;id_objet='.htmlspecialchars($textContent,2).'&amp;objet=document&amp;largeur=480&amp;hauteur=270" frameborder="0" allowfullscreen=""></iframe>';break;case'DH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/weekly-hospital-admissions-covid?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'DMOTION':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="480" height="270" src="https://www.dailymotion.com/embed/video/'.htmlspecialchars($textContent,2).'"></iframe>';break;case'DOCGOOGLE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://docs.google.com/file/d/'.htmlspecialchars($textContent,2).'/preview" width="640" height="480"></iframe>';break;case'DOCPLAYER':$textContent=$this->getQuickTextContent($xml);$html.='<div><div><a target="_blank" href="'.htmlspecialchars($textContent,2).'" rel="noreferrer"></a></div><div><iframe frameborder="0" style="border-bottom:2px solid #eee;border-top:0" scrolling="no" src="http://docplayer.fr/docview/112/202650701/" width="728" height="1040" allowfullscreen=""></iframe></div></div>';break;case'DR':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/current-covid-patients-icu?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'ECHOS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01578907/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="480" height="400" allow="autoplay; fullscreen"></iframe>';break;case'ED':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/excess-deaths-cumulative-economist-who?country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EDV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/life-expectancy?tab=chart&amp;time=earliest..2019&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EMAIL':$attributes+=['email'=>null,'body'=>null];$html.='<a href="mailto:'.$attributes['email'];if(isset($attributes['subject'])||isset($attributes['body'])){$html.='?';if(isset($attributes['subject']))$html.='subject='.$attributes['subject'];if(isset($attributes['body'])){if(isset($attributes['subject']))$html.='&amp;';$html.='body='.$attributes['body'];}}$html.='">';break;case'EMOJI':$attributes+=['seq'=>null];$textContent=$this->getQuickTextContent($xml);if($this->params['S_VIEWSMILIES']!==''){$html.='<img alt="'.htmlspecialchars($textContent,2).'" class="emoji smilies" draggable="false" src="//cdn.jsdelivr.net/gh/twitter/twemoji@latest/assets/svg/';if(isset($attributes['tseq']))$html.=($attributes['tseq']??'');else$html.=($attributes['seq']??'');$html.='.svg">';}else$html.=htmlspecialchars($textContent,0);break;case'EUR1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.europe1.fr/videos/embed/'.htmlspecialchars($textContent,2).'" width="734px" height="406px"></iframe>';break;case'EUROSTAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="964" height="462" src="https://ec.europa.eu/eurostat/statistics-explained/index.php?'.htmlspecialchars($textContent,2).'" scrolling="no" frameborder="0"></iframe>';break;case'EXPLORER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;hideControls=true&amp;Metric=Confirmed+cases&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=ESP~USA~GBR~FRA~ISR&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'EXPLORER3':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/explorers/'.htmlspecialchars($textContent,2).'?zoomToSelection=true&amp;time=40..latest&amp;pickerSort=desc&amp;pickerMetric=location&amp;Metric=Confirmed+deaths&amp;Interval=7-day+rolling+average&amp;Relative+to+Population=true&amp;Align+outbreaks=false&amp;country=USA~European+Union&amp;hideControls=true" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'FB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href='.htmlspecialchars($textContent,2).'&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FBBRUT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.facebook.com/plugins/video.php?height=476&amp;href=https%3A%2F%2Fwww.facebook.com%2Fbrutofficiel%2Fvideos%2F'.htmlspecialchars($textContent,2).'%2F&amp;show_text=false&amp;width=476" width="476" height="476" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share"></iframe>';break;case'FIG':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://players.brightcove.net/610043537001/4k4QmRz5g_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;autoplay=true" allowfullscreen="" width="640" height="360"></iframe>';break;case'FLO':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-table" data-src="'.htmlspecialchars($textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FLOURISH':$textContent=$this->getQuickTextContent($xml);$html.='<div class="flourish-embed flourish-chart" data-src="visualisation/'.htmlspecialchars($textContent,2).'"><script src="https://public.flourish.studio/resources/embed.js"></script></div>';break;case'FM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.francemusique.fr/player/export-reecouter?content='.htmlspecialchars($textContent,2).'" width="481" frameborder="0" scrolling="no" height="137"></iframe>';break;case'FRANCEINFO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe><br>';break;case'FREEMP3':$textContent=$this->getQuickTextContent($xml);$html.='<table><tr><td><a href="http://www.freemp3go.org/track.php?id='.htmlspecialchars($textContent,2).'="></a></td></tr><tr><td><script type="text/javascript" src="http://jwpsrv.com/library/lNwD_IqdEeKinyIACp8kUw.js"></script><div id="playAround_wrapper">Loading the player...</div><script type="text/javascript">/**/jwplayer.key=&quot;7VoWoDgr0Gmogb5TdwF7v2lsIYKG8SZUo1ztUg==&quot;;jwplayer(&quot;playAround_wrapper&quot;).setup({&quot;width&quot;:340,&quot;height&quot;:26,&quot;autostart&quot;:true,&quot;playlist&quot;:[{&quot;image&quot;:&quot;http:\\/\\/www.freemp3go.org\\/images\\/logo.jpg&quot;,&quot;sources&quot;:[{&quot;type&quot;:&quot;flv&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=flv&quot;,&quot;default&quot;:true},{&quot;type&quot;:&quot;mp4&quot;,&quot;file&quot;:&quot;http:\\/\\/pl.freemp3go.org\\/video.php?id=AXjGjT-QDC8&amp;format=mp4&quot;}]}]});/**/</script></td></tr><tr></tr></table>';break;case'FTV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="544" height="306" src="//embedftv-a.akamaihd.net/'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no" allowfullscreen=""></iframe>';break;case'GBOOK':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" scrolling="no" style="border:0" src="https://books.google.fr/books?id='.htmlspecialchars($textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;output=embed" width="500" height="500"></iframe>';break;case'GBOOK155':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" scrolling="no" style="border:0" src="http://books.google.fr/books?id='.htmlspecialchars($textContent,2).'&amp;lpg=PP1&amp;hl=fr&amp;pg=PA155&amp;output=embed" width="500" height="500"></iframe>';break;case'GEND':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://players.brightcove.net/610043537001/B1c7CqZH_default/index.html?videoId='.htmlspecialchars($textContent,2).'&amp;mute=true" allowfullscreen="" frameborder="0"></iframe>';break;case'GIPHY':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://giphy.com/embed/'.htmlspecialchars($textContent,2).'" width="480" height="384" frameborder="0" class="giphy-embed" allowfullscreen=""></iframe><p><a href="https://giphy.com/gifs/harvardmed-LmCsBMgBeXBY4yUWWq">via GIPHY</a></p>';break;case'GRAPH':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="45%" height="500" src="'.htmlspecialchars($textContent,2).'" frameborder="0" scrolling="no"></iframe>';break;case'IFRAP':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($textContent,2).'" width="670" height="715" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px 1px 0;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'INA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="620" height="349" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="http://player.ina.fr/player/embed/'.htmlspecialchars($textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/620/349/0/148db8"></iframe>';break;case'INA1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="100%" frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://player.ina.fr/player/embed/'.htmlspecialchars($textContent,2).'/1/1b0bd203fbcd702f9bc9b10ac3d0fc21/wide/1" allow="fullscreen,autoplay"></iframe>';break;case'INA2':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" marginheight="0" marginwidth="0" scrolling="no" src="https://fresques.ina.fr/de-gaulle/export/player/'.htmlspecialchars($textContent,2).'/wide?isAmalia=1" width="620" height="465" allowfullscreen=""></iframe>';break;case'INTER':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.franceinter.fr/embed/player/aod/'.htmlspecialchars($textContent,2).'" width="100%" height="64" frameborder="0" scrolling="no"></iframe>';break;case'IRSEM':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="300" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($textContent,2).'&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe>';break;case'IRSN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" width="240" height="210" title="" src="https://barometre.irsn.fr/'.htmlspecialchars($textContent,2).'/" type="text/html" allowfullscreen="true" scrolling="no" marginwidth="0" marginheight="0"></iframe>';break;case'ITELE':$textContent=$this->getQuickTextContent($xml);$html.='<div><iframe webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen="" width="480" height="270" frameborder="0" scrolling="no" src="http://player.canalplus.fr/embed/?param=itele_vod&amp;vid='.htmlspecialchars($textContent,2).'"></iframe></div>';break;case'KNOEMA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://knoema.fr/atlas/embed/topics/'.htmlspecialchars($textContent,2).'?type=maps" allowtransparency="true" frameborder="0" width="920" min-width="560" height="700" scrolling="no"></iframe>';break;case'LB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/'.htmlspecialchars($textContent,2).'/src/qx5kszf/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="620" height="349" allow="autoplay; fullscreen"></iframe>';break;case'LC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/low-carbon-share-energy?tab=chart&amp;country='.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'LESOIR':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01613302/src/'.htmlspecialchars($textContent,2).'/zone/34/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="646" height="363" allow="autoplay; fullscreen"></iframe>';break;case'LINKEDIN':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:'.htmlspecialchars($textContent,2).'" height="541" width="504" frameborder="0" allowfullscreen="" title="Post intégré"></iframe>';break;case'LINK_TEXT':$attributes+=['text'=>null];$html.=str_replace('&quot;','"',$attributes['text']??'');break;case'LIST':$attributes+=['type'=>null];if(!isset($attributes['type']))$html.='<ul>';elseif((strpos('upperlowerdecim',mb_substr(htmlspecialchars_decode($attributes['type']??''),0,5,'utf-8'))!==false))$html.='<ol style="list-style-type:'.$attributes['type'].'">';else$html.='<ul style="list-style-type:'.$attributes['type'].'">';$this->attributes[]=$attributes;break;case'LUMNI':$textContent=$this->getQuickTextContent($xml);$html.='<iframe allow="autoplay" title="" src="https://enseignants.lumni.fr/export/player/'.htmlspecialchars($textContent,2).'" width="100%" height="100%" allowfullscreen=""></iframe>';break;case'MAP':$textContent=$this->getQuickTextContent($xml);$html.='<div class="cpi-node" data-embed="map"></div><script src="'.htmlspecialchars($textContent,2).'"></script>';break;case'NFR':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.npr.org/v2/?i='.htmlspecialchars($textContent,2).'&amp;m=259646821&amp;t=audio" height="386" wmode="opaque" allowfullscreen="true" width="400" base="http://www.npr.org" type="application/x-shockwave-flash">';break;case'NYT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="373" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" id="nyt_video_player" title="New York Times Video - Embed Player" src="http://graphics8.nytimes.com/bcvideo/1.0/iframe/embed.html?videoId='.htmlspecialchars($textContent,2).'&amp;playerType=embed"></iframe>';break;case'OCDE':$textContent=$this->getQuickTextContent($xml);$html.='<embed src="http://www.pearsonfoundation.org/media/player-licensed.swf" width="640" height="376" allowscriptaccess="always" allowfullscreen="false" flashvars="file=http://www.pearsonfoundation.org/oecd/media/'.htmlspecialchars($textContent,2).'.mp4&amp;skin=http://www.pearsonfoundation.org/media/pf.swf">';break;case'ODYSEE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe id="lbry-iframe" width="560" height="315" src="https://odysee.com/$/embed/'.htmlspecialchars($textContent,2).'" allowfullscreen=""></iframe>';break;case'OF':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01124706/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="640" height="360"></iframe>';break;case'OOYALA':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="640" height="480" frameborder="0" allowfullscreen="" src="//player.ooyala.com/static/v4/candidate/latest/skin-plugin/iframe.html?'.htmlspecialchars($textContent,2).'"></iframe>';break;case'OWID':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'POLLSTER':$textContent=$this->getQuickTextContent($xml);$html.='<script src="http://elections.huffingtonpost.com/pollster/'.htmlspecialchars($textContent,2).'/embed.js"></script>';break;case'QUOTE':$attributes+=['url'=>null,'author'=>null,'post_id'=>null,'msg_id'=>null];$html.='<blockquote';if(isset($attributes['post_url']))$html.=' cite="'.$attributes['post_url'].'"';if(!isset($attributes['author']))$html.=' class="uncited"';$html.='><div>';if(isset($attributes['author'])){$html.='<cite>';if(isset($attributes['url']))$html.='<a href="'.$attributes['url'].'" class="postlink">'.str_replace('&quot;','"',$attributes['author']??'').'</a>';elseif(isset($attributes['profile_url']))$html.='<a href="'.$attributes['profile_url'].'">'.str_replace('&quot;','"',$attributes['author']??'').'</a>';else$html.=str_replace('&quot;','"',$attributes['author']??'');$html.=' '.htmlspecialchars($this->params['L_WROTE'].$this->params['L_COLON'],0);if(isset($attributes['post_url']))$html.=' <a href="'.$attributes['post_url'].'" data-post-id="'.$attributes['post_id'].'" onclick="if(document.getElementById(hash.substr(1)))href=hash">↑</a>';if(isset($attributes['msg_url']))$html.=' <a href="'.$attributes['msg_url'].'" data-msg-id="'.$attributes['msg_id'].'">↑</a>';if(isset($attributes['date']))$html.='<span class="responsive-hide">'.str_replace('&quot;','"',$attributes['date']??'').'</span>';$html.='</cite>';}break;case'REPORTERRE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe frameborder="0" loading="lazy" id="ausha-r1JH" height="220" style="border:none;width:100%;height:220px" src="https://player.ausha.co/index.html?podcastId='.htmlspecialchars($textContent,2).'&amp;v=3&amp;playerId=ausha-r1JH"></iframe><script src="https://player.ausha.co/ausha-player.js"></script>';break;case'RTE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://eco2mix.rte-france.com/pluginWeb/data?key='.htmlspecialchars($textContent,2).'" width="350" height="370"></iframe>';break;case'RTL':case'RTLBE':$textContent=$this->getQuickTextContent($xml);$html.='<div style="width:600px;height:338px"><script async="async" type="text/javascript" src="//www.rtl.be/videos/player/vp_embed.js" videoid="'.htmlspecialchars($textContent,2).'"></script></div>';break;case'RTS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="560" height="315" src="https://www.rts.ch/play/embed?urn=urn:rts:video:'.htmlspecialchars($textContent,2).'&amp;subdivisions=false" allowfullscreen="" allow="geolocation *; autoplay; encrypted-media"></iframe>';break;case'RUTUBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="720" height="405" src="//rutube.ru/video/embed/'.htmlspecialchars($textContent,2).'" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'SAPIENS':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="450" scrolling="no" frameborder="no" allow="autoplay" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/859584016&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe><div style="font-size:10px;color:#ccc;line-break:anywhere;word-break:normal;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight:100"><a href="https://soundcloud.com/user-702632852" title="Institut Sapiens" target="_blank" style="color:#ccc;text-decoration:none" rel="noreferrer">Institut Sapiens</a> · <a href="https://soundcloud.com/user-702632852/'.htmlspecialchars($textContent,2).'"></a></div>';break;case'SCRIB':$textContent=$this->getQuickTextContent($xml);$html.='<iframe class="scribd_iframe_embed" src="https://www.scribd.com/embeds/'.htmlspecialchars($textContent,2).'/content?start_page=1&amp;view_mode=scroll&amp;access_key=key-2imc0qq0kxk41ryg1wrd&amp;show_recommendations=false" data-auto-height="false" data-aspect-ratio="0.7729220222793488" scrolling="no" id="doc_25852" width="600" height="800" frameborder="0"></iframe>';break;case'SENAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'" width="640" height="430" frameborder="0" allowfullscreen="true" scrolling="no"></iframe>';break;case'SLIDE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.slideshare.net/slideshow/embed_code/key/'.htmlspecialchars($textContent,2).'" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #ccc;border-width:1px;margin-bottom:5px;max-width:100%" allowfullscreen=""> </iframe>';break;case'SOUNDCLOUD':case'UNO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($textContent,2).'&amp;color=ff5500"></iframe>';break;case'SPOTIFY':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://open.spotify.com/embed/show/'.htmlspecialchars($textContent,2).'" width="100%" height="232" frameborder="0" allowtransparency="true" allow="encrypted-media"></iframe>';break;case'STATIC':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="'.htmlspecialchars($textContent,2).'" width="480" height="270" frameborder="0" scrolling="no" allowfullscreen="allowfullscreen"></iframe>';break;case'TED':case'TED2':case'TED3':$textContent=$this->getQuickTextContent($xml);$html.='<div style="max-width:854px"><div style="position:relative;height:0;padding-bottom:56.25%"><iframe src="https://embed.ted.com/talks/lang/fr/'.htmlspecialchars($textContent,2).'" width="854" height="480" style="position:absolute;left:0;top:0;width:100%;height:100%" frameborder="0" scrolling="no" allowfullscreen=""></iframe></div></div>';break;case'TELEGRAMME':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://www.letelegramme.fr/static/ftp/dossier/data/dataviz/iframe/iframe.php?id='.htmlspecialchars($textContent,2).'" width="100%" height="400&quot;" style="max-width:100%" frameborder="0"></iframe>';break;case'TF1':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.tf1.fr/embedframe/'.htmlspecialchars($textContent,2).'" frameborder="0" style="width:640px;height:360px"></iframe>';break;case'TLG':$textContent=$this->getQuickTextContent($xml);$html.='<script async="" src="https://telegram.org/js/telegram-widget.js?19" data-telegram-post="'.htmlspecialchars($textContent,2).'" data-width="100%"></script>';break;case'ULTI':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/01946947/src/'.htmlspecialchars($textContent,2).'/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true" width="470" height="300" allow="autoplay; fullscreen"></iframe>';break;case'UNIGE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://elearn-services.unige.ch/medias/share/video?url=https://mediaserver.unige.ch/media/'.htmlspecialchars($textContent,2).'&amp;width=400&amp;height=304&amp;id=74063&amp;start=0" width="400" height="304" frameborder="0" allowfullscreen="1"></iframe>';break;case'UNIV':$textContent=$this->getQuickTextContent($xml);$html.='<iframe class="player" frameborder="0" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="'.htmlspecialchars($textContent,2).'" width="576" height="324"> </iframe>';break;case'VIDEOFIG':$textContent=$this->getQuickTextContent($xml);$html.='<object id="flashObj" width="800" height="450" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=4500912462001&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId='.htmlspecialchars($textContent,2).'&amp;playerID=1330248265001&amp;playerKey=AQ~~,AAAAjgltpmk~,3G6d8W41NOQ19IiTezZ7ZLKgEaJIflU4&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="800" height="450" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';break;case'VMO':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//player.vimeo.com/video/'.htmlspecialchars($textContent,2).'" width="640" height="470" frameborder="0" webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen=""></iframe>';break;case'WAT':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="http://www.wat.tv/embedframe/'.htmlspecialchars($textContent,2).'" frameborder="0" style="width:620px;height:350px"></iframe>';break;case'WID':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="https://ourworldindata.org/grapher/'.htmlspecialchars($textContent,2).'?tab=chart&amp;stackMode=absolute&amp;time=latest&amp;region=World" loading="lazy" style="width:100%;height:600px;border:0 none"></iframe>';break;case'WPVIDEO':$textContent=$this->getQuickTextContent($xml);$html.='<embed type="application/x-shockwave-flash" src="http://s0.videopress.com/player.swf?v=1.03" width="400" height="224" wmode="direct" seamlesstabbing="true" allowfullscreen="true" allowscriptaccess="always" overstretch="true" flashvars="guid='.htmlspecialchars($textContent,2).'&amp;isDynamicSeeking=true">';break;case'WSJ':$textContent=$this->getQuickTextContent($xml);$html.='<iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" width="512" height="288" src="https://video-api.wsj.com/api-video/player/v3/iframe.html?guid='.htmlspecialchars($textContent,2).'"></iframe>';break;case'YOUSCRIBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe src="//www.youscribe.com/BookReader/IframeEmbed?productId='.htmlspecialchars($textContent,2).'&amp;token=&amp;width=620&amp;height=917&amp;startPage=1&amp;displayMode=scroll&amp;fullscreen=0" allowfullscreen="" webkitallowfullscreen="" mozallowfullscreen="" frameborder="0" scrolling="no" width="620px" height="917px" marginwidth="0" marginheight="0" style="border:1px solid #44444a;width:620px;height:917px;margin:0;padding:0"></iframe>';break;case'YOUTUBE':$textContent=$this->getQuickTextContent($xml);$html.='<iframe width="480" height="360" src="//www.youtube.com/embed/'.htmlspecialchars($textContent,2).'" frameborder="0" allowfullscreen=""></iframe>';break;case'ZAD1':$textContent=$this->getQuickTextContent($xml);$html.='<object id="flashObj" width="480" height="270" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,47,0"><param name="movie" value="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1"><param name="bgcolor" value="#FFFFFF"><param name="flashVars" value="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID=1321210711001&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true"><param name="base" value="http://admin.brightcove.com"><param name="seamlesstabbing" value="false"><param name="allowFullScreen" value="true"><param name="swLiveConnect" value="true"><param name="allowScriptAccess" value="always"><embed src="http://c.brightcove.com/services/viewer/federated_f9?isVid=1&amp;isUI=1" bgcolor="#FFFFFF" flashvars="videoId=5174576313001&amp;linkBaseURL=http%3A%2F%2Frmc.bfmtv.com%2Fmediaplayer%2Fvideo%2Fzad-de-notre-dame-des-landes-royal-apporte-une-caution-aux-ultra-violents-877185.html&amp;playerID='.htmlspecialchars($textContent,2).'&amp;playerKey=AQ~~,AAAAzBtC-5k~,eFRORT_mCNHXsXCkXBktv6DjbyscgjRo&amp;domain=embed&amp;dynamicStreaming=true" base="http://admin.brightcove.com" name="flashObj" width="480" height="270" seamlesstabbing="false" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" swliveconnect="true" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></object>';}

		return $html;
	}
}