<?php
/**
 * This file is part of the French language pack for the
 * phpBB forum software.
 *
 * @copyright (c) phpBB Limited <https://www.phpbb.com>
 * @copyright (c) Qiaeru <https://www.qiaeru.com>
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 * For more information about the language pack, please visit
 * https://www.phpbb.com/customise/db/translation/french/
 */

/**
 * DO NOT CHANGE
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

$lang = array_merge($lang, [
	'HELP_BBCODE_BLOCK_IMAGES' => 'Affichage d’images dans les messages',
	'HELP_BBCODE_BLOCK_INTRO'  => 'Introduction',
	'HELP_BBCODE_BLOCK_LINKS'  => 'Insertion de liens',
	'HELP_BBCODE_BLOCK_LISTS'  => 'Genèse de listes',
	'HELP_BBCODE_BLOCK_OTHERS' => 'Divers',
	'HELP_BBCODE_BLOCK_QUOTES' => 'Citation et données de largeur fixe',
	'HELP_BBCODE_BLOCK_TEXT'   => 'Mise en forme du texte',

	'HELP_BBCODE_IMAGES_ATTACHMENT_ANSWER'   => 'Les pièces jointes peuvent dès à présent être transférées dans les messages en utilisant le nouveau BBCode « <strong>[attachment=][/attachment]</strong> », si cette fonctionnalité a été activée par les administrateurs du forum et si vous en avez les permissions appropriées. Pour transférer des pièces jointes en ligne, cliquez sur le bouton respectif après votre sélection depuis la liste déroulante dans la page de rédaction.',
	'HELP_BBCODE_IMAGES_ATTACHMENT_QUESTION' => 'Transfert de pièces jointes dans un message',
	'HELP_BBCODE_IMAGES_BASIC_ANSWER'        => 'Le BBCode de phpBB intègre une balise qui vous permet d’insérer des images dans vos messages. Les deux choses importantes à garder à l’esprit lors de l’utilisation des balises d’images sont que l’excès d’images dans les messages n’est pas apprécié par la plupart des d’utilisateurs et que l’image que vous souhaitez afficher doit être déjà disponible en ligne (elle ne peut pas exister seulement sur votre ordinateur, à moins que vous travailliez directement depuis un serveur internet !). Pour afficher une image, vous devez insérer entre les balises « <strong>[img][/img]</strong> » le lien pointant vers l’image. Par exemple :<br><br><strong>[img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/img]</strong><br><br>Comme noté précédemment dans la section des liens située ci-dessus, vous pouvez intégrer une image entre des balises « <strong>[url][/url]</strong> ». Par exemple :<br><br><strong>[url=https://www.phpbb.com/][img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/img][/url]</strong><br><br>Deviendra :<br><br><a href="https://www.phpbb.com/"><img src="https://www.phpbb.com/theme/images/logos/blue/160x52.png" alt="" /></a>',
	'HELP_BBCODE_IMAGES_BASIC_QUESTION'      => 'Ajout d’une image à un message',

	'HELP_BBCODE_INTRO_BBCODE_ANSWER'   => 'Le BBCode est une implémentation spéciale du code HTML. Vous pouvez utiliser le BBCode dans vos messages sur le forum sous réserve que cette fonctionnalité ait été autorisée par un administrateur. De plus, vous pouvez désactiver les BBCodes sur chacun de vos messages depuis le formulaire de rédaction. Le BBCode est similaire à l’architecture du code HTML, les balises sont contenues entre des crochets « [ » et « ] » à la place des chevrons « &lt; » et « &gt; », et il offre un meilleur contrôle sur la mise en forme. Selon le style que vous utilisez, vous pouvez trouver et utiliser très facilement du BBCode dans vos messages depuis une interface cliquable située juste au-dessus du formulaire de rédaction. Si ces brèves explications ne vous conviennent pas, vous pouvez consulter le guide suivant qui s’avère très explicite.',
	'HELP_BBCODE_INTRO_BBCODE_QUESTION' => 'Qu’est-ce que le BBCode ?',

	'HELP_BBCODE_LINKS_BASIC_ANSWER'   => 'Le BBCode de phpBB propose plusieurs manières de créer des liens.<ul><li>La première emploie la balise « <strong>[url=][/url]</strong> », où ce qui est inséré après le signe égal « = » fera agir le contenu de cette balise en tant que lien. Par exemple, pour insérer un lien vers phpBB.com, vous pouvez utiliser :<br><br><strong>[url=https://www.phpbb.com/]</strong>Visitez phpBB.com !<strong>[/url]</strong><br><br>Ceci génèrera le lien suivant : <a href="https://www.phpbb.com/">Visitez phpBB.com !</a> Veuillez noter que le lien peut s’ouvrir dans la même fenêtre ou dans une nouvelle fenêtre, selon les préférences du navigateur des utilisateurs.</li><li>Si vous souhaitez que le lien soit affiché comme un lien basique, vous pouvez employer simplement ceci :<br><br><strong>[url]</strong>https://www.phpbb.com/<strong>[/url]</strong><br><br>Ceci générera le lien suivant : <a href="https://www.phpbb.com/">https://www.phpbb.com/</a></li><li>De plus, une des fonctionnalités de phpBB permet d’insérer les <i>liens magiques</i>, ce qui transformera n’importe quel lien en lien syntaxiquement correct, sans que vous n’ayez besoin d’indiquer des balises ou même encore d’ajouter « https:// ». Par exemple, en écrivant « www.phpbb.com » dans votre message, ceci se complètera automatiquement en « <a href="https://www.phpbb.com/">www.phpbb.com</a> » lorsque vous verrez votre message par la suite.</li><li>La même chose est valable pour les adresses de courrier électronique, vous pouvez cependant indiquer une adresse explicite, par exemple :<br><br><strong>[email]</strong>inconnu@domaine.adr<strong>[/email]</strong><br><br>Ce qui deviendra : <a href="mailto:inconnu@domaine.adr">inconnu@domaine.adr</a>, ou vous pouvez simplement écrire « inconnu@domaine.adr » dans votre message et celui-ci sera automatiquement converti lors de la visualisation.</li></ul>Comme avec toutes les balises BBCode, vous pouvez insérer des liens autour d’autres balises comme « <strong>[img][/img]</strong> » (consultez la prochaine question), « <strong>[b][/b]</strong> », etc. Comme pour les balises de mise en forme, il vous appartient d’en assurer l’usage correct d’ouverture et de fermeture des balises, et ceci dans le bon ordre, comme par exemple :<br><br><strong>[url=https://www.phpbb.com/][img]</strong>https://www.phpbb.com/theme/images/logos/blue/160x52.png<strong>[/url][/img]</strong><br><br>N’est <span style="text-decoration: underline">pas</span> correct, ce qui peut mener à la suppression de votre message, soyez donc vigilant.',
	'HELP_BBCODE_LINKS_BASIC_QUESTION' => 'Insérer un lien vers un site internet',

	'HELP_BBCODE_LISTS_ORDERER_ANSWER'     => 'Le second type de liste, la liste ordonnée, vous donne le contrôle sur ce qui est affiché devant chaque article. Vous devez utiliser les balises « <strong>[list=1][/list]</strong> » afin de créer une liste numérotée, ou bien encore les balises « <strong>[list=a][/list]</strong> » afin de créer une liste alphabétique. Comme pour la liste non-ordonnée, les articles doivent être définis en utilisant la balise « <strong>[*]</strong> ». Par exemple :<br><br><strong>[list=1]</strong><br><strong>[*]</strong>Faire les boutiques<br><strong>[*]</strong>Acheter un nouvel ordinateur<br><strong>[*]</strong>Râler contre l’ordinateur lorsqu’il est bloqué<br><strong>[/list]</strong><br><br>Deviendra :<ol style="list-style-type: decimal;"><li>Faire les boutiques</li><li>Acheter un nouvel ordinateur</li><li>Râler contre l’ordinateur lorsqu’il est bloqué</li></ol>Pour créer une liste alphabétique, vous devez cependant utiliser :<br><br><strong>[list=a]</strong><br><strong>[*]</strong>La première réponse possible<br><strong>[*]</strong>La seconde réponse possible<br><strong>[*]</strong>La troisième réponse possible<br><strong>[/list]</strong><br><br>Ce qui deviendra :<ol style="list-style-type: lower-alpha"><li>La première réponse possible</li><li>La seconde réponse possible</li><li>La troisième réponse possible</li></ol><br><strong>[list=A]</strong><br><strong>[*]</strong>La première réponse possible<br><strong>[*]</strong>La seconde réponse possible<br><strong>[*]</strong>La troisième réponse possible<br><strong>[/list]</strong><br><br>Deviendra :<ol style="list-style-type: upper-alpha"><li>La première réponse possible</li><li>La seconde réponse possible</li><li>La troisième réponse possible</li></ol><br><strong>[list=i]</strong><br><strong>[*]</strong>La première réponse possible<br><strong>[*]</strong>La seconde réponse possible<br><strong>[*]</strong>La troisième réponse possible<br><strong>[/list]</strong><br><br>Deviendra :<ol style="list-style-type: lower-roman"><li>La première réponse possible</li><li>La seconde réponse possible</li><li>La troisième réponse possible</li></ol><br><strong>[list=I]</strong><br><strong>[*]</strong>La première réponse possible<br><strong>[*]</strong>La seconde réponse possible<br><strong>[*]</strong>La troisième réponse possible<br><strong>[/list]</strong><br><br>Deviendra :<ol style="list-style-type: upper-roman"><li>La première réponse possible</li><li>La seconde réponse possible</li><li>La troisième réponse possible</li></ol>',
	'HELP_BBCODE_LISTS_ORDERER_QUESTION'   => 'Création d’une liste ordonnée',
	'HELP_BBCODE_LISTS_UNORDERER_ANSWER'   => 'Le BBCode prend en charge deux types de liste, la liste ordonnée et la liste non-ordonnée. Elles sont pratiquement identiques par rapport à leur équivalent en HTML. Une liste non-ordonnée publie chaque article l’un après l’autre, en utilisant le caractère étoile. Pour créer une liste non-ordonnée, vous devez utiliser les balises « <strong>[list][/list]</strong> » et définir chaque article dans la liste en utilisant les balises « <strong>[*]</strong> ». Par exemple, pour lister vos couleurs favorites, vous pouvez utiliser :<br><br><strong>[list]</strong><br><strong>[*]</strong>Rouge<br><strong>[*]</strong>Bleu<br><strong>[*]</strong>Jaune<br><strong>[/list]</strong><br><br>Ce qui deviendra la liste :<ul><li>Rouge</li><li>Bleu</li><li>Jaune</li></ul><br>Vous pouvez également créer une liste à puces en utilisant « <strong>[list=disc][/list]</strong> », « <strong>[list=circle][/list]</strong> » ou « <strong>[list=square][/list]</strong> ».',
	'HELP_BBCODE_LISTS_UNORDERER_QUESTION' => 'Création d’une liste non-ordonnée',

	'HELP_BBCODE_OTHERS_CUSTOM_ANSWER'   => 'Si vous êtes un administrateur de ce forum et que vous en avez les permissions appropriées, vous pouvez ajouter davantage de BBCodes dans la section « Personnaliser les BBCodes ».',
	'HELP_BBCODE_OTHERS_CUSTOM_QUESTION' => 'Puis-je ajouter mes propres balises ?',

	'HELP_BBCODE_QUOTES_CODE_ANSWER'   => 'Si vous souhaitez insérer un fragment de code ou quelque chose qui demande une largeur fixe, comme la police de caractères « Courier », vous devez enfermer le texte entre les balises « <strong>[code][/code]</strong> ». Par exemple :<br><br><strong>[code]</strong>echo &quot;Ceci est un fragment de code&quot;;<strong>[/code]</strong><br><br>Toutes les balises de mise en forme présentes entre les balises « <strong>[code][/code]</strong> » sont conservées telles quelles lorsque vous consulterez le message ultérieurement.',
	'HELP_BBCODE_QUOTES_CODE_QUESTION' => 'Mise en forme de code ou de données de largeur fixe',
	'HELP_BBCODE_QUOTES_TEXT_ANSWER'   => 'Il y a deux manières de citer un texte, avec ou sans référence :<ul><li>Lorsque vous utilisez la fonction de citation afin de répondre à un message sur le forum, vous devriez noter que le texte qui est ajouté à la fenêtre du message est inséré entre les balises « <strong>[quote=&quot;&quot;][/quote]</strong> ». Cette méthode vous permet de citer, comme référence, une personne ou autre chose que vous choisissez de commenter ! Par exemple, pour citer une partie d’un texte rédigé par M. Blobby, vous devez saisir :<br><br><strong>[quote=&quot;M. Blobby&quot;]</strong>Le texte que M. Blobby a rédigé sera situé ici<strong>[/quote]</strong><br><br>Le rendu final, « M. Blobby a écrit », sera ajouté automatiquement avant le texte actuel. Gardez à l’esprit que vous devez <strong>obligatoirement</strong> insérer les guillemets anglais « &quot; &quot; » autour du nom que vous citez, ils ne sont pas optionnels.</li><li>La seconde méthode vous permet de citer quelque chose de manière anonyme. Pour l’utiliser, enfermez le texte entre les balises « <strong>[quote][/quote]</strong> ». Lorsque vous consulterez le message ultérieurement, il affichera simplement le texte dans un bloc de citation.</li></ul>',
	'HELP_BBCODE_QUOTES_TEXT_QUESTION' => 'Citation de texte dans les réponses',

	'HELP_BBCODE_TEXT_BASIC_ANSWER'     => 'Le BBCode inclut des balises qui vous permettent de modifier rapidement le style de votre texte brut. Ceci peut être effectué de différentes manières : <ul><li>Pour mettre une partie d’un texte en gras, il faut l’enfermer entre les balises « <strong>[b][/b]</strong> ». Par exemple :<br><br><strong>[b]</strong>Salut<strong>[/b]</strong><br><br>Deviendra : <strong>Salut</strong></li><li>Pour souligner une partie d’un texte, utilisez les balises « <strong>[u][/u]</strong> ». Par exemple :<br><br><strong>[u]</strong>Bonjour<strong>[/u]</strong><br><br>Deviendra : <span style="text-decoration: underline">Bonjour</span></li><li>Pour mettre une partie d’un texte en italique, utilisez les balises « <strong>[i][/i]</strong> ». Par exemple :<br><br>C’est <strong>[i]</strong>super !<strong>[/i]</strong><br><br>Deviendra : C’est <i>super !</i></li></ul>',
	'HELP_BBCODE_TEXT_BASIC_QUESTION'   => 'Comment puis-je mettre du texte en gras, en italique et en souligné ?',
	'HELP_BBCODE_TEXT_COLOR_ANSWER'     => 'Pour modifier la taille ou la couleur du texte, vous pourrez utiliser les balises suivantes. Cependant, gardez à l’esprit que le rendu visuel final dépendra également du navigateur internet et du système d’exploitation de l’utilisateur : <ul><li>Pour insérer une couleur sur une partie d’un texte, il faut l’enfermer entre les balises « <strong>[color=][/color]</strong> ». Vous pouvez saisir le nom d’une couleur reconnue, comme par exemple « red », « blue » ou « yellow », ou saisir directement son code hexadécimal, comme « #FFFFFF » ou « #000000 ». Par exemple, pour mettre une partie d’un texte en rouge, vous pouvez utiliser :<br><br><strong>[color=red]</strong>Salut !<strong>[/color]</strong><br><br>Ou encore :<br><br><strong>[color=#FF0000]</strong>Salut !<strong>[/color]</strong><br><br>Ce qui, dans les deux cas, deviendra : <span style="color:red">Salut !</span></li><li>Pour modifier la taille de la police de caractères d’une partie d’un texte, utilisez les balises « <strong>[size=][/size]</strong> ». Les balises dépendent du style que l’utilisateur a sélectionné, mais le format recommandé est une valeur numérique représentant la taille du texte en pourcentage, commençant de 50 (minuscule) et allant jusqu’à 200 (énorme). Par exemple :<br><br><strong>[size=30]</strong>MINUSCULE<strong>[/size]</strong><br><br>Deviendra : <span style="font-size:30%;">MINUSCULE</span><br><br>Alors que :<br><br><strong>[size=200]</strong>ÉNORME !<strong>[/size]</strong><br><br>Deviendra : <span style="font-size:200%;">ÉNORME !</span></li></ul>',
	'HELP_BBCODE_TEXT_COLOR_QUESTION'   => 'Comment puis-je modifier la taille ou la couleur du texte ?',
	'HELP_BBCODE_TEXT_COMBINE_ANSWER'   => 'Bien sûr ! Par exemple, pour obtenir l’attention de tout le monde, vous pouvez écrire :<br><br><strong>[size=200][color=red][b]</strong>REGARDEZ-MOI !<strong>[/b][/color][/size]</strong><br><br>Ce qui deviendra : <span style="color:red;font-size:200%;"><strong>REGARDEZ-MOI !</strong></span><br><br>Cependant, nous vous déconseillons fortement d’utiliser fréquemment ce genre de mise en forme ! Gardez à l’esprit qu’il faut simplement fermer les balises correctement et dans le bon ordre. Par exemple, ce qui suit est incorrect :<br><br><strong>[b][u]</strong>Ceci est incorrect<strong>[/b][/u]</strong>',
	'HELP_BBCODE_TEXT_COMBINE_QUESTION' => 'Puis-je combiner des balises de mise en forme ?',
]);
