<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<title>AFIS Gestion commandes</title>

<link rel="stylesheet" type="text/css" href="style.css">

</head>
<body>

<?php
require('inc/connexionBase.php');
require('inc/fonctions.php');

$attente_paiement = mysqli_query($link, "SELECT * FROM sps_commandes WHERE statut='En attente du paiement' ORDER BY date DESC");
$attente_validation = mysqli_query($link,"SELECT * FROM sps_commandes WHERE statut='Paiement reçu - En attente de validation' ORDER BY date DESC");
$attente_expedition = mysqli_query($link,"SELECT * FROM sps_commandes WHERE statut='Validée - En attente d\'expédition' ORDER BY date DESC");
$toutes = mysqli_query($link,"SELECT * FROM sps_commandes ORDER BY id DESC LIMIT 0,100");

$TotStats = mysqli_fetch_row(mysqli_query($link,"SELECT COUNT(id), SUM(total) FROM sps_commandes"));
$TermStats = mysqli_fetch_row(mysqli_query($link,"SELECT COUNT(id), SUM(total) FROM sps_commandes WHERE statut='Terminée'"));
$ExpStats = mysqli_fetch_row(mysqli_query($link,"SELECT COUNT(id), SUM(total) FROM sps_commandes WHERE statut='Expédiée'"));
$SPSStats = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE type IN ('HS', 'R')"));
$AboStats = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE type IN ('AF1','AF2','AE1','AE2', 'DF1', 'DF2', 'DE1', 'DE2', 'OS1')"));
$AdhStats = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE type='AD'"));

function details($id) {
	$detail = '';
	$sps = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE id_commande=$id AND type='R'"));
	$hs = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE id_commande=$id AND type='HS'"));
	$adh = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE id_commande=$id AND type='AD'"));
	$abo = mysqli_fetch_row(mysqli_query($link,"SELECT SUM(qte_produit) FROM sps_paniers WHERE id_commande=$id AND type IN ('AF1','AF2','AE1','AE2', 'DF1', 'DF2', 'DE1', 'DE2', 'OS1')"));

	if ($sps[0])
		$detail .= $sps[0].' SPS ';
	if ($hs[0])
		$detail .= $hs[0].' HS ';
	if ($adh[0])
		$detail .= $adh[0].' Adh ';
	if ($abo[0])
		$detail .= $abo[0].' Abo ';

	return $detail;
}

?>

<table border=1 width=30% align=right cellspacing=0>
<tr>
<th><i>Statistiques</i></th>
<th>Nombre</th>
<th>Somme</th>
</tr>

<tr>
<td><b>Total</b></td>
<td><b><?php echo $TotStats[0]; ?></b></td>
<td><b><?php echo affichePrix($TotStats[1]);?> €</b><td>
</tr>

<tr>
<td>Expédiées</td>
<td><?php echo $ExpStats[0]; ?></td>
<td><?php echo affichePrix($ExpStats[1]);?>€</td>
</tr>

<tr>
<td>Terminées</td>
<td><?php echo $TermStats[0]; ?></td>
<td><?php echo affichePrix($TermStats[1]);?>€</td>
</tr>

<tr>
<td>SPS (dont HS)</td>
<td><?php echo $SPSStats[0]; ?></td>
<td>-</td>
</tr>

<tr>
<td>Abos & Adhés</td>
<td><?php echo $AboStats[0].' + '.$AdhStats[0]; ?></td>
<td>-</td>
</tr>

</table>

<h1>AFIS - Gestion des commandes</h1>

<a href="/">Index</a> - <a href="stock.php">Stocks</a> - <a href="stats.php">Statistiques détaillées</a> - <a href="canceled.php">Commandes annulées</a>

<hr>
<br style="clear:both;"><br>

<table border=1 width=40% align=left cellspacing=0>
<caption>Commandes en attente de paiement</caption>
<tr>
 <th>Dernière màj</th>
 <th>Num</th>
 <th>Identité</th>
 <th>Somme</th>
 <th>Détail</th>
 <th>Type paiement</th>
</tr>

<?php while ($row = mysqli_fetch_array($attente_paiement)) { ?>
<tr>
 <td><?php echo $row['date']; ?></td>
 <td><a href="detail.php?id_commande=<?php echo $row['id']; ?>"><?php echo $row['id']; ?></a></td>
 <td><?php if ($row['e_nom']) {echo $row['e_nom'].' '.$row['e_prenom']; }else { echo $row['l_nom'].' '.$row['l_prenom']; } ?></td>
 <td><?php echo affichePrix($row['total']); ?>€</td>
 <td><?php echo details($row['id']); ?></td>
 <td><?php echo $row['type_paiement']; ?></td>
</tr>
<?php } ?>

</table>

<table border=1 width=58% align=right cellspacing=0>
<caption>Commandes en attente de validation</caption>
<tr>
 <th>Dernière màj</th>
 <th>Num</th>
 <th>Identité</th>
 <th>Somme</th>
 <th>Détail</th>
 <th>Type paiement</th>
 <th>Valider</th>
</tr>

<?php while ($row = mysqli_fetch_array($attente_validation)) { ?>
<tr>
 <td><?php echo $row['date']; ?></td>
 <td><a href="detail.php?id_commande=<?php echo $row['id']; ?>"><?php echo $row['id']; ?></a></td>
 <td><?php if ($row['e_nom']) {echo $row['e_nom'].' '.$row['e_prenom']; }else { echo $row['l_nom'].' '.$row['l_prenom']; } ?></td>
 <td><?php echo affichePrix($row['total']); ?>€</td>
 <td><?php echo details($row['id']); ?></td>
 <td><?php echo $row['type_paiement']; ?></td>
 <td align=center>
	<form action="action.php" method="post">
		<input type="hidden" name="id_commande" value="<?php echo $row['id']; ?>">
		<input type="hidden" name="act" value="valider">
		<input type="hidden" name="idx" value="1">
		<input type="submit" name="submit" value="Valider">
	</form>
 </td>
</tr>
<?php } ?>

</table>

<br style="clear:both;"><br>

<table border=1 width=49% align=left cellspacing=0>
<caption>Commandes en attente d'expédition - À transférer chez Archimède</caption>
<tr>
 <th>Dernière màj</th>
 <th>Num</th>
 <th>Identité</th>
 <th>Somme</th>
 <th>Détail</th>
 <th>Type paiement</th>
 <th>Voir</th>
</tr>

<?php while ($row = mysqli_fetch_array($attente_expedition)) { ?>
<tr>
 <td><?php echo $row['date']; ?></td>
 <td><?php echo $row['id']; ?></td>
 <td><?php if ($row['e_nom']) {echo $row['e_nom'].' '.$row['e_prenom']; }else { echo $row['l_nom'].' '.$row['l_prenom']; } ?></td>
 <td><?php echo affichePrix($row['total']); ?>€</td>
 <td><?php echo details($row['id']); ?></td>
 <td><?php echo $row['type_paiement']; ?></td>
 <td align=center><a href="detail.php?id_commande=<?php echo $row['id']; ?>">[lien]</a></td>
</tr>
<?php } ?>

<tr>
<td colspan=7 align=center>
<form action="action.php" method="post">
        <input type="hidden" name="act" value="expedier">
        <input type="submit" name="expedier" onclick="return confirm('Confirmer ?');" value="MARQUER TOUT COMME EXPÉDIÉ">
</form>
<form action="gencsv.php" method="get">
        <input class="gencsv" type="submit" name="expedier" value="EXPORTER EN CSV">
</form></td>
</tr>

</table>
<script>
$('form').submit(function() {
  $('input.gencsv').prop("disabled", "disabled");
})
</script>

<br style="clear:both;"><br>

<table border=1 width=75% align=center cellspacing=0>
<caption>Les 100 dernières  commandes</caption>
<tr>
 <th>Dernière màj</th>
 <th>Num</th>
 <th>Identité</th>
 <th>Somme</th>
 <th>Détail</th>
 <th>Type paiement</th>
 <th>Statut</th>
</tr>

<?php while ($row = mysqli_fetch_array($toutes)) { ?>
<tr>
 <td><?php echo $row['date']; ?></td>
 <td><a href="detail.php?id_commande=<?php echo $row['id']; ?>"><?php echo $row['id']; ?></a></td>
 <td><?php if ($row['e_nom']) {echo $row['e_nom'].' '.$row['e_prenom']; }else { echo $row['l_nom'].' '.$row['l_prenom']; } ?></td>
 <td><?php echo affichePrix($row['total']); ?>€</td>
 <td><?php echo details($row['id']); ?></td>
 <td><?php echo $row['type_paiement']; ?></td>
 <td><?php echo $row['statut']; ?></td>
</tr>
<?php } ?>

</table>


<?php mysqli_close($link); ?>

</body>
</html>
